/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.DTOs;

import Application.Modelos.Medicamento;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Actor;
import DataManager.GoogleHealthManager.ClasesAuxiliares.DateTime;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Direction;
import DataManager.GoogleHealthManager.ClasesAuxiliares.FulfillmentHistory;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Product;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Source;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Status;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MedicamentoDTO {
    private String name;
    private String idInterno;
    private String recetadoPor;
    private DateTime fechaInicio;
    private DateTime fechaFin;
    private DateTime fechaReceta;
    private Status estado;
    private String pacienteId;
    private Actor medico;
    private ArrayList<Product> listaProductos;
    private ArrayList<Direction> posologias;
    private ArrayList<FulfillmentHistory> historiales;

    public MedicamentoDTO() {
        this.listaProductos = new ArrayList();
        this.posologias = new ArrayList();
        this.historiales = new ArrayList();
        this.pacienteId = "";
        this.medico = null;
        this.name = "";
        this.recetadoPor = "";
    }

    public MedicamentoDTO(Medicamento medicamento) {
        this.listaProductos = medicamento.getListaProductos();
        this.posologias = medicamento.getPosologias();
        this.historiales = medicamento.getHistoriales();
        this.pacienteId = medicamento.getPacienteId();
        this.name = medicamento.getNombre();
        this.fechaFin = medicamento.getFechaFin();
        this.fechaInicio = medicamento.getFechaInicio();
        this.fechaReceta = medicamento.getFechaReceta();
        this.estado = medicamento.getEstado();
        this.idInterno = medicamento.getIdInterno();
    }

    public DateTime getFechaFin() {
        return this.fechaFin;
    }

    public void setFechaFin(DateTime fechaFin) {
        this.fechaFin = fechaFin;
    }

    public DateTime getFechaInicio() {
        return this.fechaInicio;
    }

    public void setFechaInicio(DateTime fechaInicio) {
        this.fechaInicio = fechaInicio;
    }

    public Actor getMedico() {
        return this.medico;
    }

    public void setMedico(Actor medicoId) {
        this.medico = medicoId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPacienteId() {
        return this.pacienteId;
    }

    public void setPacienteId(String pacienteId) {
        this.pacienteId = pacienteId;
    }

    public ArrayList<Product> getListaProductos() {
        return this.listaProductos;
    }

    public void setListaProductos(ArrayList<Product> listaProductos) {
        this.setListaProductos(listaProductos);
    }

    public void insertaFecha(DateTime fechaNueva) {
        if (fechaNueva.getType().equals("Prescription date")) {
            this.setFechaReceta(fechaNueva);
        }
        if (fechaNueva.getType().equals("Start date")) {
            this.setFechaInicio(fechaNueva);
        }
        if (fechaNueva.getType().equals("Stop date")) {
            this.setFechaFin(fechaNueva);
        }
    }

    public boolean insertaFuente(Source fuente1) {
        for (Actor persona : fuente1.getActors()) {
            if (!persona.getRole().get(0).equals("Prescribing clinician")) continue;
            this.setRecetadoPor(persona.getId());
            this.setMedico(persona);
            return true;
        }
        return fuente1.getActors().size() <= 0;
    }

    public ArrayList<Direction> getPosologias() {
        return this.posologias;
    }

    public void setPosologias(ArrayList<Direction> posologias) {
        this.posologias = posologias;
    }

    public ArrayList<FulfillmentHistory> getHistoriales() {
        return this.historiales;
    }

    public void setHistoriales(ArrayList<FulfillmentHistory> historiales) {
        this.historiales = historiales;
    }

    public Status getEstado() {
        return this.estado;
    }

    public void setEstado(Status estado) {
        this.estado = estado;
    }

    public String getRecetadoPor() {
        return this.recetadoPor;
    }

    public void setRecetadoPor(String recetadoPor) {
        this.recetadoPor = recetadoPor;
    }

    public DateTime getFechaReceta() {
        return this.fechaReceta;
    }

    public void setFechaReceta(DateTime fechaReceta) {
        this.fechaReceta = fechaReceta;
    }

    public String getIdInterno() {
        return this.idInterno;
    }

    public void setIdInterno(String idInterno) {
        this.idInterno = idInterno;
    }
}

