/*
 * Decompiled with CFR 0.152.
 */
package Application.Herramientas;

import Application.Herramientas.TiposDeGrafico;
import Application.Modelos.Analisis;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.util.TableOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graficas {
    private static final String SITIO_2 = "www.sitio1.com";
    private static final String SITIO_1 = "www.sitio2.com";
    private static final String BARCHART_JPG = "chart.jpg";

    public void mostrarGraficaGlucemia(ArrayList<Analisis> Glucemias, String name) {
        DefaultCategoryDataset dataset = null;
        dataset = this.introducirDatos(Glucemias, name);
        JFreeChart chart = null;
        for (TiposDeGrafico i : TiposDeGrafico.values()) {
            chart = this.createChart((CategoryDataset)dataset, TiposDeGrafico.BarChart3D);
        }
        ChartPanel panel = new ChartPanel(chart);
        JFrame ventana = new JFrame("El grafico");
        ventana.getContentPane().add((Component)panel);
        ventana.pack();
        ventana.setVisible(true);
        ventana.setDefaultCloseOperation(3);
    }

    private JFreeChart createChart(CategoryDataset dataset, TiposDeGrafico tipo) {
        JFreeChart chart;
        switch (tipo) {
            case AreaChart: {
                chart = ChartFactory.createAreaChart((String)"Glucemia", (String)"Fecha", (String)"Valor Glucemia", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
                break;
            }
            case BarChart: {
                chart = ChartFactory.createBarChart((String)"Glucemia", (String)"Fecha", (String)"Valor Glucemia", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
                break;
            }
            case BarChart3D: {
                chart = ChartFactory.createBarChart3D((String)"Glucemia", (String)"Fecha", (String)"Valor Glucemia", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
                break;
            }
            case LineChart: {
                chart = ChartFactory.createLineChart((String)"Glucemia", (String)"Fecha", (String)"Valor Glucemia", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
                break;
            }
            case LineChart3D: {
                chart = ChartFactory.createLineChart3D((String)"Glucemia", (String)"Fecha", (String)"Valor Glucemia", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
                break;
            }
            case MultiplePieChart: {
                chart = ChartFactory.createMultiplePieChart((String)"Visitas", (CategoryDataset)dataset, (TableOrder)TableOrder.BY_COLUMN, (boolean)true, (boolean)true, (boolean)true);
                break;
            }
            case MultiplePieChart3D: {
                chart = ChartFactory.createMultiplePieChart3D((String)"Visitas", (CategoryDataset)dataset, (TableOrder)TableOrder.BY_COLUMN, (boolean)true, (boolean)true, (boolean)true);
                break;
            }
            default: {
                chart = null;
            }
        }
        return chart;
    }

    private DefaultCategoryDataset introducirDatos(ArrayList<Analisis> lista, String nombre) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Analisis g : lista) {
            int value = Integer.valueOf(g.getResultadosTest().get(0).getValorObtenido());
            dataset.setValue((double)value, (Comparable)((Object)nombre), (Comparable)g.getResultadosTest().get(0).getFecha());
            dataset.setValue((double)(-value), (Comparable)((Object)"margarito"), (Comparable)g.getResultadosTest().get(0).getFecha());
        }
        return dataset;
    }
}

