/*
 * Decompiled with CFR 0.152.
 */
package Application.Vistas.Dialogos;

import Application.Controladores.ControladorMedicationView;
import Application.Herramientas.CommonTools;
import Application.Modelos.Medicamento;
import Application.Vistas.Dialogos.DialogoElegirNombreDeListado;
import Application.Vistas.Interfaces.MedicamentoView;
import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.LineBorder;

public class DialogoDetallesMedicamento
extends JDialog
implements MedicamentoView {
    ControladorMedicationView controlador;
    boolean saved;
    private JButton buttonAceptar;
    private JCheckBox checkBoxActivo;
    private JComboBox comboBoxForma;
    private JComboBox comboBoxFrecuencia;
    private JComboBox comboBoxVia;
    private JDateChooser dateChooserFechaFin;
    private JDateChooser dateChooserFechaInicio;
    private JButton jButton1;
    private JTextField jTextFielUnidadesTotal;
    private JLabel labelCantidad;
    private JLabel labelCantidadDiaria;
    private JLabel labelCantidadTotal;
    private JLabel labelFechaFIn;
    private JLabel labelFechaInicio;
    private JLabel labelFormaMedicamento;
    private JLabel labelMedicacion;
    private JLabel labelTitulo;
    private JLabel labelUnidadesTotal;
    private JLabel labelVia;
    private JPanel panelBotones;
    private JPanel panelDescripcion;
    private JPanel panelPosologia;
    private JPanel panelReceta;
    private JSpinner spinnerCantidad;
    private JSpinner spinnerCantidadDiaria;
    private JSpinner spinnerCantidadTotal;
    private JTextField textFieldMedicacion;
    private JTextField textFieldUnidades;
    private JTextField textFieldUnidadesProducto;

    public DialogoDetallesMedicamento(Frame parent, boolean modal, String nombre, String idPaciente) {
        super(parent, modal);
        this.initComponents();
        this.getContentPane().setBackground(Color.white);
        this.controlador = new ControladorMedicationView(idPaciente, nombre);
        this.controlador.addViewToModel(this);
        this.textFieldMedicacion.setText(nombre);
        this.dateChooserFechaFin.setDate(new Date());
        this.dateChooserFechaInicio.setDate(new Date());
        this.saved = false;
        CommonTools.centrarVentana(this);
    }

    public DialogoDetallesMedicamento(Frame parent, boolean modal, Medicamento modelo, String idPaciente) {
        super(parent, modal);
        this.initComponents();
        this.getContentPane().setBackground(Color.white);
        this.controlador = new ControladorMedicationView(idPaciente, modelo);
        this.controlador.addViewToModel(this);
        this.rellenarDatos();
        this.buttonAceptar.setVisible(false);
        this.saved = true;
        CommonTools.centrarVentana(this);
    }

    public static Medicamento insertarNuevoMedicamento(String idPacienteOwner) {
        String nombreNuevoMedicamento = DialogoElegirNombreDeListado.selectNewMedicamento();
        if (nombreNuevoMedicamento != null) {
            DialogoDetallesMedicamento dialog = new DialogoDetallesMedicamento(null, true, nombreNuevoMedicamento, idPacienteOwner);
            return dialog.getMedicamentoAsociado();
        }
        return null;
    }

    private void rellenarDatos() {
        this.textFieldMedicacion.setText(this.controlador.getModelo().getNombre());
        String[] strenght = this.controlador.getModelo().getListaProductos().get(0).getStrentgh().get(0).split(" ");
        this.spinnerCantidad.setValue(Integer.parseInt(strenght[0]));
        this.textFieldUnidadesProducto.setText(strenght[1]);
        this.checkBoxActivo.getModel().setSelected(this.controlador.getModelo().getEstado().getEstado().equalsIgnoreCase("Active"));
        this.comboBoxForma.setSelectedItem(this.controlador.getModelo().getListaProductos().get(0).getForm().get(0));
        this.spinnerCantidadDiaria.setValue(Integer.parseInt(this.controlador.getModelo().getPosologias().get(0).getListaDosis().get(0).getValor()));
        this.textFieldUnidadesProducto.setText(this.controlador.getModelo().getPosologias().get(0).getListaDosis().get(0).getUnidades());
        this.comboBoxFrecuencia.setSelectedItem(this.controlador.getModelo().getPosologias().get(0).getListaFrecuencias().get(0));
        this.comboBoxVia.setSelectedItem(this.controlador.getModelo().getPosologias().get(0).getListaVias().get(0));
        String[] fecha = this.controlador.getModelo().getFechaInicio().getExactDateTime().split("-");
        this.dateChooserFechaInicio.setDate(new Date(Integer.parseInt(fecha[0]), Integer.parseInt(fecha[1]), Integer.parseInt(fecha[2])));
        fecha = this.controlador.getModelo().getFechaFin().getExactDateTime().split("-");
        this.dateChooserFechaFin.setDate(new Date(Integer.parseInt(fecha[0]), Integer.parseInt(fecha[1]), Integer.parseInt(fecha[2])));
    }

    private String comprobarDatos() {
        if (this.dateChooserFechaInicio.getDate().after(this.dateChooserFechaFin.getDate())) {
            return "La fecha de comienzo del tratamiento debe ser anterior a la de fin";
        }
        String fechaInicio = CommonTools.getDateAsString(this.dateChooserFechaInicio.getDate());
        String fechaFin = CommonTools.getDateAsString(this.dateChooserFechaFin.getDate());
        boolean estado = this.checkBoxActivo.isSelected();
        String fechaActual = CommonTools.getDateAsString(new Date());
        if (this.textFieldMedicacion.getText().isEmpty()) {
            return "El nombre del medicamento no puede estar en blanco";
        }
        String productName = this.textFieldMedicacion.getText();
        if ((Integer)this.spinnerCantidad.getValue() <= 0) {
            return "La dosis del medicamento debe ser mayor que cero";
        }
        String cantidadDosis = Integer.toString((Integer)this.spinnerCantidad.getValue());
        if (this.textFieldUnidadesProducto.getText().isEmpty()) {
            return "El campo unidades no puede estar en blanco";
        }
        String unidadesDosis = this.textFieldUnidadesProducto.getText();
        String forma = (String)this.comboBoxForma.getSelectedItem();
        if ((Integer)this.spinnerCantidadDiaria.getValue() <= 0) {
            return "La posolog\u00eda del medicamento debe ser mayor que cero";
        }
        String valorPosologia = Integer.toString((Integer)this.spinnerCantidadDiaria.getValue());
        if (this.textFieldUnidades.getText().isEmpty()) {
            return "El campo unidades no puede estar en blanco";
        }
        String unidadesPosologia = this.textFieldUnidades.getText();
        String via = (String)this.comboBoxVia.getSelectedItem();
        String frecuencia = (String)this.comboBoxFrecuencia.getSelectedItem();
        String valorF = Integer.toString((Integer)this.spinnerCantidadTotal.getValue());
        String unidadesF = this.jTextFielUnidadesTotal.getText();
        this.controlador.insertNewMedication(productName, estado, fechaInicio, fechaFin, fechaActual, cantidadDosis, unidadesDosis, forma, valorPosologia, unidadesPosologia, via, frecuencia, fechaActual, valorF, unidadesF);
        return null;
    }

    public Medicamento getMedicamentoAsociado() {
        if (this.saved) {
            return this.controlador.getModelo();
        }
        return null;
    }

    public void updateView() {
        this.rellenarDatos();
    }

    private void initComponents() {
        this.panelPosologia = new JPanel();
        this.labelFechaInicio = new JLabel();
        this.dateChooserFechaInicio = new JDateChooser();
        this.labelFechaFIn = new JLabel();
        this.dateChooserFechaFin = new JDateChooser();
        this.labelCantidadDiaria = new JLabel();
        this.spinnerCantidadDiaria = new JSpinner();
        this.textFieldUnidades = new JTextField();
        this.labelVia = new JLabel();
        this.comboBoxVia = new JComboBox();
        this.comboBoxFrecuencia = new JComboBox();
        this.panelDescripcion = new JPanel();
        this.labelCantidad = new JLabel();
        this.comboBoxForma = new JComboBox();
        this.labelFormaMedicamento = new JLabel();
        this.spinnerCantidad = new JSpinner();
        this.labelMedicacion = new JLabel();
        this.textFieldMedicacion = new JTextField();
        this.textFieldUnidadesProducto = new JTextField();
        this.checkBoxActivo = new JCheckBox();
        this.panelReceta = new JPanel();
        this.labelCantidadTotal = new JLabel();
        this.spinnerCantidadTotal = new JSpinner();
        this.labelUnidadesTotal = new JLabel();
        this.jTextFielUnidadesTotal = new JTextField();
        this.panelBotones = new JPanel();
        this.buttonAceptar = new JButton();
        this.jButton1 = new JButton();
        this.labelTitulo = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setBackground(new Color(255, 255, 255));
        this.setLocationByPlatform(true);
        this.setMinimumSize(new Dimension(863, 318));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.panelPosologia.setBorder(BorderFactory.createTitledBorder(null, "Posolog\u00eda", 1, 2));
        this.panelPosologia.setOpaque(false);
        this.labelFechaInicio.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelFechaInicio.setText("Fecha Inicio");
        this.labelFechaFIn.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelFechaFIn.setText("Fecha Fin");
        this.labelCantidadDiaria.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelCantidadDiaria.setText("Cantidad diaria");
        this.spinnerCantidadDiaria.setPreferredSize(new Dimension(60, 20));
        this.textFieldUnidades.setText("[unidades]");
        this.labelVia.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelVia.setText("Via");
        this.comboBoxVia.setModel(new DefaultComboBoxModel<String>(new String[]{"Oral", "Oft\u00e1lmica", "T\u00f3pica", "Aurica", "Nasal", "Intramuscular", "Inhalatoria", "Intraarticular", "Vaginal", "Subcutanea", "Rectal", "Sublingual", "Bucal", "Intraperitoneal", "Intratecal", "Intraplural"}));
        this.comboBoxFrecuencia.setModel(new DefaultComboBoxModel<String>(new String[]{"Cada 2 horas", "Cada 4 horas", "Cada 6 horas", "Cada 8 horas ", "Cada 12 horas", "1 vez al d\u00eda", "1 vez al d\u00eda por la ma\u00f1ana", "1 vez al d\u00eda por la tarde", "1 vez al d\u00eda por la noche ", "2 veces al d\u00eda", "3 veces al d\u00eda", "3 veces al d\u00eda, antes de la comida", "3 veces al d\u00eda, con la comida", "4 veces al d\u00eda", "1 vez por semana", "Cada 2 semanas", "Mensualmente", "Cuando se necesite"}));
        GroupLayout panelPosologiaLayout = new GroupLayout(this.panelPosologia);
        this.panelPosologia.setLayout(panelPosologiaLayout);
        panelPosologiaLayout.setHorizontalGroup(panelPosologiaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPosologiaLayout.createSequentialGroup().addContainerGap().addGroup(panelPosologiaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPosologiaLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(panelPosologiaLayout.createSequentialGroup().addComponent(this.labelFechaInicio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dateChooserFechaInicio, -2, 123, -2).addGap(10, 10, 10).addComponent(this.labelFechaFIn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dateChooserFechaFin, -2, 118, -2)).addGroup(panelPosologiaLayout.createSequentialGroup().addComponent(this.labelCantidadDiaria).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.spinnerCantidadDiaria, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldUnidades, -2, 66, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxFrecuencia, 0, 0, Short.MAX_VALUE))).addGroup(panelPosologiaLayout.createSequentialGroup().addComponent(this.labelVia).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxVia, -2, 77, -2))).addContainerGap(424, Short.MAX_VALUE)));
        panelPosologiaLayout.setVerticalGroup(panelPosologiaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPosologiaLayout.createSequentialGroup().addContainerGap().addGroup(panelPosologiaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPosologiaLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelFechaFIn).addComponent((Component)this.dateChooserFechaFin, -2, -1, -2)).addGroup(panelPosologiaLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.dateChooserFechaInicio, -2, -1, -2).addComponent(this.labelFechaInicio))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelPosologiaLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelCantidadDiaria).addComponent(this.spinnerCantidadDiaria, -1, -1, Short.MAX_VALUE).addComponent(this.textFieldUnidades).addComponent(this.comboBoxFrecuencia, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelPosologiaLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelVia).addComponent(this.comboBoxVia, -2, -1, -2)).addContainerGap()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 11, 2, 11);
        this.getContentPane().add((Component)this.panelPosologia, gridBagConstraints);
        this.panelDescripcion.setBorder(BorderFactory.createTitledBorder(null, "Descripci\u00f3n", 1, 2));
        this.panelDescripcion.setOpaque(false);
        this.labelCantidad.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelCantidad.setText("Cantidad");
        this.comboBoxForma.setModel(new DefaultComboBoxModel<String>(new String[]{"Capsulas", "Inyecciones", "Pastillas", "Tabletas", "Liquido", "Parche", "Crema", "Gel", "Aerosol", "Loci\u00f3n", "Ung\u00fcento", "Inhalado \t", "Colutorio\t", "Champ\u00fa", "Jab\u00f3n", "Enema", "Polvos", "Intrauterino", "Anillo"}));
        this.comboBoxForma.setPreferredSize(new Dimension(160, 20));
        this.labelFormaMedicamento.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelFormaMedicamento.setText("Forma");
        this.spinnerCantidad.setPreferredSize(new Dimension(60, 20));
        this.labelMedicacion.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelMedicacion.setText("Medicamento:");
        this.textFieldUnidadesProducto.setText("[unidades]");
        this.checkBoxActivo.setText("Medicamento activo");
        this.checkBoxActivo.setOpaque(false);
        GroupLayout panelDescripcionLayout = new GroupLayout(this.panelDescripcion);
        this.panelDescripcion.setLayout(panelDescripcionLayout);
        panelDescripcionLayout.setHorizontalGroup(panelDescripcionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDescripcionLayout.createSequentialGroup().addGroup(panelDescripcionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDescripcionLayout.createSequentialGroup().addComponent(this.labelMedicacion).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldMedicacion, -2, 459, -2).addGap(18, 18, 18).addComponent(this.checkBoxActivo)).addGroup(panelDescripcionLayout.createSequentialGroup().addComponent(this.labelCantidad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerCantidad, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldUnidadesProducto, -2, 66, -2).addGap(18, 18, 18).addComponent(this.labelFormaMedicamento).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.comboBoxForma, -2, -1, -2))).addContainerGap(136, Short.MAX_VALUE)));
        panelDescripcionLayout.setVerticalGroup(panelDescripcionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDescripcionLayout.createSequentialGroup().addGroup(panelDescripcionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelMedicacion).addComponent(this.textFieldMedicacion, -2, -1, -2).addComponent(this.checkBoxActivo)).addGap(18, 18, 18).addGroup(panelDescripcionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelCantidad, -1, 21, Short.MAX_VALUE).addGroup(panelDescripcionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spinnerCantidad, 0, 0, Short.MAX_VALUE).addComponent(this.textFieldUnidadesProducto).addComponent(this.comboBoxForma, -1, -1, Short.MAX_VALUE).addComponent(this.labelFormaMedicamento, -1, 20, Short.MAX_VALUE))).addContainerGap()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 130;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 11, 2, 11);
        this.getContentPane().add((Component)this.panelDescripcion, gridBagConstraints);
        this.panelReceta.setBorder(BorderFactory.createTitledBorder(""));
        this.panelReceta.setMinimumSize(new Dimension(311, 33));
        this.panelReceta.setOpaque(false);
        this.panelReceta.setPreferredSize(new Dimension(311, 33));
        this.panelReceta.setLayout(new BoxLayout(this.panelReceta, 2));
        this.labelCantidadTotal.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelCantidadTotal.setText("Cantidad administrada");
        this.panelReceta.add(this.labelCantidadTotal);
        this.spinnerCantidadTotal.setMaximumSize(new Dimension(50, 20));
        this.spinnerCantidadTotal.setMinimumSize(new Dimension(50, 20));
        this.spinnerCantidadTotal.setPreferredSize(new Dimension(50, 20));
        this.panelReceta.add(this.spinnerCantidadTotal);
        this.labelUnidadesTotal.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelUnidadesTotal.setText("Unidades");
        this.panelReceta.add(this.labelUnidadesTotal);
        this.jTextFielUnidadesTotal.setMaximumSize(new Dimension(50, 20));
        this.jTextFielUnidadesTotal.setMinimumSize(new Dimension(50, 20));
        this.jTextFielUnidadesTotal.setPreferredSize(new Dimension(50, 20));
        this.panelReceta.add(this.jTextFielUnidadesTotal);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 11, 2, 11);
        this.getContentPane().add((Component)this.panelReceta, gridBagConstraints);
        this.panelBotones.setOpaque(false);
        this.panelBotones.setLayout(new BoxLayout(this.panelBotones, 2));
        this.buttonAceptar.setBackground(new Color(255, 255, 255));
        this.buttonAceptar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonAceptar.setForeground(new Color(0, 102, 255));
        this.buttonAceptar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/accept 24x24.png")));
        this.buttonAceptar.setText("Aceptar");
        this.buttonAceptar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonAceptar.setContentAreaFilled(false);
        this.buttonAceptar.setHorizontalAlignment(2);
        this.buttonAceptar.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAceptar.setMaximumSize(new Dimension(100, 24));
        this.buttonAceptar.setMinimumSize(new Dimension(100, 24));
        this.buttonAceptar.setPreferredSize(new Dimension(100, 24));
        this.buttonAceptar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoDetallesMedicamento.this.buttonAceptarActionPerformed(evt);
            }
        });
        this.panelBotones.add(this.buttonAceptar);
        this.jButton1.setBackground(new Color(255, 255, 255));
        this.jButton1.setFont(new Font("Trebuchet MS", 1, 14));
        this.jButton1.setForeground(new Color(0, 102, 255));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/back 24x24.png")));
        this.jButton1.setText("Cerrar");
        this.jButton1.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.jButton1.setContentAreaFilled(false);
        this.jButton1.setHorizontalAlignment(2);
        this.jButton1.setMargin(new Insets(2, 2, 2, 2));
        this.jButton1.setMaximumSize(new Dimension(100, 24));
        this.jButton1.setMinimumSize(new Dimension(100, 24));
        this.jButton1.setPreferredSize(new Dimension(100, 24));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoDetallesMedicamento.this.jButton1ActionPerformed(evt);
            }
        });
        this.panelBotones.add(this.jButton1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 11, 2, 0);
        this.getContentPane().add((Component)this.panelBotones, gridBagConstraints);
        this.labelTitulo.setBackground(new Color(0, 153, 255));
        this.labelTitulo.setFont(new Font("Trebuchet MS", 0, 18));
        this.labelTitulo.setForeground(new Color(255, 255, 255));
        this.labelTitulo.setText("Medicamento");
        this.labelTitulo.setMaximumSize(new Dimension(400, 40));
        this.labelTitulo.setMinimumSize(new Dimension(400, 40));
        this.labelTitulo.setOpaque(true);
        this.labelTitulo.setPreferredSize(new Dimension(400, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.labelTitulo, gridBagConstraints);
        this.pack();
    }

    private void buttonAceptarActionPerformed(ActionEvent evt) {
        String errores = this.comprobarDatos();
        if (errores == null) {
            this.saved = true;
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, "Por favor, revise los datos introducidos \n" + errores, "Atenci\u00f3n, datos err\u00f3neos", 2);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

