/*
 * Decompiled with CFR 0.152.
 */
package Application.Vistas.Dialogos;

import Application.Herramientas.CommonTools;
import Application.Herramientas.GraficaGlucemias;
import Application.Modelos.Analisis;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogoGraficas
extends JDialog {
    ChartPanel panelGrafica = null;
    ArrayList<Analisis> listaAnalisis1;
    ArrayList<Analisis> listaAnalisis2;
    int tipoGrafica = 1;
    boolean mostrarAnalisis1 = true;
    boolean mostrarAnalisis2 = false;
    private JRadioButtonMenuItem area;
    private JRadioButtonMenuItem barras;
    private JRadioButtonMenuItem barras3d;
    private ButtonGroup buttonGroup1;
    private JCheckBox checkboxGlucemia;
    private JCheckBox checkboxInsulina;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JLabel labelTitulo;
    private JRadioButtonMenuItem lineal;
    private JRadioButtonMenuItem lineal3d;
    private JPanel panelOpcionesGraficas;

    public DialogoGraficas(Frame parent, boolean modal, ArrayList<Analisis> listaAnalisis1, ArrayList<Analisis> listaAnalisis2, String titulo) {
        super(parent, modal);
        this.initComponents();
        this.getContentPane().setBackground(Color.white);
        this.labelTitulo.setText(titulo);
        this.listaAnalisis1 = listaAnalisis1;
        this.listaAnalisis2 = listaAnalisis2;
        this.actualizarGrafica();
        CommonTools.centrarVentana(this);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.labelTitulo = new JLabel();
        this.panelOpcionesGraficas = new JPanel();
        this.checkboxInsulina = new JCheckBox();
        this.checkboxGlucemia = new JCheckBox();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenu3 = new JMenu();
        this.lineal = new JRadioButtonMenuItem();
        this.barras = new JRadioButtonMenuItem();
        this.lineal3d = new JRadioButtonMenuItem();
        this.barras3d = new JRadioButtonMenuItem();
        this.area = new JRadioButtonMenuItem();
        this.setDefaultCloseOperation(2);
        this.setTitle("Gr\u00e1ficas");
        this.setAlwaysOnTop(true);
        this.setMinimumSize(new Dimension(850, 525));
        this.getContentPane().setLayout(new GridBagLayout());
        this.labelTitulo.setBackground(new Color(0, 153, 255));
        this.labelTitulo.setFont(new Font("Trebuchet MS", 1, 14));
        this.labelTitulo.setForeground(new Color(255, 255, 255));
        this.labelTitulo.setText("Titulo");
        this.labelTitulo.setMaximumSize(new Dimension(400, 40));
        this.labelTitulo.setMinimumSize(new Dimension(400, 40));
        this.labelTitulo.setOpaque(true);
        this.labelTitulo.setPreferredSize(new Dimension(400, 40));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.labelTitulo, gridBagConstraints);
        this.panelOpcionesGraficas.setLayout(new BoxLayout(this.panelOpcionesGraficas, 2));
        this.checkboxInsulina.setText("Gr\u00e1fica Insulina");
        this.checkboxInsulina.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DialogoGraficas.this.checkboxInsulinaItemStateChanged(evt);
            }
        });
        this.panelOpcionesGraficas.add(this.checkboxInsulina);
        this.checkboxGlucemia.setSelected(true);
        this.checkboxGlucemia.setText("Grafica Glucemia");
        this.checkboxGlucemia.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                DialogoGraficas.this.checkboxGlucemiaStateChanged(evt);
            }
        });
        this.panelOpcionesGraficas.add(this.checkboxGlucemia);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        this.getContentPane().add((Component)this.panelOpcionesGraficas, gridBagConstraints);
        this.jMenu1.setText("Archivo");
        this.jMenuItem1.setText("Guardar como .jpg");
        this.jMenuItem1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DialogoGraficas.this.jMenuItem1MouseClicked(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setText("Cerrar");
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Opciones");
        this.jMenu3.setText("Opciones de visualizaci\u00f3n");
        this.buttonGroup1.add(this.lineal);
        this.lineal.setSelected(true);
        this.lineal.setText("Ver como gr\u00e1fica lineal");
        this.lineal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoGraficas.this.linealActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.lineal);
        this.buttonGroup1.add(this.barras);
        this.barras.setText("Ver como diagrama de barras");
        this.barras.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoGraficas.this.barrasActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.barras);
        this.buttonGroup1.add(this.lineal3d);
        this.lineal3d.setText("Ver como gr\u00e1fica lineal 3D");
        this.lineal3d.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoGraficas.this.lineal3dActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.lineal3d);
        this.buttonGroup1.add(this.barras3d);
        this.barras3d.setText("Ver como diagrama de barras 3D");
        this.barras3d.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoGraficas.this.barras3dActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.barras3d);
        this.buttonGroup1.add(this.area);
        this.area.setText("Ver como diagrama de \u00e1rea");
        this.area.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoGraficas.this.areaActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.area);
        this.jMenu2.add(this.jMenu3);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void jMenuItem1MouseClicked(MouseEvent evt) {
    }

    private void actualizarGrafica() {
        if (this.panelGrafica != null) {
            this.remove((Component)this.panelGrafica);
        }
        Object p = null;
        ArrayList<Analisis> aux1 = this.listaAnalisis1;
        ArrayList<Analisis> aux2 = this.listaAnalisis2;
        if (!this.mostrarAnalisis1) {
            aux1 = null;
        }
        if (!this.mostrarAnalisis2) {
            aux2 = null;
        }
        this.panelGrafica = GraficaGlucemias.mostrarGrafica(aux1, aux2, this.tipoGrafica);
        this.panelGrafica.setPreferredSize(new Dimension(850, 450));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.panelGrafica, gridBagConstraints);
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void linealActionPerformed(ActionEvent evt) {
        this.tipoGrafica = 1;
        this.actualizarGrafica();
    }

    private void barrasActionPerformed(ActionEvent evt) {
        this.tipoGrafica = 2;
        this.actualizarGrafica();
    }

    private void lineal3dActionPerformed(ActionEvent evt) {
        this.tipoGrafica = 3;
        this.actualizarGrafica();
    }

    private void barras3dActionPerformed(ActionEvent evt) {
        this.tipoGrafica = 4;
        this.actualizarGrafica();
    }

    private void areaActionPerformed(ActionEvent evt) {
        this.tipoGrafica = 5;
        this.actualizarGrafica();
    }

    private void checkboxGlucemiaStateChanged(ChangeEvent evt) {
        this.mostrarAnalisis1 = this.checkboxGlucemia.isSelected();
        this.actualizarGrafica();
    }

    private void checkboxInsulinaItemStateChanged(ItemEvent evt) {
        this.mostrarAnalisis2 = this.checkboxInsulina.isSelected();
        this.actualizarGrafica();
    }
}

