/*
 * Decompiled with CFR 0.152.
 */
package Application.Vistas.Dialogos;

import Application.Controladores.ControladorAnalisisView;
import Application.Herramientas.CellRenderJButton;
import Application.Herramientas.CommonTools;
import Application.Herramientas.GlucemiasXML;
import Application.Modelos.Analisis;
import Application.Modelos.ResultadoTest;
import Application.Vistas.Interfaces.AnalisisView;
import Application.Vistas.Paneles.PanelInsulinaGlucemias;
import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogoNuevaGlucemia
extends JDialog
implements AnalisisView {
    ControladorAnalisisView controlador;
    boolean saved;
    ArrayList<String> comentarios = new ArrayList();
    private JButton buttonAceptar;
    private JButton buttonCancelar;
    private JButton buttonImportarXML;
    private JButton buttonInsertar;
    private JDateChooser dateChooserFechaGlucemia;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel labelHora;
    private JLabel labelTitulo;
    private JLabel labelValor;
    private JPanel panelGlucemia;
    private JPanel panelInferior;
    private JSpinner spinnerHora;
    private JTable tablaGlucemias;
    private JTextArea textAreaComentarios;
    private JTextField textFieldValorMedido;

    private DialogoNuevaGlucemia(Frame parent, boolean modal, String idPacienteOwner) {
        super(parent, modal);
        this.initComponents();
        this.getContentPane().setBackground(Color.white);
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.spinnerHora.getEditor()).getTextField();
        DefaultFormatterFactory factory = (DefaultFormatterFactory)tf.getFormatterFactory();
        DateFormatter formatter = (DateFormatter)factory.getDefaultFormatter();
        formatter.setFormat(new SimpleDateFormat("HH:mm"));
        this.tablaGlucemias.getColumnModel().getColumn(0).setMaxWidth(0);
        this.tablaGlucemias.getColumnModel().getColumn(0).setMinWidth(0);
        this.tablaGlucemias.getColumnModel().getColumn(0).setPreferredWidth(0);
        this.tablaGlucemias.setAutoCreateRowSorter(true);
        this.tablaGlucemias.getRowSorter().toggleSortOrder(0);
        this.controlador = new ControladorAnalisisView(idPacienteOwner, new Analisis());
        this.controlador.getModelo().setTipoAnalisis("Glucemia");
        this.saved = false;
        this.getContentPane().setBackground(Color.white);
        CommonTools.centrarVentana(this);
    }

    public static Analisis showDialogNuevaGlucemia(String idPacienteOwner) {
        DialogoNuevaGlucemia dialog = new DialogoNuevaGlucemia(null, true, idPacienteOwner);
        return dialog.getGlucemia();
    }

    private Analisis getGlucemia() {
        if (this.saved) {
            return this.controlador.getModelo();
        }
        return null;
    }

    private String comprobarDatos() {
        if (this.dateChooserFechaGlucemia.getDate() != null) {
            Date fechaToma = this.dateChooserFechaGlucemia.getDate();
            int horaSpinner = ((Date)this.spinnerHora.getValue()).getHours();
            int minutosSpinner = ((Date)this.spinnerHora.getValue()).getMinutes();
            fechaToma.setHours(horaSpinner);
            fechaToma.setMinutes(minutosSpinner);
            if (fechaToma.after(new Date())) {
                return "\tFecha err\u00f3nea, no puede ser una fecha futura.\n";
            }
            if (this.textFieldValorMedido.getText().isEmpty()) {
                return "\tValor de la toma err\u00f3neo o en blanco. \n";
            }
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm");
            ImageIcon icon = new ImageIcon(this.getClass().getResource("../img/iconos/delete 16x16.png"));
            JButton boton = new JButton("Eliminar entrada", icon);
            boton.setFont(new Font("Tahoma", 0, 8));
            ((DefaultTableModel)this.tablaGlucemias.getModel()).addRow(new Object[]{fechaToma.getTime(), sdf.format(fechaToma), Double.parseDouble(this.textFieldValorMedido.getText()), boton});
            this.comentarios.add(this.textAreaComentarios.getText());
            return null;
        }
        return "\tFecha err\u00f3nea o en blanco. \n";
    }

    private void initComponents() {
        this.panelGlucemia = new JPanel();
        this.jLabel1 = new JLabel();
        this.dateChooserFechaGlucemia = new JDateChooser();
        this.labelHora = new JLabel();
        this.spinnerHora = new JSpinner();
        this.labelValor = new JLabel();
        this.textFieldValorMedido = new JTextField();
        this.jLabel2 = new JLabel();
        this.buttonInsertar = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.textAreaComentarios = new JTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.tablaGlucemias = new JTable();
        this.buttonImportarXML = new JButton();
        this.panelInferior = new JPanel();
        this.buttonAceptar = new JButton();
        this.buttonCancelar = new JButton();
        this.labelTitulo = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Registrar nueva glucemia");
        this.setAlwaysOnTop(true);
        this.setMinimumSize(new Dimension(539, 372));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.panelGlucemia.setOpaque(false);
        this.panelGlucemia.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Tahoma", 0, 12));
        this.jLabel1.setText("Fecha de la toma:");
        this.panelGlucemia.add((Component)this.jLabel1, new GridBagConstraints());
        this.dateChooserFechaGlucemia.setMinimumSize(new Dimension(100, 20));
        this.panelGlucemia.add((Component)this.dateChooserFechaGlucemia, new GridBagConstraints());
        this.labelHora.setFont(new Font("Tahoma", 0, 12));
        this.labelHora.setText("Hora");
        this.panelGlucemia.add((Component)this.labelHora, new GridBagConstraints());
        this.spinnerHora.setModel(new SpinnerDateModel(new Date(), null, null, 12));
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.spinnerHora.getEditor()).getTextField();
        DefaultFormatterFactory factory = (DefaultFormatterFactory)tf.getFormatterFactory();
        DateFormatter formatter = (DateFormatter)factory.getDefaultFormatter();
        formatter.setFormat(new SimpleDateFormat("hh:00 a"));
        this.panelGlucemia.add((Component)this.spinnerHora, new GridBagConstraints());
        this.labelValor.setText("Valor:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelGlucemia.add((Component)this.labelValor, gridBagConstraints);
        this.textFieldValorMedido.setMinimumSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 55;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 32);
        this.panelGlucemia.add((Component)this.textFieldValorMedido, gridBagConstraints);
        this.jLabel2.setText("mg/dl");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.panelGlucemia.add((Component)this.jLabel2, gridBagConstraints);
        this.buttonInsertar.setBackground(new Color(255, 255, 255));
        this.buttonInsertar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonInsertar.setForeground(new Color(0, 102, 255));
        this.buttonInsertar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/add 24x24.png")));
        this.buttonInsertar.setText("Insertar");
        this.buttonInsertar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonInsertar.setContentAreaFilled(false);
        this.buttonInsertar.setHorizontalAlignment(2);
        this.buttonInsertar.setMaximumSize(new Dimension(83, 22));
        this.buttonInsertar.setMinimumSize(new Dimension(83, 22));
        this.buttonInsertar.setPreferredSize(new Dimension(83, 22));
        this.buttonInsertar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoNuevaGlucemia.this.buttonInsertarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.panelGlucemia.add((Component)this.buttonInsertar, gridBagConstraints);
        this.jScrollPane2.setOpaque(false);
        this.textAreaComentarios.setColumns(20);
        this.textAreaComentarios.setFont(new Font("Trebuchet MS", 0, 12));
        this.textAreaComentarios.setLineWrap(true);
        this.textAreaComentarios.setRows(3);
        this.textAreaComentarios.setTabSize(3);
        this.textAreaComentarios.setWrapStyleWord(true);
        this.textAreaComentarios.setBorder(BorderFactory.createTitledBorder("Observaciones"));
        this.jScrollPane2.setViewportView(this.textAreaComentarios);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelGlucemia.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 47;
        gridBagConstraints.insets = new Insets(7, 0, 8, 0);
        this.getContentPane().add((Component)this.panelGlucemia, gridBagConstraints);
        this.jScrollPane1.setMaximumSize(new Dimension(500, Short.MAX_VALUE));
        this.jScrollPane1.setMinimumSize(new Dimension(500, 300));
        this.jScrollPane1.setPreferredSize(new Dimension(500, 300));
        this.tablaGlucemias.setModel(new DefaultTableModel(new Object[0][], new String[]{"ValorFecha", "Fecha", "Valor Obtenido", "Eliminar"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Long.class, String.class, Double.class, Object.class};
                this.canEdit = new boolean[]{false, false, true, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tablaGlucemias.setDefaultRenderer(Object.class, new CellRenderJButton());
        this.tablaGlucemias.setFillsViewportHeight(true);
        this.tablaGlucemias.setMinimumSize(new Dimension(559, 0));
        this.tablaGlucemias.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tablaGlucemias);
        this.tablaGlucemias.getColumnModel().getColumn(0).setResizable(false);
        this.tablaGlucemias.getColumnModel().getColumn(1).setResizable(false);
        this.tablaGlucemias.getColumnModel().getColumn(2).setResizable(false);
        this.tablaGlucemias.getColumnModel().getColumn(3).setResizable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.buttonImportarXML.setBackground(new Color(255, 255, 255));
        this.buttonImportarXML.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonImportarXML.setForeground(new Color(0, 102, 255));
        this.buttonImportarXML.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/search 24x24.png")));
        this.buttonImportarXML.setText("Importar desde XML");
        this.buttonImportarXML.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonImportarXML.setContentAreaFilled(false);
        this.buttonImportarXML.setHorizontalAlignment(2);
        this.buttonImportarXML.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoNuevaGlucemia.this.buttonImportarXMLActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 7, 0);
        this.getContentPane().add((Component)this.buttonImportarXML, gridBagConstraints);
        this.panelInferior.setLayout(new BoxLayout(this.panelInferior, 2));
        this.buttonAceptar.setBackground(new Color(255, 255, 255));
        this.buttonAceptar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonAceptar.setForeground(new Color(0, 102, 255));
        this.buttonAceptar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/accept 24x24.png")));
        this.buttonAceptar.setText("Aceptar");
        this.buttonAceptar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonAceptar.setContentAreaFilled(false);
        this.buttonAceptar.setHorizontalAlignment(2);
        this.buttonAceptar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoNuevaGlucemia.this.buttonAceptarActionPerformed(evt);
            }
        });
        this.panelInferior.add(this.buttonAceptar);
        this.buttonCancelar.setBackground(new Color(255, 255, 255));
        this.buttonCancelar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonCancelar.setForeground(new Color(0, 102, 255));
        this.buttonCancelar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/back 24x24.png")));
        this.buttonCancelar.setText("Cancelar");
        this.buttonCancelar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonCancelar.setContentAreaFilled(false);
        this.buttonCancelar.setHorizontalAlignment(2);
        this.buttonCancelar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoNuevaGlucemia.this.buttonCancelarActionPerformed(evt);
            }
        });
        this.panelInferior.add(this.buttonCancelar);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 243, 7, 0);
        this.getContentPane().add((Component)this.panelInferior, gridBagConstraints);
        this.labelTitulo.setBackground(new Color(0, 153, 255));
        this.labelTitulo.setFont(new Font("Trebuchet MS", 0, 18));
        this.labelTitulo.setForeground(new Color(255, 255, 255));
        this.labelTitulo.setText("Insertar nueva glucemia");
        this.labelTitulo.setMaximumSize(new Dimension(400, 40));
        this.labelTitulo.setMinimumSize(new Dimension(400, 40));
        this.labelTitulo.setOpaque(true);
        this.labelTitulo.setPreferredSize(new Dimension(400, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(1, 0, 7, 0);
        this.getContentPane().add((Component)this.labelTitulo, gridBagConstraints);
        this.pack();
    }

    private void buttonAceptarActionPerformed(ActionEvent evt) {
        this.extraerGlucemiasTabla();
        if (this.controlador.insertarAnalisisVariosResultados()) {
            this.saved = true;
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, "Hubo un error al guardar los datos, por favor verifique la informaci\u00f3n y vuelva a intentarlo");
        }
    }

    private void extraerGlucemiasTabla() {
        for (int i = 0; i < this.tablaGlucemias.getRowCount(); ++i) {
            Date fechaGlucemia = new Date((Long)this.tablaGlucemias.getValueAt(i, 0));
            Double valor = (Double)this.tablaGlucemias.getValueAt(i, 2);
            ResultadoTest res = new ResultadoTest();
            res.setFecha(fechaGlucemia);
            res.setTipoFecha("Collection start date");
            res.setTipoTest("Glucemia");
            res.setUnidadesObtenido("mg/dl");
            res.setValorNormal("[70 - 100]");
            res.setValorObtenido("" + valor);
            res.setObservaciones(this.comentarios.get(i));
            Analisis analisis = new Analisis();
            analisis.insertNewResultTest(res);
            analisis.setTipoAnalisis("Glucemia");
            this.controlador.getModelo().insertNewResultTest(res);
        }
    }

    private void buttonInsertarActionPerformed(ActionEvent evt) {
        String erroresEncontrados = this.comprobarDatos();
        if (erroresEncontrados != null) {
            JOptionPane.showMessageDialog(this, "Por favor, revise los datos introducidos \n" + erroresEncontrados, "Atenci\u00f3n, datos err\u00f3neos", 2);
        }
    }

    private void buttonCancelarActionPerformed(ActionEvent evt) {
        if (!this.saved) {
            int option = JOptionPane.showConfirmDialog(this, "No se han guardado los cambios, \u00bfSeguro que desea cerrar sin guardar?", "\u00a1Atenci\u00f3n, cambios no guardados!", 2);
            if (option == 0) {
                this.saved = false;
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    private void buttonImportarXMLActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Archivo XML", "xml", "XML");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            System.out.println("You chose to open this file: " + chooser.getSelectedFile().getName());
            File archivo = chooser.getSelectedFile();
            String ruta = archivo.getAbsolutePath();
            try {
                ArrayList<GlucemiasXML> glucemiasXml = this.obtener(ruta);
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm");
                for (GlucemiasXML glucemia : glucemiasXml) {
                    ((DefaultTableModel)this.tablaGlucemias.getModel()).addRow(new Object[]{glucemia.getFecha().getTimeInMillis(), sdf.format(glucemia.getFecha().getTime()), glucemia.getGlucemia().doubleValue(), null});
                }
            }
            catch (JDOMException ex) {
                JOptionPane.showMessageDialog(this, "No se han introducido los valores del fichero, es posible que alg\u00fan valor sea err\u00f3neo o que el fichero no siga el modelo necesario", "\u00a1Atenci\u00f3n, error al importar!", 0);
                Logger.getLogger(PanelInsulinaGlucemias.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(PanelInsulinaGlucemias.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(this, "Error al tratar de leer el fichero", "\u00a1Atenci\u00f3n, error al importar!", 0);
            }
        }
    }

    private ArrayList<GlucemiasXML> obtener(String ruta) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder(false);
        Document doc = builder.build(ruta);
        Element raiz = doc.getRootElement();
        List records = raiz.getChildren("RECORD");
        System.out.println("Formada por:" + records.size() + " equipos");
        Iterator i = records.iterator();
        ArrayList<GlucemiasXML> listGlucemias = new ArrayList<GlucemiasXML>();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            Element record = e.getChild("ROW");
            String DATEEVENT = record.getAttributeValue("DATEEVENT");
            String modFecha = DATEEVENT.replace(',', '.');
            Double parseADouble = Double.parseDouble(modFecha);
            Calendar fecha = DialogoNuevaGlucemia.parserFecha(parseADouble);
            String TIMESLOT = record.getAttributeValue("TIMESLOT");
            if (!record.getAttributeValue("EVENTTYPE").equals("1")) continue;
            String KEY0 = record.getAttributeValue("KEY0");
            GlucemiasXML glucemiasXML = new GlucemiasXML();
            glucemiasXML.setFecha(fecha);
            glucemiasXML.setPeriodo(TIMESLOT);
            glucemiasXML.setGlucemia(Integer.parseInt(KEY0));
            listGlucemias.add(glucemiasXML);
        }
        return listGlucemias;
    }

    private static Calendar parserFecha(Double num) {
        Calendar fecha = Calendar.getInstance();
        fecha.set(1899, 11, 30, 0, 0, 0);
        System.out.println(fecha.getTime().toString());
        double dias = Math.floor(num);
        num = num - dias;
        num = 24.0 * num;
        double horas = Math.floor(num);
        num = num - horas;
        num = 60.0 * num;
        double minutos = Math.floor(num);
        num = num - minutos;
        num = 60.0 * num;
        double segundos = Math.floor(num);
        fecha.add(5, (int)dias);
        fecha.add(10, (int)horas);
        fecha.add(12, (int)minutos);
        fecha.add(13, (int)segundos);
        return fecha;
    }

    @Override
    public void updateView() {
    }
}

