/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager;

import DataManager.GoogleHealthManager.ClasesAuxiliares.Tupla;
import com.google.gdata.client.Query;
import com.google.gdata.client.health.HealthService;
import com.google.gdata.data.Category;
import com.google.gdata.data.Entry;
import com.google.gdata.data.Feed;
import com.google.gdata.data.ICategory;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.health.ContinuityOfCareRecord;
import com.google.gdata.data.health.ProfileEntry;
import com.google.gdata.data.health.ProfileFeed;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.XmlBlob;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conector {
    private static String FEED_BASE_PATH = "http://www.google.com/health/feeds/";
    private static String PROFILE_FEED_PATH = FEED_BASE_PATH + "profile/ui/";
    private static String PROFILE_LIST_URL_PATH = "http://www.google.com/health/feeds/profile/list/";
    private HealthService healthService = new HealthService("HealthLogin");
    private static String user = "";
    private static String pass = "";
    private static Conector _conector = null;

    private Conector() throws AuthenticationException {
        try {
            this.healthService.setUserCredentials(user, pass);
        }
        catch (AuthenticationException ex) {
            Logger.getLogger(Conector.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void setCredentials(String user, String pass) {
        Conector.user = user;
        Conector.pass = pass;
    }

    public static String getPass() {
        return pass;
    }

    public static String getUser() {
        return user;
    }

    public String getProfileData(String idPaciente) throws IOException, ServiceException {
        URL feedUri = new URL(Conector.getPROFILE_FEED_PATH() + idPaciente);
        Query query = new Query(feedUri);
        query.addCustomParameter(new Query.CustomParameter("digest", "true"));
        ProfileFeed profileFeed = (ProfileFeed)this.getHealthService().getFeed(query, ProfileFeed.class);
        return ((ProfileEntry)profileFeed.getEntries().get(0)).getContinuityOfCareRecord().getXmlBlob().getBlob();
    }

    public ArrayList<Tupla> getAllProfileNamesAndIds() throws MalformedURLException, ServiceException, IOException {
        ArrayList<Tupla> profileNames = new ArrayList<Tupla>();
        Feed profileListFeed = (Feed)this.getHealthService().getFeed(new URL(Conector.getPROFILE_LIST_URL_PATH()), Feed.class);
        for (Entry profileListEntry : profileListFeed.getEntries()) {
            String id = profileListEntry.getId().replace(Conector.getPROFILE_LIST_URL_PATH(), "");
            Tupla elem = new Tupla(id, profileListEntry.getTitle().getPlainText());
            profileNames.add(elem);
        }
        return profileNames;
    }

    public String getDataByCategory(String idPaciente, String category, boolean digest) throws MalformedURLException, ServiceException, IOException {
        URL feedUri = new URL(Conector.getPROFILE_FEED_PATH() + idPaciente);
        Query query = new Query(feedUri);
        if (digest) {
            query.addCustomParameter(new Query.CustomParameter("digest", "true"));
        }
        query.addCategoryFilter(new Query.CategoryFilter((ICategory)new Category(category)));
        ProfileFeed profileFeed = (ProfileFeed)this.getHealthService().getFeed(query, ProfileFeed.class);
        return ((ProfileEntry)profileFeed.getEntries().get(0)).getContinuityOfCareRecord().getXmlBlob().getBlob();
    }

    public String insert(String identificador, String XMLdata) throws IOException, ServiceException {
        ProfileFeed profileFeed = Conector.getConector().getProfileData(identificador, true);
        ProfileEntry entry2 = (ProfileEntry)profileFeed.createEntry();
        entry2.setContinuityOfCareRecord(new ContinuityOfCareRecord());
        entry2.getContinuityOfCareRecord().setXmlBlob(new XmlBlob());
        entry2.getContinuityOfCareRecord().getXmlBlob().setBlob(XMLdata);
        String url = Conector.getPROFILE_FEED_PATH() + identificador;
        entry2 = (ProfileEntry)this.getHealthService().insert(new URL(url), (IEntry)entry2);
        return entry2.getId().replaceFirst(url + "/", "");
    }

    public void update(String identificador, String xmlText, String idInterno) throws IOException, ServiceException {
        ProfileFeed profileFeed = Conector.getConector().getProfileData(identificador, true);
        ProfileEntry entry = (ProfileEntry)profileFeed.createEntry();
        entry.setContinuityOfCareRecord(new ContinuityOfCareRecord());
        entry.getContinuityOfCareRecord().setXmlBlob(new XmlBlob());
        entry.getContinuityOfCareRecord().getXmlBlob().setBlob(xmlText);
        String url = Conector.getPROFILE_FEED_PATH() + identificador + "/" + idInterno;
        this.getHealthService().update(new URL(url), (IEntry)entry);
    }

    public void remove(String idPaciente, String idObjeto) throws IOException, ServiceException {
        this.getHealthService().delete(new URL(Conector.getPROFILE_FEED_PATH() + idPaciente + "/" + idObjeto));
    }

    public static String getPROFILE_LIST_URL_PATH() {
        return PROFILE_LIST_URL_PATH;
    }

    private ProfileFeed getProfileData(String ui, boolean digest) throws IOException, ServiceException {
        URL feedUri = new URL(Conector.getPROFILE_FEED_PATH() + ui);
        Query query = new Query(feedUri);
        if (digest) {
            query.addCustomParameter(new Query.CustomParameter("digest", "true"));
        }
        ProfileFeed profileFeed = (ProfileFeed)this.getHealthService().getFeed(query, ProfileFeed.class);
        return profileFeed;
    }

    public HealthService getHealthService() {
        return this.healthService;
    }

    public void setHealthService(HealthService healthService) {
        this.healthService = healthService;
    }

    public static Conector getConector() throws AuthenticationException {
        if (_conector == null) {
            _conector = new Conector();
        }
        return _conector;
    }

    public static Conector getConector(String user, String password) throws AuthenticationException {
        Conector.setCredentials(user, password);
        return Conector.getConector();
    }

    public static String getFEED_BASE_PATH() {
        return FEED_BASE_PATH;
    }

    public static void setFEED_BASE_PATH(String aFEED_BASE_PATH) {
        FEED_BASE_PATH = aFEED_BASE_PATH;
    }

    public static String getPROFILE_FEED_PATH() {
        return PROFILE_FEED_PATH;
    }

    public static void setPROFILE_FEED_PATH(String aPROFILE_FEED_PATH) {
        PROFILE_FEED_PATH = aPROFILE_FEED_PATH;
    }

    public static void setPROFILE_LIST_URL_PATH(String aPROFILE_LIST_URL_PATH) {
        PROFILE_LIST_URL_PATH = aPROFILE_LIST_URL_PATH;
    }

    public static void setConector(Conector aConector) {
        _conector = aConector;
    }
}

