/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.DAOs;

import DataManager.GoogleHealthManager.Conector;
import DataManager.GoogleHealthManager.DAOs.AnalisisDAOGH;
import DataManager.GoogleHealthManager.DAOs.Interfaces.MedicationDAO;
import DataManager.GoogleHealthManager.DTOs.MedicamentoDTO;
import DataManager.GoogleHealthManager.Interpreters.MedicamentosInterpreter;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MedicamentosDAOGH
implements MedicationDAO {
    @Override
    public ArrayList<MedicamentoDTO> getAllMedications(String idPaciente) {
        try {
            String XMLData = Conector.getConector().getProfileData(idPaciente);
            ArrayList<MedicamentoDTO> lista = new MedicamentosInterpreter().translateCCRtoDTO(XMLData);
            System.out.println("Medication retrieved successfully");
            return lista;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        catch (ServiceException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR DE SERVICIO ESTAS BIEN ACREDITADO??");
        }
        catch (IOException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        catch (XmlException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR AL CONVERTIR EL CCR EN DTO");
        }
        System.err.println("Medication retrieval failed");
        return null;
    }

    @Override
    public String insertMedication(MedicamentoDTO m, String identificador) {
        String XMLCode = new MedicamentosInterpreter().translateDTOtoCCR(m);
        try {
            String newId = Conector.getConector().insert(identificador, XMLCode);
            System.out.println("Medication inserted successfully");
            return newId;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        catch (ServiceException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR DE SERVICIO ESTAS BIEN ACREDITADO??");
        }
        catch (IOException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        System.out.println("Medication inserting failed");
        return null;
    }

    @Override
    public boolean removeMedication(String idMedicamento, String idPaciente) {
        try {
            Conector.getConector().remove(idPaciente, idMedicamento);
            System.out.println("Medication removed successfully");
            return true;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        catch (ServiceException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR DE SERVICIO ESTAS BIEN ACREDITADO??");
        }
        catch (IOException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        System.out.println("Medication removing failed");
        return false;
    }

    @Override
    public boolean updateMedication(MedicamentoDTO m, String idPaciente) {
        String XMLCode = new MedicamentosInterpreter().translateDTOtoCCR(m);
        try {
            Conector.getConector().update(idPaciente, XMLCode, m.getIdInterno());
            System.out.println("Medication updated successfully");
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(MedicamentosDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ServiceException ex) {
            Logger.getLogger(MedicamentosDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("Medication updating failed");
        return false;
    }
}

