/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.DTOs;

import Application.Modelos.Problemas;
import DataManager.GoogleHealthManager.ClasesAuxiliares.DateTime;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Description;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Source;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Status;

public class ProblemsDTO {
    private DateTime fechaInicio;
    private DateTime fechaFin;
    private Status estado;
    private Description description;
    private Source source;
    private String idInterno;

    public ProblemsDTO(Problemas problema) {
        this.fechaInicio = new DateTime();
        this.fechaFin = new DateTime();
        this.estado = new Status();
        this.description = new Description();
        this.description = problema.getDescripcionProblema();
        this.fechaInicio = problema.getFechaInicio();
        this.fechaFin = problema.getFechaFin();
        this.estado = problema.getStatus();
        this.idInterno = problema.getIdInterno();
    }

    public ProblemsDTO() {
        this.fechaInicio = new DateTime();
        this.fechaFin = new DateTime();
        this.estado = new Status();
        this.description = new Description();
        this.source = new Source();
    }

    public ProblemsDTO(DateTime _fechaInicio, DateTime _fechaFin, Status _status, Description _description, Source _source) {
        this.fechaInicio = new DateTime(_fechaInicio);
        this.fechaFin = new DateTime(_fechaFin);
        this.estado = new Status(_status);
        this.description = new Description(_description);
        this.source = new Source(_source);
    }

    public ProblemsDTO(String fechaInicio, String fechaFin, String status, String description) {
        if (fechaInicio != null) {
            this.fechaInicio = new DateTime(fechaInicio, "Start Date");
        }
        if (fechaFin != null) {
            this.fechaFin = new DateTime(fechaFin, "End Date");
        }
        if (status != null) {
            this.estado = new Status(status);
        }
        if (description != null) {
            this.description = new Description(description, null);
        }
    }

    public DateTime getFechaInicio() {
        return this.fechaInicio;
    }

    public void setFechaInicio(DateTime fechaInicio) {
        this.fechaInicio = fechaInicio;
    }

    public DateTime getFechaFin() {
        return this.fechaFin;
    }

    public void setFechaFin(DateTime fechaFin) {
        this.fechaFin = fechaFin;
    }

    public Status getEstado() {
        return this.estado;
    }

    public void setEstado(Status estado) {
        this.estado = estado;
    }

    public void insertaFecha(DateTime fecha1) {
        if (fecha1.getType().equalsIgnoreCase("Start date")) {
            this.setFechaInicio(fecha1);
        }
        if (fecha1.getType().equalsIgnoreCase("Stop date")) {
            this.setFechaFin(fecha1);
        }
    }

    public void insertaDescription(Description _description) {
        this.setDescription(_description);
    }

    public void insertaFuente(Source _fuente) {
        this.setSource(_fuente);
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public String toString() {
        String codigo = "\nFecha de Inicio:" + this.getFechaInicio().toString();
        codigo = codigo + "\nFecha de Fin :" + this.getFechaFin().toString();
        codigo = codigo + this.getSource().toString();
        codigo = codigo + this.getDescription().toString();
        codigo = codigo + this.getSource().toString();
        return codigo;
    }

    public String getIdInterno() {
        return this.idInterno;
    }

    public void setIdInterno(String idInterno) {
        this.idInterno = idInterno;
    }
}

