/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.Interpreters;

import DataManager.GoogleHealthManager.ClasesAuxiliares.Actor;
import DataManager.GoogleHealthManager.ClasesAuxiliares.DateTime;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Direction;
import DataManager.GoogleHealthManager.ClasesAuxiliares.FulfillmentHistory;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Product;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Source;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Status;
import DataManager.GoogleHealthManager.DTOs.MedicamentoDTO;
import com.google.code.ccr4j.ActorReferenceType;
import com.google.code.ccr4j.CodedDescriptionType;
import com.google.code.ccr4j.ContinuityOfCareRecordDocument;
import com.google.code.ccr4j.DateTimeType;
import com.google.code.ccr4j.DirectionDocument;
import com.google.code.ccr4j.DirectionsDocument;
import com.google.code.ccr4j.FrequencyType;
import com.google.code.ccr4j.MeasureType;
import com.google.code.ccr4j.OrderRxHistoryType;
import com.google.code.ccr4j.SourceType;
import com.google.code.ccr4j.StructuredProductType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MedicamentosInterpreter {
    public ArrayList<MedicamentoDTO> translateCCRtoDTO(String dataCCRAsString) throws XmlException {
        ContinuityOfCareRecordDocument xmlParseado = ContinuityOfCareRecordDocument.Factory.parse((String)(dataCCRAsString = this.formatearCodigoXML(dataCCRAsString)));
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord CCR = xmlParseado.getContinuityOfCareRecord();
        if (CCR.getBody().getMedications() != null) {
            List MedicationList = CCR.getBody().getMedications().getMedicationList();
            Iterator it = MedicationList.iterator();
            ArrayList<MedicamentoDTO> lista = new ArrayList<MedicamentoDTO>();
            while (it.hasNext()) {
                StructuredProductType medication = (StructuredProductType)it.next();
                MedicamentoDTO medicamento = this.getMedicamento(medication);
                medicamento.setName(medicamento.getListaProductos().get(0).getProductName());
                medicamento.setIdInterno(medication.getCCRDataObjectID().split("-")[0]);
                lista.add(medicamento);
            }
            return lista;
        }
        return null;
    }

    public String translateDTOtoCCR(MedicamentoDTO medicamento) {
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord CCR = ContinuityOfCareRecordDocument.ContinuityOfCareRecord.Factory.newInstance();
        CCR.addNewBody();
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord.Body.Medications medications = CCR.getBody().addNewMedications();
        StructuredProductType newMedication = medications.addNewMedication();
        this.translateMedicationToCCR(newMedication, medicamento);
        return CCR.xmlText();
    }

    private void translateMedicationToCCR(StructuredProductType newMedication, MedicamentoDTO medicamento) {
        this.newMedication_Product(medicamento.getListaProductos(), newMedication);
        this.newMedication_DateTime(medicamento.getFechaInicio(), newMedication);
        this.newMedication_DateTime(medicamento.getFechaFin(), newMedication);
        this.newMedication_Status(medicamento.getEstado(), newMedication);
        this.newMedication_Direction(medicamento.getPosologias(), newMedication);
        this.newMedication_Fulfillment(medicamento.getHistoriales(), newMedication);
        this.newMedication_Source(medicamento.getMedico(), newMedication);
    }

    private DateTimeType newMedication_DateTime(DateTime fecha, StructuredProductType medicamento) {
        if (fecha != null) {
            DateTimeType NewDateTime = medicamento.addNewDateTime();
            CodedDescriptionType NewType = NewDateTime.addNewType();
            NewDateTime.setExactDateTime(fecha.getExactDateTime());
            NewType.setText(fecha.getType());
            return NewDateTime;
        }
        return null;
    }

    private StructuredProductType.Product newMedication_Product(ArrayList<Product> listaProductos, StructuredProductType medicamento) {
        if (listaProductos.size() > 0) {
            StructuredProductType.Product NewProduct = medicamento.addNewProduct();
            StructuredProductType.Product.Form addNewForm = NewProduct.addNewForm();
            CodedDescriptionType addNewProductName = NewProduct.addNewProductName();
            StructuredProductType.Product.Strength addNewStrength = NewProduct.addNewStrength();
            addNewProductName.setText(listaProductos.get(0).getProductName());
            if (listaProductos.get(0).getForm().size() > 0) {
                addNewForm.setText(listaProductos.get(0).getForm().get(0));
            }
            if (listaProductos.get(0).getStrentgh().size() > 0) {
                addNewStrength.setValue(listaProductos.get(0).getStrentgh().get(0));
            }
            return NewProduct;
        }
        return null;
    }

    private void newMedication_Status(Status estado, StructuredProductType NewMedication) {
        if (estado != null) {
            CodedDescriptionType addNewStatus = NewMedication.addNewStatus();
            addNewStatus.setText(estado.getEstado());
        }
    }

    private void newMedication_Direction(ArrayList<Direction> posologias, StructuredProductType NewMedication) {
        if (posologias != null && posologias.size() > 0) {
            DirectionsDocument.Directions NewDirections = NewMedication.addNewDirections();
            DirectionDocument.Direction NewDirection = NewDirections.addNewDirection();
            DirectionDocument.Direction.Dose NewDose = NewDirection.addNewDose();
            if (posologias.get(0).getListaDosis().get(0).getValor() != null) {
                NewDose.setValue(posologias.get(0).getListaDosis().get(0).getValor());
                if (posologias.get(0).getListaDosis().get(0).getUnidades() != null) {
                    MeasureType.Units addNewUnits = NewDose.addNewUnits();
                    addNewUnits.setUnit(posologias.get(0).getListaDosis().get(0).getUnidades());
                }
            }
            DirectionDocument.Direction.Route addNewRoute = NewDirection.addNewRoute();
            addNewRoute.setText(posologias.get(0).getListaVias().get(0));
            FrequencyType addNewFrequency = NewDirection.addNewFrequency();
            addNewFrequency.setValue(posologias.get(0).getListaFrecuencias().get(0));
        }
    }

    private void newMedication_Fulfillment(ArrayList<FulfillmentHistory> historiales, StructuredProductType NewMedication) {
        if (historiales != null && historiales.size() > 0) {
            StructuredProductType.FulfillmentHistory NewFulfillmentHistory = NewMedication.addNewFulfillmentHistory();
            OrderRxHistoryType NewFulfillment = NewFulfillmentHistory.addNewFulfillment();
            DateTimeType addNewDateTime = NewFulfillment.addNewDateTime();
            CodedDescriptionType addNewType = addNewDateTime.addNewType();
            if (historiales.get(0).getFechaRellenado() != null) {
                addNewType.setText(historiales.get(0).getFechaRellenado().getType());
                addNewDateTime.setExactDateTime(historiales.get(0).getFechaRellenado().getExactDateTime());
            }
            if (historiales.get(0).getCantidad().size() > 0) {
                MeasureType addNewQuantity = NewFulfillment.addNewQuantity();
                addNewQuantity.setValue(historiales.get(0).getCantidad().get(0).getValor());
                if (historiales.get(0).getCantidad().get(0).getUnidades() != null) {
                    addNewQuantity.addNewUnits().setUnit(historiales.get(0).getCantidad().get(0).getUnidades());
                }
            }
        }
    }

    public void newMedication_Source(Actor medico, StructuredProductType NewMedication) {
        if (medico != null && !medico.getId().equals("")) {
            SourceType addNewSource = NewMedication.addNewSource();
            ActorReferenceType addNewActor = addNewSource.addNewActor();
            addNewActor.setActorID(medico.getId());
            if (medico.getRole().get(0) != null) {
                addNewActor.addNewActorRole().setText(medico.getRole().get(0));
            }
        }
    }

    private MedicamentoDTO getMedicamento(StructuredProductType medication) {
        StructuredProductType.FulfillmentHistory fulfillmentH;
        List directionsList;
        CodedDescriptionType status;
        List dateTimeList;
        MedicamentoDTO m = new MedicamentoDTO();
        List productos = medication.getProductList();
        if (productos != null) {
            for (StructuredProductType.Product product : productos) {
                Product producto = Product.getProduct(product);
                m.getListaProductos().add(producto);
            }
        }
        if ((dateTimeList = medication.getDateTimeList()) != null) {
            for (DateTimeType fecha : dateTimeList) {
                DateTime fecha1 = DateTime.getDate(fecha);
                m.insertaFecha(fecha1);
            }
        }
        if ((status = medication.getStatus()) != null) {
            Status estado = Status.getStatus(status);
            m.setEstado(estado);
            List sourceList = medication.getSourceList();
            for (SourceType fuente : sourceList) {
                Source fuente1 = Source.getSource(fuente);
                boolean ok = m.insertaFuente(fuente1);
            }
        }
        if ((directionsList = medication.getDirectionsList()) != null) {
            ArrayList<Direction> posologias = new ArrayList<Direction>();
            Iterator it3 = directionsList.iterator();
            while (it3.hasNext()) {
                Direction d = Direction.getDirection((DirectionsDocument.Directions)it3.next());
                posologias.add(d);
            }
            m.setPosologias(posologias);
        }
        if ((fulfillmentH = medication.getFulfillmentHistory()) != null) {
            List fulfillmentList = fulfillmentH.getFulfillmentList();
            ArrayList<FulfillmentHistory> historiales = new ArrayList<FulfillmentHistory>();
            Iterator it4 = fulfillmentList.iterator();
            while (it4.hasNext()) {
                FulfillmentHistory fllh = FulfillmentHistory.getFulfillmentHistory((OrderRxHistoryType)it4.next());
                historiales.add(fllh);
            }
            m.setHistoriales(historiales);
        }
        return m;
    }

    public String formatearCodigoXML(String content) {
        return "<ContinuityOfCareRecord xmlns=\"urn:astm-org:CCR\">\n" + content + "\n" + "</ContinuityOfCareRecord>";
    }
}

