/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.Interpreters;

import DataManager.GoogleHealthManager.ClasesAuxiliares.DateTime;
import DataManager.GoogleHealthManager.DTOs.PersonaDTO;
import com.google.code.ccr4j.ActorType;
import com.google.code.ccr4j.CodedDescriptionType;
import com.google.code.ccr4j.ContinuityOfCareRecordDocument;
import com.google.code.ccr4j.DateTimeType;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonaInterpreter {
    public ArrayList<PersonaDTO> translateCCRtoDTO(String XMLData) throws XmlException {
        List usuarios;
        XMLData = this.formatearCodigoXML(XMLData);
        ContinuityOfCareRecordDocument xmlParseado = ContinuityOfCareRecordDocument.Factory.parse((String)XMLData);
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord CCR = xmlParseado.getContinuityOfCareRecord();
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord.Actors actores = CCR.getActors();
        ArrayList<PersonaDTO> resultado = new ArrayList<PersonaDTO>();
        if (actores != null && (usuarios = actores.getActorList()) != null) {
            for (ActorType v : usuarios) {
                if (v.getPerson() == null) continue;
                String sex = v.getPerson().getGender().getText();
                DateTimeType d = v.getPerson().getDateOfBirth();
                DateTime d1 = new DateTime(d.getExactDateTime(), "Fecha Nacimiento");
                String id = v.getActorObjectID();
                resultado.add(new PersonaDTO(sex, d1, id));
            }
        }
        return resultado;
    }

    public String translateDTOtoCCR(PersonaDTO persona) {
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord CCR = ContinuityOfCareRecordDocument.ContinuityOfCareRecord.Factory.newInstance();
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord.Actors a = CCR.addNewActors();
        ActorType actor = a.addNewActor();
        ActorType.Person p = actor.addNewPerson();
        p.addNewGender().setText(persona.getSexo());
        DateTimeType NewDateTime = p.addNewDateOfBirth();
        CodedDescriptionType NewType = NewDateTime.addNewType();
        NewDateTime.setExactDateTime(persona.getFechaNacmiento().getExactDateTime());
        return CCR.xmlText();
    }

    public String formatearCodigoXML(String content) {
        return "<ContinuityOfCareRecord xmlns=\"urn:astm-org:CCR\">\n" + content + "\n" + "</ContinuityOfCareRecord>";
    }
}

