/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.Interpreters;

import DataManager.GoogleHealthManager.ClasesAuxiliares.Actor;
import DataManager.GoogleHealthManager.ClasesAuxiliares.DateTime;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Description;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Source;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Status;
import DataManager.GoogleHealthManager.DTOs.ProblemsDTO;
import com.google.code.ccr4j.ActorReferenceType;
import com.google.code.ccr4j.CodeType;
import com.google.code.ccr4j.CodedDescriptionType;
import com.google.code.ccr4j.ContinuityOfCareRecordDocument;
import com.google.code.ccr4j.DateTimeType;
import com.google.code.ccr4j.ProblemType;
import com.google.code.ccr4j.SourceType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemsInterpreter {
    public ArrayList<ProblemsDTO> translateCCRtoDTO(String XMLData) throws XmlException {
        ContinuityOfCareRecordDocument xmlParseado = ContinuityOfCareRecordDocument.Factory.parse((String)(XMLData = this.formatearCodigoXML(XMLData)));
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord CCR = xmlParseado.getContinuityOfCareRecord();
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord.Body.Problems enfermedadesDelPaciente = CCR.getBody().getProblems();
        if (enfermedadesDelPaciente != null) {
            List listaAnalisis = enfermedadesDelPaciente.getProblemList();
            Iterator it = listaAnalisis.iterator();
            ArrayList<ProblemsDTO> lista = new ArrayList<ProblemsDTO>();
            while (it.hasNext()) {
                ProblemType problem = (ProblemType)it.next();
                ProblemsDTO problemas = this.getProblem(problem);
                problemas.setIdInterno(problem.getCCRDataObjectID().split("-")[0]);
                lista.add(problemas);
            }
            return lista;
        }
        return null;
    }

    private ProblemsDTO getProblem(ProblemType problem) {
        CodedDescriptionType descriptionP;
        List sourceList;
        CodedDescriptionType status;
        ProblemsDTO p = new ProblemsDTO();
        List dateTimeList = problem.getDateTimeList();
        if (dateTimeList != null) {
            for (DateTimeType fecha : dateTimeList) {
                DateTime fecha1 = DateTime.getDate(fecha);
                p.insertaFecha(fecha1);
            }
        }
        if ((status = problem.getStatus()) != null) {
            Status estado = Status.getStatus(status);
            p.setEstado(estado);
        }
        if ((sourceList = problem.getSourceList()) != null) {
            for (SourceType fuente : sourceList) {
                Source fuente1 = Source.getSource(fuente);
                p.insertaFuente(fuente1);
            }
        }
        if ((descriptionP = problem.getDescription()) != null) {
            Description description = Description.getDescription(descriptionP);
            p.insertaDescription(description);
        }
        return p;
    }

    public String translateDTOtoCCR(ProblemsDTO problem) {
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord CCR = ContinuityOfCareRecordDocument.ContinuityOfCareRecord.Factory.newInstance();
        CCR.addNewBody();
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord.Body.Problems addNewProblems = CCR.getBody().addNewProblems();
        ProblemType NewProblem = addNewProblems.addNewProblem();
        this.translateProblemsToCCR(NewProblem, problem);
        return CCR.xmlText();
    }

    private void translateProblemsToCCR(ProblemType NewProblem, ProblemsDTO problema) {
        this.newProblem_DateTime(problema.getFechaInicio(), problema.getFechaFin(), NewProblem);
        this.newProblem_Status(problema.getEstado(), NewProblem);
        this.newProblem_Description(problema.getDescription(), NewProblem);
        this.newProblem_Source(problema.getSource(), NewProblem);
    }

    public void newProblem_DateTime(DateTime fechaInicio, DateTime fechaFin, ProblemType problem) {
        if (fechaInicio != null) {
            DateTimeType NewDateTime = problem.addNewDateTime();
            CodedDescriptionType NewType = NewDateTime.addNewType();
            NewDateTime.setExactDateTime(fechaInicio.getExactDateTime());
            NewType.setText(fechaInicio.getType());
        }
        if (fechaFin != null) {
            DateTimeType NewDateTime1 = problem.addNewDateTime();
            CodedDescriptionType NewType1 = NewDateTime1.addNewType();
            NewDateTime1.setExactDateTime(fechaFin.getExactDateTime());
            NewType1.setText(fechaFin.getType());
        }
    }

    public CodedDescriptionType newProblem_Status(Status _status, ProblemType problem) {
        if (_status != null && _status.getEstado() != null) {
            CodedDescriptionType status = problem.addNewStatus();
            status.setText(_status.getEstado());
            return status;
        }
        return null;
    }

    public CodedDescriptionType newProblem_Description(Description _description, ProblemType problem) {
        if (_description != null) {
            CodedDescriptionType description = problem.addNewDescription();
            description.setText(_description.getText());
            if (_description.getCodes() != null) {
                Iterator<DataManager.GoogleHealthManager.ClasesAuxiliares.CodeType> it = _description.getCodes().iterator();
                boolean i = false;
                while (it.hasNext()) {
                    DataManager.GoogleHealthManager.ClasesAuxiliares.CodeType e = it.next();
                    CodeType c = description.addNewCode();
                    c.setValue(e.getValue());
                    c.setCodingSystem(e.getCodingSystem());
                }
            }
            return description;
        }
        return null;
    }

    public SourceType newProblem_Source(Source _source, ProblemType problem) {
        if (_source != null) {
            SourceType source = problem.addNewSource();
            for (Actor actor : _source.getActors()) {
                ActorReferenceType _actor = source.addNewActor();
                _actor.setActorID(actor.getId());
                _actor.setActorRoleArray((CodedDescriptionType[])actor.getRole().toArray());
            }
            return source;
        }
        return null;
    }

    public String formatearCodigoXML(String content) {
        return "<ContinuityOfCareRecord xmlns=\"urn:astm-org:CCR\">\n" + content + "\n" + "</ContinuityOfCareRecord>";
    }
}

