/*
 * Decompiled with CFR 0.152.
 */
package Application.Controladores;

import Application.Modelos.Problemas;
import Application.Vistas.Interfaces.ProblemView;
import DataManager.GoogleHealthManager.ClasesAuxiliares.DateTime;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Description;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Status;
import DataManager.GoogleHealthManager.DAOs.ProblemsDAOGH;
import DataManager.GoogleHealthManager.DTOs.ProblemsDTO;

public class ControladorProblemView {
    Problemas modelo;
    boolean modeloHasChange = false;
    String idPacienteOwner = "";

    public ControladorProblemView(String idPaciente, Problemas modelo) {
        this.modelo = modelo;
        this.idPacienteOwner = idPaciente;
    }

    public ControladorProblemView(String idPaciente) {
        this.modelo = new Problemas();
        this.idPacienteOwner = idPaciente;
    }

    public void addViewToModel(ProblemView view) {
        this.modelo.addView(view);
    }

    public Problemas getModelo() {
        return this.modelo;
    }

    public void insertNewEnfermedad(String nombreEnfermedad, boolean estado, String fechaInicio, String fechaFin) {
        if (estado) {
            this.modelo.setStatus(new Status("Active"));
        } else {
            this.modelo.setStatus(new Status("Inactive"));
        }
        if (fechaInicio != null) {
            this.modelo.setFechaInicio(new DateTime(fechaInicio, "Start date"));
        }
        if (fechaFin != null) {
            this.modelo.setFechaFin(new DateTime(fechaFin, "Stop date"));
        }
        this.modelo.setDescripcionProblema(new Description(nombreEnfermedad));
        String nuevoId = new ProblemsDAOGH().insertProblem(new ProblemsDTO(this.modelo), this.idPacienteOwner);
        if (nuevoId != null) {
            this.modelo.setIdInterno(nuevoId);
            this.modeloHasChange = false;
        }
    }
}

