/*
 * Decompiled with CFR 0.152.
 */
package Application.Herramientas;

import Application.Herramientas.Grafica;
import Application.Modelos.Analisis;
import Application.Modelos.ResultadoTest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraficaGlucemias
extends Grafica {
    public static ChartPanel mostrarGrafica(ArrayList<Analisis> datosGlucemia, ArrayList<Analisis> datosInsulina, int tipo) {
        DefaultCategoryDataset dt = GraficaGlucemias.introducirDatos(datosGlucemia, datosInsulina);
        JFreeChart chart = null;
        String titulo = null;
        String fila = "Fecha";
        String columna = null;
        if (datosGlucemia != null && datosInsulina == null) {
            titulo = "Gr\u00e1fica de Glucemias";
            columna = "Valor Glucemia mg/dl";
        }
        if (datosGlucemia == null && datosInsulina != null) {
            titulo = "Gr\u00e1fica de Insulina";
            columna = "Valor Insulina u/ml";
        }
        if (datosGlucemia != null && datosInsulina != null) {
            titulo = "Gr\u00e1fica Comparativa";
            columna = "Glucemia vs Insulina";
        }
        Grafica.TiposDeGrafico tipoElegido = Grafica.TiposDeGrafico.LineChart;
        if (tipo == 1) {
            tipoElegido = Grafica.TiposDeGrafico.LineChart;
        }
        if (tipo == 2) {
            tipoElegido = Grafica.TiposDeGrafico.BarChart;
        }
        if (tipo == 3) {
            tipoElegido = Grafica.TiposDeGrafico.LineChart3D;
        }
        if (tipo == 4) {
            tipoElegido = Grafica.TiposDeGrafico.BarChart3D;
        }
        if (tipo == 5) {
            tipoElegido = Grafica.TiposDeGrafico.AreaChart;
        }
        for (Grafica.TiposDeGrafico j : Grafica.TiposDeGrafico.values()) {
            chart = GraficaGlucemias.createChart((CategoryDataset)dt, tipoElegido, titulo, columna, fila);
        }
        ChartPanel panel = new ChartPanel(chart);
        return panel;
    }

    private static DefaultCategoryDataset introducirDatos(ArrayList<Analisis> datosGlucemias, ArrayList<Analisis> datosInsulina) {
        Analisis a;
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        Iterator<Analisis> itG = null;
        Iterator<Analisis> itI = null;
        if (datosGlucemias != null) {
            itG = datosGlucemias.iterator();
        }
        if (datosInsulina != null) {
            itI = datosInsulina.iterator();
        }
        SimpleDateFormat formateador = new SimpleDateFormat("dd/MM/yyyy");
        if (itG != null) {
            while (itG.hasNext()) {
                a = itG.next();
                if (!a.getTipoAnalisis().equalsIgnoreCase("Glucemia")) continue;
                for (ResultadoTest t : a.getResultadosTest()) {
                    dataset.addValue(Double.parseDouble(t.getValorObtenido()), (Comparable)((Object)"Glucemia"), (Comparable)((Object)formateador.format(t.getFecha())));
                }
            }
        }
        if (itI != null) {
            while (itI.hasNext()) {
                a = itI.next();
                if (!a.getTipoAnalisis().equalsIgnoreCase("Insulina")) continue;
                for (ResultadoTest t : a.getResultadosTest()) {
                    dataset.addValue(Double.parseDouble(t.getValorObtenido()), (Comparable)((Object)"Insulina"), (Comparable)((Object)formateador.format(t.getFecha())));
                }
            }
        }
        return dataset;
    }
}

