/*
 * Decompiled with CFR 0.152.
 */
package Application.Herramientas;

import Application.Herramientas.Grafica;
import Application.Modelos.Analisis;
import Application.Modelos.ResultadoTest;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraficaPesoAlturaImc
extends Grafica {
    public static ChartPanel mostrarGrafica(ArrayList<Analisis> datosPeso, ArrayList<Analisis> datosAltura, ArrayList<Analisis> datosIMC, int tipo) {
        DefaultCategoryDataset dt = GraficaPesoAlturaImc.introducirDatos(datosPeso, datosAltura, datosIMC);
        JFreeChart chart = null;
        String titulo = null;
        String fila = "Fecha";
        String columna = null;
        if (datosPeso != null && datosAltura == null && datosIMC == null) {
            titulo = "Gr\u00e1fica de Peso";
            columna = "Peso";
        }
        if (datosPeso == null && datosAltura != null && datosIMC == null) {
            titulo = "Gr\u00e1fica de Altura";
            columna = "Altura";
        }
        if (datosPeso == null && datosAltura == null && datosIMC != null) {
            titulo = "Gr\u00e1fica de IMC";
            columna = "IMC";
        }
        Grafica.TiposDeGrafico tipoElegido = Grafica.TiposDeGrafico.LineChart;
        if (tipo == 1) {
            tipoElegido = Grafica.TiposDeGrafico.LineChart;
        }
        if (tipo == 2) {
            tipoElegido = Grafica.TiposDeGrafico.BarChart;
        }
        if (tipo == 3) {
            tipoElegido = Grafica.TiposDeGrafico.LineChart3D;
        }
        if (tipo == 4) {
            tipoElegido = Grafica.TiposDeGrafico.BarChart3D;
        }
        if (tipo == 5) {
            tipoElegido = Grafica.TiposDeGrafico.AreaChart;
        }
        for (Grafica.TiposDeGrafico j : Grafica.TiposDeGrafico.values()) {
            chart = GraficaPesoAlturaImc.createChart((CategoryDataset)dt, tipoElegido, titulo, columna, fila);
        }
        ChartPanel panel = new ChartPanel(chart);
        return panel;
    }

    private static DefaultCategoryDataset introducirDatos(ArrayList<Analisis> datosPeso, ArrayList<Analisis> datosAltura, ArrayList<Analisis> datosIMC) {
        Analisis a;
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        Iterator<Analisis> itPeso = null;
        Iterator<Analisis> itAltura = null;
        Iterator<Analisis> itIMC = null;
        if (datosPeso != null) {
            itPeso = datosPeso.iterator();
        }
        if (datosAltura != null) {
            itAltura = datosAltura.iterator();
        }
        if (datosIMC != null) {
            itIMC = datosIMC.iterator();
        }
        if (itPeso != null) {
            while (itPeso.hasNext()) {
                a = itPeso.next();
                if (!a.getTipoAnalisis().equalsIgnoreCase("Peso")) continue;
                for (ResultadoTest t : a.getResultadosTest()) {
                    dataset.addValue(Double.parseDouble(t.getValorObtenido()), (Comparable)((Object)"Peso"), (Comparable)t.getFecha());
                }
            }
        }
        if (itAltura != null) {
            while (itAltura.hasNext()) {
                a = itAltura.next();
                if (!a.getTipoAnalisis().equalsIgnoreCase("Altura")) continue;
                for (ResultadoTest t : a.getResultadosTest()) {
                    dataset.addValue(Double.parseDouble(t.getValorObtenido()), (Comparable)((Object)"Altura"), (Comparable)t.getFecha());
                }
            }
        }
        if (itIMC != null) {
            while (itIMC.hasNext()) {
                a = itIMC.next();
                if (!a.getTipoAnalisis().equalsIgnoreCase("IMC")) continue;
                for (ResultadoTest t : a.getResultadosTest()) {
                    dataset.addValue(Double.parseDouble(t.getValorObtenido().replace(',', '.')), (Comparable)((Object)"Imc"), (Comparable)t.getFecha());
                }
            }
        }
        return dataset;
    }

    public static void guardarFichero(JFreeChart chart, int tipo1) {
        try {
            Grafica.TiposDeGrafico tipo = Grafica.TiposDeGrafico.LineChart;
            if (tipo1 == 1) {
                tipo = Grafica.TiposDeGrafico.LineChart;
            }
            if (tipo1 == 2) {
                tipo = Grafica.TiposDeGrafico.BarChart;
            }
            if (tipo1 == 3) {
                tipo = Grafica.TiposDeGrafico.LineChart3D;
            }
            if (tipo1 == 4) {
                tipo = Grafica.TiposDeGrafico.BarChart3D;
            }
            if (tipo1 == 5) {
                tipo = Grafica.TiposDeGrafico.AreaChart;
            }
            String tmpDir = System.getProperty("java.io.tmpdir");
            ChartUtilities.saveChartAsJPEG((File)new File(tmpDir + tipo.toString() + "BARCHAR.JPG"), (JFreeChart)chart, (int)500, (int)300);
            System.out.println("Salvada imagen en " + tmpDir + tipo.toString() + "BARCHAR.JPG");
        }
        catch (IOException e) {
            System.err.println("Error creando grafico.");
        }
    }
}

