/*
 * Decompiled with CFR 0.152.
 */
package Application.Modelos;

import Application.Vistas.Interfaces.MedicamentoView;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Actor;
import DataManager.GoogleHealthManager.ClasesAuxiliares.DateTime;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Direction;
import DataManager.GoogleHealthManager.ClasesAuxiliares.FulfillmentHistory;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Product;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Status;
import DataManager.GoogleHealthManager.DTOs.MedicamentoDTO;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Medicamento {
    private DateTime fechaInicio;
    private DateTime fechaFin;
    private DateTime fechaReceta;
    private Status estado;
    private String pacienteId;
    private Actor medico;
    private String idInterno;
    private ArrayList<Product> listaProductos;
    private ArrayList<Direction> posologias;
    private ArrayList<FulfillmentHistory> historiales;
    ArrayList<MedicamentoView> views = new ArrayList();

    public Medicamento() {
    }

    public Medicamento(String productName, boolean estado, String fechaInicio, String fechaFin, String fechaReceta, String cantidadDosis, String unidadesDosis, String forma, String valorPosolologia, String unidadesPosolologia, String via, String frecuencia, String fechaRellenado, String valorF, String unidadesF) {
        this.estado = estado ? new Status("activo") : new Status("inactivo");
        if (fechaInicio != null) {
            this.fechaInicio = new DateTime(fechaInicio, "Start date");
        }
        if (fechaFin != null) {
            this.fechaFin = new DateTime(fechaFin, "Stop date");
        }
        if (fechaReceta != null) {
            this.fechaReceta = new DateTime(fechaReceta, "Prescription date");
        }
        this.listaProductos = new ArrayList();
        Product p = new Product(productName, cantidadDosis + " " + unidadesDosis, forma);
        this.listaProductos.add(p);
        this.posologias = new ArrayList();
        Direction d = new Direction(valorPosolologia, unidadesPosolologia, via, frecuencia);
        this.posologias.add(d);
        this.historiales = new ArrayList();
        FulfillmentHistory f = new FulfillmentHistory(fechaRellenado, valorF, unidadesF);
        this.historiales.add(f);
    }

    public Medicamento(String productName, String fechaInicio, String fechaFin, String estado) {
        this.estado = new Status(estado);
        if (fechaInicio != null) {
            this.fechaInicio = new DateTime(fechaInicio, "Start date");
        }
        if (fechaFin != null) {
            this.fechaFin = new DateTime(fechaFin, "Stop date");
        }
        this.listaProductos = new ArrayList();
        Product p = new Product(productName);
        this.listaProductos.add(p);
    }

    public Medicamento(MedicamentoDTO medicamentoDTO) {
        if (medicamentoDTO.getFechaInicio() != null) {
            this.fechaInicio = medicamentoDTO.getFechaInicio().clone();
        }
        if (medicamentoDTO.getFechaFin() != null) {
            this.fechaFin = medicamentoDTO.getFechaFin().clone();
        }
        this.estado = medicamentoDTO.getEstado().clone();
        this.pacienteId = medicamentoDTO.getPacienteId().toString();
        this.idInterno = medicamentoDTO.getIdInterno().toString();
        this.listaProductos = new ArrayList();
        this.posologias = new ArrayList();
        for (Product p : medicamentoDTO.getListaProductos()) {
            this.getListaProductos().add(p.clone());
        }
        this.posologias = new ArrayList();
        for (Direction d : medicamentoDTO.getPosologias()) {
            this.getPosologias().add(d.clone());
        }
    }

    public DateTime getFechaInicio() {
        return this.fechaInicio;
    }

    public void setFechaInicio(DateTime fechaInicio) {
        this.fechaInicio = fechaInicio;
    }

    public void setFechaInicio(String fechaInicio) {
        if (fechaInicio != null) {
            this.fechaInicio = new DateTime(fechaInicio, "Start date");
        }
    }

    public DateTime getFechaFin() {
        return this.fechaFin;
    }

    public void setFechaFin(DateTime fechaFin) {
        this.fechaFin = fechaFin;
    }

    public void setFechaFin(String fechaFin) {
        if (fechaFin != null) {
            this.fechaFin = new DateTime(fechaFin, "Stop date");
        }
    }

    public DateTime getFechaReceta() {
        return this.fechaReceta;
    }

    public void setFechaReceta(DateTime fechaReceta) {
        this.fechaReceta = fechaReceta;
    }

    public void setFechaReceta(String fechaReceta) {
        if (fechaReceta != null) {
            this.fechaReceta = new DateTime(fechaReceta, "Prescription date");
        }
    }

    public Status getEstado() {
        return this.estado;
    }

    public void setEstado(Status estado) {
        this.estado = estado;
    }

    public String getPacienteId() {
        return this.pacienteId;
    }

    public void setPacienteId(String pacienteId) {
        this.pacienteId = pacienteId;
    }

    public Actor getMedico() {
        return this.medico;
    }

    public void setMedico(Actor medico) {
        this.medico = medico;
    }

    public ArrayList<Product> getListaProductos() {
        return this.listaProductos;
    }

    public void setListaProductos(ArrayList<Product> listaProductos) {
        this.listaProductos = listaProductos;
    }

    public ArrayList<Direction> getPosologias() {
        return this.posologias;
    }

    public void setPosologias(ArrayList<Direction> posologias) {
        this.posologias = posologias;
    }

    public void addPosologia(String valor, String unidades, String via, String frecuencia) {
        Direction d = new Direction(valor, unidades, via, frecuencia);
        if (this.posologias == null) {
            this.posologias = new ArrayList();
        }
        this.posologias.add(d);
    }

    public ArrayList<FulfillmentHistory> getHistoriales() {
        return this.historiales;
    }

    public void setHistoriales(ArrayList<FulfillmentHistory> historiales) {
        this.historiales = historiales;
    }

    public String getNombre() {
        Iterator<Product> it = this.listaProductos.iterator();
        String nombre = "";
        while (it.hasNext()) {
            Product p = it.next();
            nombre = p.getProductName();
        }
        return nombre;
    }

    public String getIdInterno() {
        return this.idInterno;
    }

    public void setIdInterno(String idInterno) {
        this.idInterno = idInterno;
    }

    public String toString() {
        String data = "";
        for (Product p : this.listaProductos) {
            data = data + p.toString();
        }
        return data;
    }

    public void addView(MedicamentoView view) {
        this.views.add(view);
    }

    public void updateAllViews() {
        Iterator<MedicamentoView> it = this.views.iterator();
        while (it.hasNext()) {
            it.next().updateView();
        }
    }
}

