/*
 * Decompiled with CFR 0.152.
 */
package Application.Modelos;

import Application.Vistas.Interfaces.ProblemView;
import DataManager.GoogleHealthManager.ClasesAuxiliares.DateTime;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Description;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Status;
import DataManager.GoogleHealthManager.DTOs.ProblemsDTO;
import java.util.ArrayList;
import java.util.Iterator;

public class Problemas {
    private DateTime fechaInicio = null;
    private DateTime fechaFin = null;
    private Description descripcionProblema;
    private String idInterno;
    private Status status;
    ArrayList<ProblemView> views = new ArrayList();

    public Problemas(String descripcion, String estado) {
        this.descripcionProblema = new Description();
        this.descripcionProblema.setText(descripcion);
        this.status = new Status();
        this.status.setEstado(estado);
    }

    public Problemas(String descripcion, String fechaInicio, String fechaFin, String estado) {
        this.descripcionProblema = new Description();
        this.descripcionProblema.setText(descripcion);
        this.status = new Status();
        this.status.setEstado(estado);
        if (fechaInicio != null) {
            this.fechaInicio = new DateTime(fechaInicio, "Start date");
        }
        if (fechaFin != null) {
            this.fechaFin = new DateTime(fechaFin, "Stop date");
        }
    }

    public Problemas(ProblemsDTO problemsDTO) {
        this.fechaInicio = problemsDTO.getFechaInicio();
        this.fechaFin = problemsDTO.getFechaFin();
        this.descripcionProblema = problemsDTO.getDescription();
        this.status = problemsDTO.getEstado();
        this.idInterno = problemsDTO.getIdInterno();
    }

    public Problemas(String fechaInicio, String fechaFin, String descripcion) {
        if (!fechaInicio.isEmpty()) {
            this.fechaInicio = new DateTime(fechaInicio, "Start Date");
        }
        if (!fechaFin.isEmpty()) {
            this.fechaFin = new DateTime(fechaFin, "End Date");
        }
        this.descripcionProblema = new Description();
        this.descripcionProblema.setText(descripcion);
    }

    public Problemas() {
    }

    public DateTime getFechaInicio() {
        return this.fechaInicio;
    }

    public void setFechaInicio(DateTime fechaInicio) {
        this.fechaInicio = fechaInicio;
    }

    public DateTime getFechaFin() {
        return this.fechaFin;
    }

    public void setFechaFin(DateTime fechaFin) {
        this.fechaFin = fechaFin;
    }

    public Description getDescripcionProblema() {
        return this.descripcionProblema;
    }

    public void setDescripcionProblema(Description descripcionProblema) {
        this.descripcionProblema = descripcionProblema;
    }

    public String getIdInterno() {
        return this.idInterno;
    }

    public void setIdInterno(String idInterno) {
        this.idInterno = idInterno;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void invertirEstado(boolean estado, String status) {
        if (!estado && status.equalsIgnoreCase("activo")) {
            this.status = new Status("inactivo");
        } else if (estado && status.equalsIgnoreCase("inactivo")) {
            this.status = new Status("activo");
        }
    }

    public boolean equals(Problemas problema) {
        if (!this.getDescripcionProblema().equals(problema.getDescripcionProblema())) {
            return false;
        }
        if (!this.getFechaInicio().equals(problema.getFechaInicio())) {
            return false;
        }
        if (!this.getFechaFin().equals(problema.getFechaFin())) {
            return false;
        }
        return this.getStatus().equals(problema.getStatus());
    }

    public void addView(ProblemView view) {
        this.views.add(view);
    }

    public void updateAllViews() {
        Iterator<ProblemView> it = this.views.iterator();
        while (it.hasNext()) {
            it.next().updateView();
        }
    }
}

