/*
 * Decompiled with CFR 0.152.
 */
package Application.Vistas;

import Application.Controladores.ControladorPacienteView;
import Application.Herramientas.CommonTools;
import Application.Vistas.Interfaces.PacienteView;
import Application.Vistas.Paneles.PanelCuerposCetonicos;
import Application.Vistas.Paneles.PanelDietas;
import Application.Vistas.Paneles.PanelInsulinaGlucemias;
import Application.Vistas.Paneles.PanelLoginPaciente;
import Application.Vistas.Paneles.PanelOpcionesPrincipalesMedico;
import Application.Vistas.Paneles.PanelOpcionesPrincipalesPaciente;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public class AplicacionPaciente
extends JFrame
implements PacienteView {
    JPanel panelPrincipal;
    JButton opcionPrincipal;
    JButton opcionSecundaria;
    ControladorPacienteView controlador;
    boolean conectado;
    private JButton buttonCuerposCetonicos;
    private JButton buttonDieta;
    private JButton buttonGlucemias;
    private JButton buttonMenuPrincipal;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JLabel labelEstadoConectado;
    private JLabel labelTitulo;
    private JPanel panelCabecera;
    private JPanel panelHerramientas;
    private JPanel panelLateralDrcho;
    private JPanel panelLateralIzq;
    private JPanel panelOpcionesSecundarias;

    public AplicacionPaciente() {
        this.initComponents();
        this.controlador = null;
        this.conectado = false;
        this.panelOpcionesSecundarias.setVisible(false);
        this.buttonMenuPrincipal.setVisible(false);
        this.getContentPane().setBackground(Color.white);
        this.setExtendedState(6);
        this.panelPrincipal = new PanelLoginPaciente(this);
        this.insertarPanelPrincipal();
    }

    private void insertarPanelPrincipal() {
        this.panelPrincipal.setVisible(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.panelPrincipal, gridBagConstraints);
        this.panelPrincipal.setVisible(true);
        if (this.getExtendedState() != 6) {
            CommonTools.centrarVentana(this);
        }
        this.repaint();
    }

    public void setConectado(boolean _conectado, ControladorPacienteView controlador, String user) {
        if (_conectado) {
            this.controlador = controlador;
            this.conectado = _conectado;
            this.getContentPane().remove(this.panelPrincipal);
            this.panelPrincipal = new PanelOpcionesPrincipalesPaciente(this, controlador.getModelo().getId());
            this.labelEstadoConectado.setForeground(new Color(0, 204, 0));
            this.labelEstadoConectado.setText("Conectado como " + user);
            this.buttonMenuPrincipal.setVisible(true);
            this.panelOpcionesSecundarias.setVisible(true);
            this.configurarBotonPrincipalSeleccionado(this.buttonMenuPrincipal);
            this.insertarPanelPrincipal();
        }
    }

    public void setPanelPrincipal(String tipoPanel) {
        if (tipoPanel.equalsIgnoreCase("Glucemias")) {
            this.buttonGlucemiasActionPerformed(null);
        } else if (tipoPanel.equalsIgnoreCase("Dieta")) {
            this.buttonDietaActionPerformed(null);
        } else if (tipoPanel.equalsIgnoreCase("Cuerpos Cetonicos")) {
            this.buttonCuerposCetonicosActionPerformed(null);
        } else if (tipoPanel.equalsIgnoreCase("Panel Principal")) {
            this.buttonMenuPrincipalActionPerformed(null);
        }
    }

    private void configurarBotonPrincipalSeleccionado(JButton button) {
        if (this.opcionPrincipal != null) {
            this.opcionPrincipal.setForeground(Color.white);
            this.opcionPrincipal.setOpaque(false);
        }
        this.opcionPrincipal = button;
        this.opcionPrincipal.setBackground(Color.white);
        this.opcionPrincipal.setForeground(new Color(0, 153, 255));
        this.opcionPrincipal.setOpaque(true);
    }

    private void mouseEntered(MouseEvent evt) {
        JButton boton = (JButton)evt.getComponent();
        if (!boton.equals(this.opcionPrincipal)) {
            boton.setBackground(Color.white);
            boton.setForeground(new Color(0, 153, 255));
            boton.setOpaque(true);
        }
    }

    private void mouseExited(MouseEvent evt) {
        JButton boton = (JButton)evt.getComponent();
        if (!boton.equals(this.opcionPrincipal)) {
            boton.setForeground(new Color(255, 255, 255));
            boton.setOpaque(false);
        }
    }

    private void buttonGlucemiasActionPerformed(ActionEvent evt) {
        if (!(this.panelPrincipal instanceof PanelInsulinaGlucemias)) {
            if (this.panelPrincipal instanceof PacienteView) {
                this.controlador.removeViewFromModel((PacienteView)((Object)this.panelPrincipal));
            }
            this.getContentPane().remove(this.panelPrincipal);
            this.panelPrincipal = new PanelInsulinaGlucemias(this.controlador, "Paciente");
            this.configurarBotonPrincipalSeleccionado(this.buttonGlucemias);
            this.insertarPanelPrincipal();
        }
    }

    private void buttonCuerposCetonicosActionPerformed(ActionEvent evt) {
        if (!(this.panelPrincipal instanceof PanelCuerposCetonicos)) {
            if (this.panelPrincipal instanceof PacienteView) {
                this.controlador.removeViewFromModel((PacienteView)((Object)this.panelPrincipal));
            }
            this.getContentPane().remove(this.panelPrincipal);
            this.panelPrincipal = new PanelCuerposCetonicos(this.controlador, "Paciente");
            this.configurarBotonPrincipalSeleccionado(this.buttonCuerposCetonicos);
            this.insertarPanelPrincipal();
        }
    }

    private void buttonDietaActionPerformed(ActionEvent evt) {
        if (!(this.panelPrincipal instanceof PanelDietas)) {
            if (this.panelPrincipal instanceof PacienteView) {
                this.controlador.removeViewFromModel((PacienteView)((Object)this.panelPrincipal));
            }
            this.getContentPane().remove(this.panelPrincipal);
            this.panelPrincipal = new PanelDietas(this.controlador, "Paciente");
            this.configurarBotonPrincipalSeleccionado(this.buttonDieta);
            this.insertarPanelPrincipal();
        }
    }

    private void buttonMenuPrincipalActionPerformed(ActionEvent evt) {
        if (this.conectado && !(this.panelPrincipal instanceof PanelOpcionesPrincipalesMedico)) {
            if (this.panelPrincipal instanceof PacienteView) {
                this.controlador.removeViewFromModel((PacienteView)((Object)this.panelPrincipal));
            }
            this.getContentPane().remove(this.panelPrincipal);
            this.panelPrincipal = new PanelOpcionesPrincipalesPaciente(this, this.controlador.getModelo().getId());
            this.configurarBotonPrincipalSeleccionado(this.buttonMenuPrincipal);
            this.insertarPanelPrincipal();
        }
    }

    public void updateView() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getIdVista() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new AplicacionPaciente().setVisible(true);
            }
        });
    }

    private void initComponents() {
        this.panelCabecera = new JPanel();
        this.labelTitulo = new JLabel();
        this.labelEstadoConectado = new JLabel();
        this.panelHerramientas = new JPanel();
        this.panelOpcionesSecundarias = new JPanel();
        this.buttonGlucemias = new JButton();
        this.buttonCuerposCetonicos = new JButton();
        this.buttonDieta = new JButton();
        this.buttonMenuPrincipal = new JButton();
        this.jLabel1 = new JLabel();
        this.panelLateralIzq = new JPanel();
        this.jLabel2 = new JLabel();
        this.panelLateralDrcho = new JPanel();
        this.jLabel3 = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenu2 = new JMenu();
        this.setDefaultCloseOperation(3);
        this.setTitle("GluControl Paciente");
        this.setBackground(new Color(255, 255, 255));
        this.getContentPane().setLayout(new GridBagLayout());
        this.panelCabecera.setBackground(new Color(255, 255, 255));
        this.panelCabecera.setEnabled(false);
        this.panelCabecera.setFocusable(false);
        this.panelCabecera.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        this.panelCabecera.setMinimumSize(new Dimension(1024, 50));
        this.panelCabecera.setPreferredSize(new Dimension(1024, 50));
        this.panelCabecera.setLayout(new GridBagLayout());
        this.labelTitulo.setFont(new Font("Segoe Print", 1, 14));
        this.labelTitulo.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/GluControl.png")));
        this.labelTitulo.setMaximumSize(new Dimension(250, 50));
        this.labelTitulo.setMinimumSize(new Dimension(250, 50));
        this.labelTitulo.setPreferredSize(new Dimension(250, 48));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        this.panelCabecera.add((Component)this.labelTitulo, gridBagConstraints);
        this.labelEstadoConectado.setFont(new Font("Trebuchet MS", 1, 14));
        this.labelEstadoConectado.setForeground(new Color(255, 102, 0));
        this.labelEstadoConectado.setText("No est\u00e1 conectado");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = -1.0;
        gridBagConstraints.insets = new Insets(0, 45, 4, 25);
        this.panelCabecera.add((Component)this.labelEstadoConectado, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.panelCabecera, gridBagConstraints);
        this.panelHerramientas.setBackground(new Color(255, 255, 255));
        this.panelHerramientas.setMaximumSize(new Dimension(Short.MAX_VALUE, 70));
        this.panelHerramientas.setMinimumSize(new Dimension(1024, 70));
        this.panelHerramientas.setPreferredSize(new Dimension(1024, 70));
        this.panelHerramientas.setLayout(new GridBagLayout());
        this.panelOpcionesSecundarias.setBackground(new Color(255, 255, 255));
        this.panelOpcionesSecundarias.setMaximumSize(new Dimension(1024, 23));
        this.panelOpcionesSecundarias.setMinimumSize(new Dimension(550, 30));
        this.panelOpcionesSecundarias.setOpaque(false);
        this.panelOpcionesSecundarias.setPreferredSize(new Dimension(350, 30));
        this.panelOpcionesSecundarias.setLayout(new BoxLayout(this.panelOpcionesSecundarias, 2));
        this.buttonGlucemias.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonGlucemias.setForeground(new Color(254, 254, 254));
        this.buttonGlucemias.setText("Glucemias");
        this.buttonGlucemias.setBorder(null);
        this.buttonGlucemias.setBorderPainted(false);
        this.buttonGlucemias.setContentAreaFilled(false);
        this.buttonGlucemias.setFocusPainted(false);
        this.buttonGlucemias.setMaximumSize(new Dimension(100, 40));
        this.buttonGlucemias.setMinimumSize(new Dimension(100, 40));
        this.buttonGlucemias.setPreferredSize(new Dimension(100, 40));
        this.buttonGlucemias.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent evt) {
                AplicacionPaciente.this.mouseExited(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                AplicacionPaciente.this.mouseEntered(evt);
            }
        });
        this.buttonGlucemias.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AplicacionPaciente.this.buttonGlucemiasActionPerformed(evt);
            }
        });
        this.panelOpcionesSecundarias.add(this.buttonGlucemias);
        this.buttonCuerposCetonicos.setBackground(new Color(254, 254, 254));
        this.buttonCuerposCetonicos.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonCuerposCetonicos.setForeground(new Color(254, 254, 254));
        this.buttonCuerposCetonicos.setText("Cuerpos Cet\u00f3nicos");
        this.buttonCuerposCetonicos.setBorder(null);
        this.buttonCuerposCetonicos.setBorderPainted(false);
        this.buttonCuerposCetonicos.setContentAreaFilled(false);
        this.buttonCuerposCetonicos.setFocusPainted(false);
        this.buttonCuerposCetonicos.setMaximumSize(new Dimension(150, 40));
        this.buttonCuerposCetonicos.setMinimumSize(new Dimension(150, 40));
        this.buttonCuerposCetonicos.setPreferredSize(new Dimension(150, 40));
        this.buttonCuerposCetonicos.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent evt) {
                AplicacionPaciente.this.mouseExited(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                AplicacionPaciente.this.mouseEntered(evt);
            }
        });
        this.buttonCuerposCetonicos.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AplicacionPaciente.this.buttonCuerposCetonicosActionPerformed(evt);
            }
        });
        this.panelOpcionesSecundarias.add(this.buttonCuerposCetonicos);
        this.buttonDieta.setBackground(new Color(254, 254, 254));
        this.buttonDieta.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonDieta.setForeground(new Color(254, 254, 254));
        this.buttonDieta.setText("Dieta");
        this.buttonDieta.setBorder(null);
        this.buttonDieta.setBorderPainted(false);
        this.buttonDieta.setContentAreaFilled(false);
        this.buttonDieta.setFocusPainted(false);
        this.buttonDieta.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDieta.setMaximumSize(new Dimension(80, 40));
        this.buttonDieta.setMinimumSize(new Dimension(80, 40));
        this.buttonDieta.setPreferredSize(new Dimension(100, 40));
        this.buttonDieta.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent evt) {
                AplicacionPaciente.this.mouseExited(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                AplicacionPaciente.this.mouseEntered(evt);
            }
        });
        this.buttonDieta.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AplicacionPaciente.this.buttonDietaActionPerformed(evt);
            }
        });
        this.panelOpcionesSecundarias.add(this.buttonDieta);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.panelHerramientas.add((Component)this.panelOpcionesSecundarias, gridBagConstraints);
        this.buttonMenuPrincipal.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonMenuPrincipal.setForeground(new Color(255, 255, 255));
        this.buttonMenuPrincipal.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/home 32x32.png")));
        this.buttonMenuPrincipal.setText("Men\u00fa Principal");
        this.buttonMenuPrincipal.setBorder(null);
        this.buttonMenuPrincipal.setContentAreaFilled(false);
        this.buttonMenuPrincipal.setFocusPainted(false);
        this.buttonMenuPrincipal.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                AplicacionPaciente.this.mouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                AplicacionPaciente.this.mouseExited(evt);
            }
        });
        this.buttonMenuPrincipal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AplicacionPaciente.this.buttonMenuPrincipalActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 56, 0, 0);
        this.panelHerramientas.add((Component)this.buttonMenuPrincipal, gridBagConstraints);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/borders/bordeHerramientas.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 11;
        this.panelHerramientas.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.panelHerramientas, gridBagConstraints);
        this.panelLateralIzq.setEnabled(false);
        this.panelLateralIzq.setFocusable(false);
        this.panelLateralIzq.setMaximumSize(new Dimension(100, Short.MAX_VALUE));
        this.panelLateralIzq.setMinimumSize(new Dimension(100, 800));
        this.panelLateralIzq.setPreferredSize(new Dimension(100, 800));
        this.panelLateralIzq.setLayout(new GridBagLayout());
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/borders/FondoBordeIzq.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.panelLateralIzq.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.panelLateralIzq, gridBagConstraints);
        this.panelLateralDrcho.setEnabled(false);
        this.panelLateralDrcho.setFocusable(false);
        this.panelLateralDrcho.setMaximumSize(new Dimension(100, Short.MAX_VALUE));
        this.panelLateralDrcho.setMinimumSize(new Dimension(100, 700));
        this.panelLateralDrcho.setPreferredSize(new Dimension(100, 700));
        this.panelLateralDrcho.setLayout(new GridBagLayout());
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/borders/FondoBordeDrcho.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.panelLateralDrcho.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.panelLateralDrcho, gridBagConstraints);
        this.jMenu1.setText("File");
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }
}

