/*
 * Decompiled with CFR 0.152.
 */
package Application.Vistas.Dialogos;

import Application.Controladores.ControladorProblemView;
import Application.Herramientas.CommonTools;
import Application.Modelos.Problemas;
import Application.Vistas.Dialogos.DialogoElegirNombreDeListado;
import Application.Vistas.Interfaces.ProblemView;
import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class DialogoDetallesEnfermedad
extends JDialog
implements ProblemView {
    ControladorProblemView controlador;
    boolean saved;
    private JButton buttonAceptar;
    private JCheckBox checkBoxActivo;
    private JDateChooser dateChooserFechaFin;
    private JDateChooser dateChooserFechaInicio;
    private JButton jButton1;
    private JLabel labelFechaFIn;
    private JLabel labelFechaInicio;
    private JLabel labelMedicacion;
    private JLabel labelTitulo;
    private JTextField textFieldEnfermedad;

    public DialogoDetallesEnfermedad(Frame parent, boolean modal, String nombre, String idPaciente) {
        super(parent, modal);
        this.initComponents();
        this.getContentPane().setBackground(Color.white);
        this.setTitle("Detalles de enfermedad o dolencia");
        this.controlador = new ControladorProblemView(idPaciente);
        this.controlador.addViewToModel(this);
        this.textFieldEnfermedad.setText(nombre);
        this.dateChooserFechaFin.setDate(new Date());
        this.dateChooserFechaInicio.setDate(new Date());
        this.saved = false;
        CommonTools.centrarVentana(this);
    }

    public DialogoDetallesEnfermedad(Frame parent, boolean modal, Problemas modelo, String idPaciente) {
        super(parent, modal);
        this.initComponents();
        this.getContentPane().setBackground(Color.white);
        this.setTitle("Detalles de nueva enfermedad o dolencia");
        this.controlador = new ControladorProblemView(idPaciente, modelo);
        this.controlador.addViewToModel(this);
        this.rellenarDatos();
        this.buttonAceptar.setVisible(false);
        this.saved = true;
        CommonTools.centrarVentana(this);
    }

    public static Problemas insertarNuevaEnfermedad(String idPacienteOwner) {
        String nombreNuevaEnfermedad = DialogoElegirNombreDeListado.selectNewEnfermedad();
        if (nombreNuevaEnfermedad != null) {
            DialogoDetallesEnfermedad dialog = new DialogoDetallesEnfermedad(null, true, nombreNuevaEnfermedad, idPacienteOwner);
            return dialog.getEnfermedadModelo();
        }
        return null;
    }

    private void rellenarDatos() {
        String[] fecha;
        this.textFieldEnfermedad.setText(this.controlador.getModelo().getDescripcionProblema().getText());
        if (this.controlador.getModelo().getStatus() != null) {
            this.checkBoxActivo.getModel().setSelected(this.controlador.getModelo().getStatus().getEstado().equalsIgnoreCase("Active"));
        }
        if (this.controlador.getModelo().getFechaInicio() != null) {
            fecha = this.controlador.getModelo().getFechaInicio().getExactDateTime().split("-");
            this.dateChooserFechaInicio.setDate(new Date(Integer.parseInt(fecha[0]), Integer.parseInt(fecha[1]), Integer.parseInt(fecha[2])));
        }
        if (this.controlador.getModelo().getFechaFin() != null) {
            fecha = this.controlador.getModelo().getFechaFin().getExactDateTime().split("-");
            this.dateChooserFechaFin.setDate(new Date(Integer.parseInt(fecha[0]), Integer.parseInt(fecha[1]), Integer.parseInt(fecha[2])));
        }
    }

    private String comprobarDatos() {
        if (this.dateChooserFechaInicio.getDate().after(this.dateChooserFechaFin.getDate())) {
            return "La fecha de comienzo de la enfermedad debe ser anterior a la de fin";
        }
        String fechaInicio = CommonTools.getDateAsString(this.dateChooserFechaInicio.getDate());
        String fechaFin = CommonTools.getDateAsString(this.dateChooserFechaFin.getDate());
        boolean estado = this.checkBoxActivo.isSelected();
        if (this.textFieldEnfermedad.getText().isEmpty()) {
            return "El nombre de la enfermedad no puede estar en blanco";
        }
        String nombreEnfermedad = this.textFieldEnfermedad.getText();
        this.controlador.insertNewEnfermedad(nombreEnfermedad, estado, fechaInicio, fechaFin);
        return null;
    }

    public Problemas getEnfermedadModelo() {
        if (this.saved) {
            return this.controlador.getModelo();
        }
        return null;
    }

    public void updateView() {
        this.rellenarDatos();
    }

    private void initComponents() {
        this.labelTitulo = new JLabel();
        this.labelFechaFIn = new JLabel();
        this.labelFechaInicio = new JLabel();
        this.dateChooserFechaFin = new JDateChooser();
        this.dateChooserFechaInicio = new JDateChooser();
        this.checkBoxActivo = new JCheckBox();
        this.textFieldEnfermedad = new JTextField();
        this.labelMedicacion = new JLabel();
        this.buttonAceptar = new JButton();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setLocationByPlatform(true);
        this.setMinimumSize(new Dimension(400, 209));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.labelTitulo.setBackground(new Color(0, 153, 255));
        this.labelTitulo.setFont(new Font("Trebuchet MS", 0, 18));
        this.labelTitulo.setForeground(new Color(255, 255, 255));
        this.labelTitulo.setText("Enfermedad o dolencia");
        this.labelTitulo.setMaximumSize(new Dimension(1200, 40));
        this.labelTitulo.setMinimumSize(new Dimension(400, 40));
        this.labelTitulo.setOpaque(true);
        this.labelTitulo.setPreferredSize(new Dimension(400, 40));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.labelTitulo, gridBagConstraints);
        this.labelFechaFIn.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelFechaFIn.setText("Fecha de fin (opcional)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 8, 0, 0);
        this.getContentPane().add((Component)this.labelFechaFIn, gridBagConstraints);
        this.labelFechaInicio.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelFechaInicio.setText("Fecha de diagn\u00f3stico (opcional)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 8, 0, 0);
        this.getContentPane().add((Component)this.labelFechaInicio, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.insets = new Insets(6, 145, 0, 0);
        this.getContentPane().add((Component)this.dateChooserFechaFin, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.insets = new Insets(6, 145, 0, 0);
        this.getContentPane().add((Component)this.dateChooserFechaInicio, gridBagConstraints);
        this.checkBoxActivo.setText("Enfermedad activa");
        this.checkBoxActivo.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 8, 0, 0);
        this.getContentPane().add((Component)this.checkBoxActivo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 1, 6);
        this.getContentPane().add((Component)this.textFieldEnfermedad, gridBagConstraints);
        this.labelMedicacion.setFont(new Font("Trebuchet MS", 0, 14));
        this.labelMedicacion.setText("Nombre de la enfermedad o dolencia");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.getContentPane().add((Component)this.labelMedicacion, gridBagConstraints);
        this.buttonAceptar.setBackground(new Color(255, 255, 255));
        this.buttonAceptar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonAceptar.setForeground(new Color(0, 102, 255));
        this.buttonAceptar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/accept 24x24.png")));
        this.buttonAceptar.setText("Aceptar");
        this.buttonAceptar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonAceptar.setContentAreaFilled(false);
        this.buttonAceptar.setHorizontalAlignment(2);
        this.buttonAceptar.setMaximumSize(new Dimension(90, 24));
        this.buttonAceptar.setMinimumSize(new Dimension(90, 24));
        this.buttonAceptar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoDetallesEnfermedad.this.buttonAceptarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 100);
        this.getContentPane().add((Component)this.buttonAceptar, gridBagConstraints);
        this.jButton1.setBackground(new Color(255, 255, 255));
        this.jButton1.setFont(new Font("Trebuchet MS", 1, 14));
        this.jButton1.setForeground(new Color(0, 102, 255));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/back 24x24.png")));
        this.jButton1.setText("Cerrar");
        this.jButton1.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.jButton1.setContentAreaFilled(false);
        this.jButton1.setHorizontalAlignment(2);
        this.jButton1.setMaximumSize(new Dimension(90, 24));
        this.jButton1.setMinimumSize(new Dimension(90, 24));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoDetallesEnfermedad.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.jButton1, gridBagConstraints);
        this.pack();
    }

    private void buttonAceptarActionPerformed(ActionEvent evt) {
        String errores = this.comprobarDatos();
        if (errores == null) {
            this.saved = true;
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, "Por favor, revise los datos introducidos \n" + errores, "Atenci\u00f3n, datos err\u00f3neos", 2);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

