/*
 * Decompiled with CFR 0.152.
 */
package Application.Vistas.Dialogos;

import Application.Herramientas.CargadorDatosFichero;
import Application.Herramientas.CommonTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogoElegirNombreDeListado
extends JDialog {
    ArrayList<String> baseDatosEnfermedades = null;
    String nombreEnfermedad = null;
    String fechaInicio = null;
    String fechaFin = null;
    private JButton buttonCancelar;
    private JButton buttonInsertar;
    private JScrollPane jScrollPane1;
    private JLabel labelTitulo1;
    private JList listaElementos;
    private JTextField textFieldNombreBuscado;

    public DialogoElegirNombreDeListado(Frame parent, boolean modal, String titulo, String filePath) {
        super(parent, modal);
        this.initComponents();
        this.getContentPane().setBackground(Color.white);
        ArrayList<String> enfermedades = CargadorDatosFichero.cargaFicheroEnfermedadesMedicamentos(filePath);
        this.labelTitulo1.setText(titulo);
        if (enfermedades == null || enfermedades.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Error al cargar las datos");
            this.dispose();
        } else {
            this.baseDatosEnfermedades = enfermedades;
            this.rellenarListaEnfermedades(this.baseDatosEnfermedades);
            CommonTools.centrarVentana(this);
        }
    }

    public String getFechaFin() {
        return this.fechaFin;
    }

    public String getFechaInicio() {
        return this.fechaInicio;
    }

    public String getNombreEnfermedad() {
        return this.nombreEnfermedad;
    }

    public static String selectNewEnfermedad() {
        DialogoElegirNombreDeListado dialogo = new DialogoElegirNombreDeListado(null, true, "Introduzca el nombre de la enfermedad", "./Data/Enfermedades.txt");
        if (dialogo.getNombreEnfermedad() != null) {
            return dialogo.getNombreEnfermedad();
        }
        return null;
    }

    public static String selectNewMedicamento() {
        DialogoElegirNombreDeListado dialogo = new DialogoElegirNombreDeListado(null, true, "Introduzca el nombre del medicamento", "./Data/Medicamentos.txt");
        if (dialogo.getNombreEnfermedad() != null) {
            return dialogo.getNombreEnfermedad();
        }
        return null;
    }

    private void initComponents() {
        this.textFieldNombreBuscado = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.listaElementos = new JList();
        this.buttonInsertar = new JButton();
        this.buttonCancelar = new JButton();
        this.labelTitulo1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Escriba o seleccione de la lista");
        this.setAlwaysOnTop(true);
        this.setMinimumSize(new Dimension(400, 256));
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.textFieldNombreBuscado.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                DialogoElegirNombreDeListado.this.textFieldNombreBuscadoKeyPressed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 252;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 10);
        this.getContentPane().add((Component)this.textFieldNombreBuscado, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.listaElementos);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 235;
        gridBagConstraints.ipady = 107;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 10);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.buttonInsertar.setFont(new Font("Trebuchet MS", 0, 14));
        this.buttonInsertar.setForeground(new Color(0, 102, 255));
        this.buttonInsertar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/add 24x24.png")));
        this.buttonInsertar.setText("Insertar");
        this.buttonInsertar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonInsertar.setContentAreaFilled(false);
        this.buttonInsertar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoElegirNombreDeListado.this.buttonInsertarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 0, 8, 100);
        this.getContentPane().add((Component)this.buttonInsertar, gridBagConstraints);
        this.buttonCancelar.setFont(new Font("Trebuchet MS", 0, 14));
        this.buttonCancelar.setForeground(new Color(0, 102, 255));
        this.buttonCancelar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/back 24x24.png")));
        this.buttonCancelar.setText("Cancelar");
        this.buttonCancelar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonCancelar.setContentAreaFilled(false);
        this.buttonCancelar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoElegirNombreDeListado.this.buttonCancelarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 0, 8, 9);
        this.getContentPane().add((Component)this.buttonCancelar, gridBagConstraints);
        this.labelTitulo1.setBackground(new Color(0, 153, 255));
        this.labelTitulo1.setFont(new Font("Trebuchet MS", 0, 18));
        this.labelTitulo1.setForeground(new Color(255, 255, 255));
        this.labelTitulo1.setText("Insertar nueva ?");
        this.labelTitulo1.setMaximumSize(new Dimension(400, 40));
        this.labelTitulo1.setMinimumSize(new Dimension(400, 40));
        this.labelTitulo1.setOpaque(true);
        this.labelTitulo1.setPreferredSize(new Dimension(400, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 7, 0);
        this.getContentPane().add((Component)this.labelTitulo1, gridBagConstraints);
        this.pack();
    }

    private void buttonInsertarActionPerformed(ActionEvent evt) {
        if (this.listaElementos.isSelectionEmpty()) {
            JOptionPane.showMessageDialog(this, "Debe seleccionar un elemento");
        } else {
            this.nombreEnfermedad = (String)this.listaElementos.getSelectedValue();
            this.dispose();
        }
    }

    private void buttonCancelarActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void rellenarListaEnfermedades(ArrayList<String> enfermedades) {
        DefaultListModel<String> model = new DefaultListModel<String>();
        Iterator<String> it1 = enfermedades.iterator();
        int i = 0;
        while (it1.hasNext()) {
            model.add(i, it1.next());
            ++i;
        }
        this.listaElementos.setModel(model);
        this.listaElementos.repaint();
    }

    private void textFieldNombreBuscadoKeyPressed(KeyEvent evt) {
        String nombre = this.textFieldNombreBuscado.getText().toUpperCase();
        if (nombre != null) {
            ArrayList<String> resultado = CargadorDatosFichero.buscaEnfermedades(this.baseDatosEnfermedades, nombre);
            this.rellenarListaEnfermedades(resultado);
        }
    }
}

