/*
 * Decompiled with CFR 0.152.
 */
package Application.Vistas.Dialogos;

import Application.ConectorBBDDAuxiliar.ConectorSSII;
import Application.Herramientas.CommonTools;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Tupla;
import DataManager.GoogleHealthManager.Conector;
import com.google.gdata.util.ServiceException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class DialogoNuevoPaciente
extends JDialog {
    int estadoProceso = 1;
    private JButton buttonAceptar;
    private JButton buttonCancelar;
    private JButton buttonPasoAnterior;
    private JButton buttonPasoSiguiente;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JLabel labelTitulo;
    private JLabel labelTutorial;
    private JPanel panelAlta;
    private JPasswordField passwordField1;
    private JPasswordField passwordField2;
    private JTextField textFieldApellidos;
    private JTextField textFieldEmail;
    private JTextField textFieldNombre;
    private JTextField textFieldUsuario;

    public DialogoNuevoPaciente() {
        this.setModal(true);
        this.initComponents();
        this.getContentPane().setBackground(Color.white);
        this.panelAlta.setVisible(false);
        new Thread(new Runnable(){

            public void run() {
                DialogoNuevoPaciente.this.lanzarNavegador();
            }
        }).start();
        CommonTools.centrarVentana(this);
    }

    private void lanzarNavegador() {
        block6: {
            try {
                Thread.sleep(5000L);
                String url = "http://www.google.com/health/";
                String osName = System.getProperty("os.name");
                try {
                    if (osName.startsWith("Windows")) {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                        break block6;
                    }
                    if (osName.startsWith("Mac OS X")) {
                        Runtime.getRuntime().exec("open " + url);
                        break block6;
                    }
                    System.out.println("Please open a browser and go to " + url);
                }
                catch (IOException e) {
                    System.out.println("Failed to start a browser to open the url " + url);
                    e.printStackTrace();
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DialogoNuevoPaciente.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void cambiarLabelTutorial() {
        String nombreImagen = "tutorial" + this.estadoProceso + ".png";
        this.labelTutorial.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/imgTutorial/" + nombreImagen)));
    }

    private boolean datosCorrectos() {
        if (!this.comprobarFormatoEmail(this.textFieldEmail.getText())) {
            JOptionPane.showMessageDialog(this, "Email mal escrito", "Atenci\u00f3n", 2);
            return false;
        }
        String password = new String(this.passwordField1.getPassword());
        String password2 = new String(this.passwordField2.getPassword());
        if (this.textFieldUsuario.getText().isEmpty() || this.textFieldEmail.getText().isEmpty() || password.isEmpty() || password2.isEmpty() || this.textFieldNombre.getText().isEmpty() || this.textFieldApellidos.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Debe rellenar todos los campos", "Atenci\u00f3n", 2);
            return false;
        }
        if (!password.equals(password2)) {
            JOptionPane.showMessageDialog(this, "Las contrase\u00f1as no coinciden. Vuelva a introducirlas", "Error", 0);
            this.passwordField1.setText("");
            this.passwordField2.setText("");
            return false;
        }
        if (ConectorSSII.getConector().containsUsuario(this.textFieldUsuario.getText())) {
            JOptionPane.showMessageDialog(this, "El nombre de usuario no est\u00e1 disponible, por favor elija otro", "Error", 0);
            return false;
        }
        return true;
    }

    private boolean comprobarFormatoEmail(String email) {
        if (!email.isEmpty()) {
            Pattern patron = Pattern.compile("([0-9]|[a-z]|.|-|_)*@([0-9]|[a-z]|.)+\\.[a-z]+");
            Matcher encajador = patron.matcher(email);
            return encajador.matches();
        }
        return true;
    }

    private void initComponents() {
        this.labelTitulo = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.panelAlta = new JPanel();
        this.jLabel3 = new JLabel();
        this.textFieldEmail = new JTextField();
        this.jLabel9 = new JLabel();
        this.passwordField2 = new JPasswordField();
        this.buttonAceptar = new JButton();
        this.passwordField1 = new JPasswordField();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.textFieldNombre = new JTextField();
        this.jLabel10 = new JLabel();
        this.textFieldApellidos = new JTextField();
        this.jLabel8 = new JLabel();
        this.textFieldUsuario = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.labelTutorial = new JLabel();
        this.buttonPasoAnterior = new JButton();
        this.buttonPasoSiguiente = new JButton();
        this.buttonCancelar = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(1049, 619));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.labelTitulo.setBackground(new Color(0, 153, 255));
        this.labelTitulo.setFont(new Font("Trebuchet MS", 0, 18));
        this.labelTitulo.setForeground(new Color(255, 255, 255));
        this.labelTitulo.setText("Alta de nuevo paciente");
        this.labelTitulo.setMaximumSize(new Dimension(400, 40));
        this.labelTitulo.setMinimumSize(new Dimension(400, 40));
        this.labelTitulo.setOpaque(true);
        this.labelTitulo.setPreferredSize(new Dimension(400, 40));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.labelTitulo, gridBagConstraints);
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setMaximumSize(new Dimension(Short.MAX_VALUE, 80));
        this.jScrollPane1.setOpaque(false);
        this.jScrollPane1.setPreferredSize(new Dimension(237, 80));
        this.jTextArea1.setBackground(new Color(224, 239, 244));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(new Font("Trebuchet MS", 0, 14));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setTabSize(3);
        this.jTextArea1.setText("Bienvenido al proceso de ALTA DE PACIENTE,   \nen breves momentos se abrir\u00e1 una ventana de su explorador y se le redigir\u00e1 autom\u00e1ticamente a la p\u00e1gina oficial de Google Health. \n\nPor favor, siga los pasos abajo descritos.");
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setBorder(null);
        this.jTextArea1.setMaximumSize(new Dimension(Integer.MAX_VALUE, 80));
        this.jTextArea1.setMinimumSize(new Dimension(164, 80));
        this.jScrollPane1.setViewportView(this.jTextArea1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.panelAlta.setMaximumSize(new Dimension(649, 400));
        this.panelAlta.setMinimumSize(new Dimension(649, 400));
        this.panelAlta.setOpaque(false);
        this.panelAlta.setPreferredSize(new Dimension(649, 400));
        this.panelAlta.setLayout(new GridBagLayout());
        this.jLabel3.setText("Contrase\u00f1a:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 14, 0, 12);
        this.panelAlta.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 0, 12);
        this.panelAlta.add((Component)this.textFieldEmail, gridBagConstraints);
        this.jLabel9.setText("Correo electr\u00f3nico:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipady = -2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 14, 0, 12);
        this.panelAlta.add((Component)this.jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 0, 12);
        this.panelAlta.add((Component)this.passwordField2, gridBagConstraints);
        this.buttonAceptar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonAceptar.setForeground(new Color(0, 102, 255));
        this.buttonAceptar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/accept 24x24.png")));
        this.buttonAceptar.setText("Aceptar");
        this.buttonAceptar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonAceptar.setContentAreaFilled(false);
        this.buttonAceptar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoNuevoPaciente.this.buttonAceptarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(9, 0, 8, 11);
        this.panelAlta.add((Component)this.buttonAceptar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 0, 12);
        this.panelAlta.add((Component)this.passwordField1, gridBagConstraints);
        this.jLabel2.setText("Nombre:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 14, 0, 12);
        this.panelAlta.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel4.setText("Repetir contrase\u00f1a:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 14, 0, 12);
        this.panelAlta.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 0, 12);
        this.panelAlta.add((Component)this.textFieldNombre, gridBagConstraints);
        this.jLabel10.setText("Apellidos:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 14, 0, 12);
        this.panelAlta.add((Component)this.jLabel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 0, 12);
        this.panelAlta.add((Component)this.textFieldApellidos, gridBagConstraints);
        this.jLabel8.setText("Nombre de usuario:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 14, 0, 12);
        this.panelAlta.add((Component)this.jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 0, 0, 12);
        this.panelAlta.add((Component)this.textFieldUsuario, gridBagConstraints);
        this.jScrollPane2.setBackground(new Color(224, 239, 244));
        this.jTextArea2.setBackground(new Color(224, 239, 244));
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setFont(new Font("Trebuchet MS", 0, 14));
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setRows(7);
        this.jTextArea2.setTabSize(3);
        this.jTextArea2.setText("A continuaci\u00f3n, complete el siguiente formulario.\nEl nombre y los apellidos deben coincidir con los introducidos anteriormente en Google Health.\nEl nombre de usuario ser\u00e1 el identificador con el que el paciente acceder\u00e1 a la aplicaci\u00f3n.\nEl correo electr\u00f3nico es el correo de contacto del paciente.\nEl campo Contrase\u00f1a es la contrase\u00f1a con la que el paciente acceder\u00e1 a la aplicaci\u00f3n. \n\nPor favor, finalizado el proceso de alta, informe al paciente de su nombre de usuario y contrase\u00f1a.");
        this.jTextArea2.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.jTextArea2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelAlta.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.panelAlta, gridBagConstraints);
        this.labelTutorial.setBackground(new Color(255, 255, 255));
        this.labelTutorial.setHorizontalAlignment(0);
        this.labelTutorial.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/imgTutorial/tutorial1.png")));
        this.labelTutorial.setHorizontalTextPosition(0);
        this.labelTutorial.setIconTextGap(0);
        this.labelTutorial.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.labelTutorial, gridBagConstraints);
        this.buttonPasoAnterior.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonPasoAnterior.setForeground(new Color(0, 102, 255));
        this.buttonPasoAnterior.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/back 24x24.png")));
        this.buttonPasoAnterior.setText("Paso anterior");
        this.buttonPasoAnterior.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonPasoAnterior.setContentAreaFilled(false);
        this.buttonPasoAnterior.setCursor(new Cursor(12));
        this.buttonPasoAnterior.setEnabled(false);
        this.buttonPasoAnterior.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoNuevoPaciente.this.buttonPasoAnteriorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 200);
        this.getContentPane().add((Component)this.buttonPasoAnterior, gridBagConstraints);
        this.buttonPasoSiguiente.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonPasoSiguiente.setForeground(new Color(0, 102, 255));
        this.buttonPasoSiguiente.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/next 24x24.png")));
        this.buttonPasoSiguiente.setText("Paso siguiente");
        this.buttonPasoSiguiente.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonPasoSiguiente.setContentAreaFilled(false);
        this.buttonPasoSiguiente.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoNuevoPaciente.this.buttonPasoSiguienteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 200, 0, 0);
        this.getContentPane().add((Component)this.buttonPasoSiguiente, gridBagConstraints);
        this.buttonCancelar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonCancelar.setForeground(new Color(0, 102, 255));
        this.buttonCancelar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/delete 24x24.png")));
        this.buttonCancelar.setText("Cancelar");
        this.buttonCancelar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonCancelar.setContentAreaFilled(false);
        this.buttonCancelar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogoNuevoPaciente.this.buttonCancelarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 0, 10, 15);
        this.getContentPane().add((Component)this.buttonCancelar, gridBagConstraints);
        this.pack();
    }

    private void buttonAceptarActionPerformed(ActionEvent evt) {
        if (this.datosCorrectos()) {
            try {
                String nombreGH = this.textFieldApellidos.getText() + ',' + this.textFieldNombre.getText();
                ArrayList<Tupla> idsYNombres = Conector.getConector().getAllProfileNamesAndIds();
                String idInternoGoogle = null;
                for (Tupla elem : idsYNombres) {
                    if (!((String)elem.getObj2()).equalsIgnoreCase(nombreGH)) continue;
                    idInternoGoogle = (String)elem.getObj1();
                    break;
                }
                if (idInternoGoogle != null) {
                    Date sqlDate = new Date(new java.util.Date().getTime());
                    ConectorSSII.getConector().insertarNuevoMedico(Conector.getUser(), Conector.getPass(), sqlDate);
                    ConectorSSII.getConector().insertarNuevoPaciente(this.textFieldNombre.getText(), this.textFieldApellidos.getText(), this.textFieldUsuario.getText(), new String(this.passwordField1.getPassword()), this.textFieldEmail.getText(), Conector.getUser(), idInternoGoogle, sqlDate);
                    ConectorSSII.cerrarConexion();
                    JOptionPane.showMessageDialog(this, "Usuario dado de alta correctamente", "Confirmaci\u00f3n", 1);
                    this.dispose();
                } else {
                    JOptionPane.showMessageDialog(this, "El nombre y apellidos del paciente no se encuentran en Google Health, por favor compruebeque os datos se han introducido correctamente", "Error", 1);
                }
            }
            catch (MalformedURLException ex) {
                System.err.println("GH Service failed: " + ex);
            }
            catch (ServiceException ex) {
                System.err.println("GH Service failed: " + (Object)((Object)ex));
            }
            catch (IOException ex) {
                System.err.println("GH Service failed: " + ex);
            }
        }
    }

    private void buttonPasoSiguienteActionPerformed(ActionEvent evt) {
        if (this.estadoProceso == 1) {
            ++this.estadoProceso;
            this.buttonPasoAnterior.setEnabled(true);
            this.cambiarLabelTutorial();
            return;
        }
        if (this.estadoProceso == 2) {
            ++this.estadoProceso;
            this.cambiarLabelTutorial();
            return;
        }
        if (this.estadoProceso == 3) {
            ++this.estadoProceso;
            this.buttonPasoSiguiente.setEnabled(false);
            this.labelTutorial.setVisible(false);
            this.panelAlta.setVisible(true);
            return;
        }
    }

    private void buttonPasoAnteriorActionPerformed(ActionEvent evt) {
        if (this.estadoProceso == 2) {
            --this.estadoProceso;
            this.buttonPasoAnterior.setEnabled(false);
            this.cambiarLabelTutorial();
            return;
        }
        if (this.estadoProceso == 3) {
            --this.estadoProceso;
            this.cambiarLabelTutorial();
            return;
        }
        if (this.estadoProceso == 4) {
            --this.estadoProceso;
            this.buttonPasoSiguiente.setEnabled(true);
            this.labelTutorial.setVisible(true);
            this.panelAlta.setVisible(false);
            return;
        }
    }

    private void buttonCancelarActionPerformed(ActionEvent evt) {
        int option = JOptionPane.showConfirmDialog(this, "Si cancela el proceso ahora, puede que haya datos que no funcionen correctamente, si desea cancelar igualmente, cerci\u00f3nese de borrar en Google Health cualquier dato creado durante el proceso", "Atenci\u00f3n, \u00bfseguro que desea cancelar?", 0, 2, null);
        if (option == 1) {
            this.dispose();
        }
    }
}

