/*
 * Decompiled with CFR 0.152.
 */
package Application.Vistas.Paneles;

import Application.Controladores.ControladorPacienteView;
import Application.Modelos.Paciente;
import Application.Vistas.Interfaces.PacienteView;
import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class PanelDatosPersonales
extends JPanel
implements PacienteView {
    ControladorPacienteView controlador;
    int idVista;
    private JPanel PanelContacto;
    private JButton buttonAplicar;
    private JButton buttonCancelar;
    private JButton buttonEditar;
    private JComboBox comboBoxDiabetes;
    private JComboBox comboBoxSexo;
    private JDateChooser dateChooserFechaNacimiento;
    private JTextField fieldApellidosPaciente;
    private JTextField fieldDireccion;
    private JTextField fieldEdadDiagnostico;
    private JTextField fieldEmail;
    private JTextField fieldLocalidad;
    private JTextField fieldNombrePaciente;
    private JTextField fieldTelefono1;
    private JTextField fieldTelefono2;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel labelApellidos;
    private JLabel labelAviso;
    private JLabel labelEdadDiabetes;
    private JLabel labelEmail;
    private JLabel labelFechaNacimiento;
    private JLabel labelNombre;
    private JLabel labelSexo;
    private JLabel labelTipoDiabetes;
    private JLabel labelTitulo1;
    private JLabel labelTitulo2;
    private JPanel panelInfoPaciente;

    public PanelDatosPersonales(ControladorPacienteView controlador) {
        this.initComponents();
        this.controlador = controlador;
        this.idVista = controlador.addViewToModel(this);
        this.labelAviso.setVisible(false);
        if (this.rellenarDatosPanel()) {
            this.labelAviso.setVisible(true);
        }
        this.switchModoEditar(false);
    }

    private boolean rellenarDatosPanel() {
        boolean perfilIncompleto = false;
        Paciente modelo = this.controlador.getModelo();
        this.fieldNombrePaciente.setText(modelo.getNombre());
        this.fieldApellidosPaciente.setText(modelo.getApellidos());
        if (modelo.getFechaNacimiento() != null) {
            String[] fechaPartida = modelo.getFechaNacimiento().getTipo().getType().split("-");
            int anioNacimiento = Integer.parseInt(fechaPartida[0]);
            int mesNacimiento = Integer.parseInt(fechaPartida[1]) - 1;
            int diaNacimiento = Integer.parseInt(fechaPartida[2].split("T")[0]);
            GregorianCalendar fechaActual = new GregorianCalendar();
            fechaActual.set(anioNacimiento, mesNacimiento, diaNacimiento);
            this.dateChooserFechaNacimiento.setCalendar((Calendar)fechaActual);
        } else {
            this.labelFechaNacimiento.setForeground(Color.RED);
            perfilIncompleto = true;
        }
        if (modelo.getSexo() != null) {
            if (modelo.getSexo().getTipo().getType().equalsIgnoreCase("Hombre")) {
                this.comboBoxSexo.setSelectedIndex(0);
            } else {
                this.comboBoxSexo.setSelectedIndex(1);
            }
        } else {
            this.comboBoxSexo.setSelectedItem(null);
            this.labelSexo.setForeground(Color.RED);
            perfilIncompleto = true;
        }
        if (modelo.getDiabetes() != null) {
            if (modelo.getDiabetes().getDescripcionProblema().getText().equalsIgnoreCase("Diabetes Tipo 1")) {
                this.comboBoxDiabetes.setSelectedIndex(0);
            } else {
                this.comboBoxDiabetes.setSelectedIndex(1);
            }
            this.fieldEdadDiagnostico.setText("" + this.controlador.calcularEdadDiagnostico());
        } else {
            this.comboBoxDiabetes.setSelectedItem(null);
            this.labelTipoDiabetes.setForeground(Color.RED);
            this.labelEdadDiabetes.setForeground(Color.RED);
        }
        if (modelo.getDireccion() != null) {
            this.fieldDireccion.setText(modelo.getDireccion().getTipo().getType());
        }
        if (modelo.getLocalidad() != null) {
            this.fieldLocalidad.setText(modelo.getLocalidad().getTipo().getType());
        }
        if (modelo.getTelefono1() != null) {
            this.fieldTelefono1.setText(modelo.getTelefono1().getTipo().getType());
        }
        if (modelo.getTelefono2() != null) {
            this.fieldTelefono2.setText(modelo.getTelefono2().getTipo().getType());
        }
        if (modelo.getEmail() != null) {
            this.fieldEmail.setText(modelo.getEmail().getTipo().getType());
        }
        return perfilIncompleto;
    }

    public void updateView() {
        this.rellenarDatosPanel();
    }

    public int getIdVista() {
        return this.idVista;
    }

    private void initComponents() {
        this.panelInfoPaciente = new JPanel();
        this.fieldApellidosPaciente = new JTextField();
        this.comboBoxSexo = new JComboBox();
        this.labelApellidos = new JLabel();
        this.labelSexo = new JLabel();
        this.fieldNombrePaciente = new JTextField();
        this.dateChooserFechaNacimiento = new JDateChooser();
        this.labelFechaNacimiento = new JLabel();
        this.labelNombre = new JLabel();
        this.labelTipoDiabetes = new JLabel();
        this.comboBoxDiabetes = new JComboBox();
        this.fieldEdadDiagnostico = new JTextField();
        this.labelEdadDiabetes = new JLabel();
        this.labelTitulo1 = new JLabel();
        this.PanelContacto = new JPanel();
        this.fieldEmail = new JTextField();
        this.fieldTelefono2 = new JTextField();
        this.fieldTelefono1 = new JTextField();
        this.fieldLocalidad = new JTextField();
        this.fieldDireccion = new JTextField();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jLabel28 = new JLabel();
        this.jLabel29 = new JLabel();
        this.labelEmail = new JLabel();
        this.labelTitulo2 = new JLabel();
        this.buttonCancelar = new JButton();
        this.buttonAplicar = new JButton();
        this.buttonEditar = new JButton();
        this.labelAviso = new JLabel();
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(703, 438));
        this.setLayout(new GridBagLayout());
        this.panelInfoPaciente.setMinimumSize(new Dimension(772, 194));
        this.panelInfoPaciente.setOpaque(false);
        this.panelInfoPaciente.setPreferredSize(new Dimension(772, 194));
        this.panelInfoPaciente.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 200);
        this.panelInfoPaciente.add((Component)this.fieldApellidosPaciente, gridBagConstraints);
        this.comboBoxSexo.setModel(new DefaultComboBoxModel<String>(new String[]{"Hombre", "Mujer"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 32;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panelInfoPaciente.add((Component)this.comboBoxSexo, gridBagConstraints);
        this.labelApellidos.setFont(new Font("Tahoma", 1, 11));
        this.labelApellidos.setText("Apellidos:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panelInfoPaciente.add((Component)this.labelApellidos, gridBagConstraints);
        this.labelSexo.setFont(new Font("Tahoma", 1, 11));
        this.labelSexo.setText("Sexo:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panelInfoPaciente.add((Component)this.labelSexo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 166;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panelInfoPaciente.add((Component)this.fieldNombrePaciente, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 145;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panelInfoPaciente.add((Component)this.dateChooserFechaNacimiento, gridBagConstraints);
        this.labelFechaNacimiento.setFont(new Font("Tahoma", 1, 11));
        this.labelFechaNacimiento.setText("Fecha de nacimiento:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panelInfoPaciente.add((Component)this.labelFechaNacimiento, gridBagConstraints);
        this.labelNombre.setFont(new Font("Tahoma", 1, 11));
        this.labelNombre.setText("Nombre:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panelInfoPaciente.add((Component)this.labelNombre, gridBagConstraints);
        this.labelTipoDiabetes.setFont(new Font("Tahoma", 1, 11));
        this.labelTipoDiabetes.setText("Tipo de diabetes:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(26, 4, 4, 4);
        this.panelInfoPaciente.add((Component)this.labelTipoDiabetes, gridBagConstraints);
        this.comboBoxDiabetes.setFont(new Font("Tahoma", 1, 11));
        this.comboBoxDiabetes.setModel(new DefaultComboBoxModel<String>(new String[]{"Tipo 1", "Tipo 2"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(26, 4, 4, 4);
        this.panelInfoPaciente.add((Component)this.comboBoxDiabetes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 58;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panelInfoPaciente.add((Component)this.fieldEdadDiagnostico, gridBagConstraints);
        this.labelEdadDiabetes.setFont(new Font("Tahoma", 1, 11));
        this.labelEdadDiabetes.setText("Edad del diagnostico");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 14;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panelInfoPaciente.add((Component)this.labelEdadDiabetes, gridBagConstraints);
        this.labelTitulo1.setBackground(new Color(0, 153, 255));
        this.labelTitulo1.setFont(new Font("Trebuchet MS", 0, 18));
        this.labelTitulo1.setForeground(new Color(255, 255, 255));
        this.labelTitulo1.setText("Datos Personales");
        this.labelTitulo1.setMaximumSize(new Dimension(400, 40));
        this.labelTitulo1.setMinimumSize(new Dimension(400, 40));
        this.labelTitulo1.setOpaque(true);
        this.labelTitulo1.setPreferredSize(new Dimension(400, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelInfoPaciente.add((Component)this.labelTitulo1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panelInfoPaciente, gridBagConstraints);
        this.PanelContacto.setMaximumSize(new Dimension(860, Short.MAX_VALUE));
        this.PanelContacto.setMinimumSize(new Dimension(772, 194));
        this.PanelContacto.setOpaque(false);
        this.PanelContacto.setPreferredSize(new Dimension(772, 194));
        this.PanelContacto.setLayout(new GridBagLayout());
        this.fieldEmail.setMinimumSize(new Dimension(600, 20));
        this.fieldEmail.setPreferredSize(new Dimension(600, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.PanelContacto.add((Component)this.fieldEmail, gridBagConstraints);
        this.fieldTelefono2.setMinimumSize(new Dimension(600, 20));
        this.fieldTelefono2.setPreferredSize(new Dimension(600, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.PanelContacto.add((Component)this.fieldTelefono2, gridBagConstraints);
        this.fieldTelefono1.setMinimumSize(new Dimension(600, 20));
        this.fieldTelefono1.setPreferredSize(new Dimension(600, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.PanelContacto.add((Component)this.fieldTelefono1, gridBagConstraints);
        this.fieldLocalidad.setMinimumSize(new Dimension(600, 20));
        this.fieldLocalidad.setPreferredSize(new Dimension(600, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.PanelContacto.add((Component)this.fieldLocalidad, gridBagConstraints);
        this.fieldDireccion.setMinimumSize(new Dimension(600, 20));
        this.fieldDireccion.setPreferredSize(new Dimension(600, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.PanelContacto.add((Component)this.fieldDireccion, gridBagConstraints);
        this.jLabel26.setFont(new Font("Tahoma", 1, 11));
        this.jLabel26.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/home 16x16.png")));
        this.jLabel26.setText("Direcci\u00f3n:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 4, 0, 0);
        this.PanelContacto.add((Component)this.jLabel26, gridBagConstraints);
        this.jLabel27.setFont(new Font("Tahoma", 1, 11));
        this.jLabel27.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/home 16x16.png")));
        this.jLabel27.setText("Localidad:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 4, 0, 0);
        this.PanelContacto.add((Component)this.jLabel27, gridBagConstraints);
        this.jLabel28.setFont(new Font("Tahoma", 1, 11));
        this.jLabel28.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/phone 16x16.png")));
        this.jLabel28.setText("Tel\u00e9fono 1:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 4, 0, 0);
        this.PanelContacto.add((Component)this.jLabel28, gridBagConstraints);
        this.jLabel29.setFont(new Font("Tahoma", 1, 11));
        this.jLabel29.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/phone 16x16.png")));
        this.jLabel29.setText("Tel\u00e9fono2:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 4, 0, 0);
        this.PanelContacto.add((Component)this.jLabel29, gridBagConstraints);
        this.labelEmail.setFont(new Font("Tahoma", 1, 11));
        this.labelEmail.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/email 16x16.png")));
        this.labelEmail.setText("Email:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 4, 0, 0);
        this.PanelContacto.add((Component)this.labelEmail, gridBagConstraints);
        this.labelTitulo2.setBackground(new Color(0, 153, 255));
        this.labelTitulo2.setFont(new Font("Trebuchet MS", 0, 18));
        this.labelTitulo2.setForeground(new Color(255, 255, 255));
        this.labelTitulo2.setText("Informaci\u00f3n de contacto");
        this.labelTitulo2.setMaximumSize(new Dimension(400, 40));
        this.labelTitulo2.setMinimumSize(new Dimension(400, 40));
        this.labelTitulo2.setOpaque(true);
        this.labelTitulo2.setPreferredSize(new Dimension(400, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.PanelContacto.add((Component)this.labelTitulo2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.PanelContacto, gridBagConstraints);
        this.buttonCancelar.setBackground(new Color(255, 255, 255));
        this.buttonCancelar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonCancelar.setForeground(new Color(0, 102, 255));
        this.buttonCancelar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/back 24x24.png")));
        this.buttonCancelar.setText("Cancelar");
        this.buttonCancelar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonCancelar.setContentAreaFilled(false);
        this.buttonCancelar.setCursor(new Cursor(12));
        this.buttonCancelar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelDatosPersonales.this.buttonCancelarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 5, 9);
        this.add((Component)this.buttonCancelar, gridBagConstraints);
        this.buttonAplicar.setBackground(new Color(255, 255, 255));
        this.buttonAplicar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonAplicar.setForeground(new Color(0, 102, 255));
        this.buttonAplicar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/accept 24x24.png")));
        this.buttonAplicar.setText("Aplicar");
        this.buttonAplicar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonAplicar.setContentAreaFilled(false);
        this.buttonAplicar.setCursor(new Cursor(12));
        this.buttonAplicar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelDatosPersonales.this.buttonAplicarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 4, 100);
        this.add((Component)this.buttonAplicar, gridBagConstraints);
        this.buttonEditar.setBackground(new Color(255, 255, 255));
        this.buttonEditar.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonEditar.setForeground(new Color(0, 102, 255));
        this.buttonEditar.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/tools 24x24.png")));
        this.buttonEditar.setText("Editar datos");
        this.buttonEditar.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonEditar.setContentAreaFilled(false);
        this.buttonEditar.setCursor(new Cursor(12));
        this.buttonEditar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelDatosPersonales.this.buttonEditarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 5, 9);
        this.add((Component)this.buttonEditar, gridBagConstraints);
        this.labelAviso.setFont(new Font("Trebuchet MS", 1, 14));
        this.labelAviso.setForeground(new Color(255, 102, 0));
        this.labelAviso.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/warning 16x16.png")));
        this.labelAviso.setText("Atenci\u00f3n: Existen campos obligatorios vac\u00edos. Por favor compl\u00e9telos antes de continuar");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.labelAviso, gridBagConstraints);
    }

    public String darFormatoFecha() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date fechaNacimiento = new Date(this.dateChooserFechaNacimiento.getDate().toGMTString());
        String fechaNacimientoFormateada = null;
        fechaNacimientoFormateada = sdf.format(fechaNacimiento);
        String hora = "00";
        String min = "00";
        fechaNacimientoFormateada = fechaNacimientoFormateada + "T" + hora + ":" + min + ":00Z";
        return fechaNacimientoFormateada;
    }

    private void buttonAplicarActionPerformed(ActionEvent evt) {
        if (this.comprobarCamposValidos()) {
            if (this.dateChooserFechaNacimiento.getDate() != null) {
                this.controlador.insertOrUpdateFechaDeNacimiento(this.darFormatoFecha());
            }
            int edadDiagnostico = 0;
            if (!this.fieldEdadDiagnostico.getText().isEmpty()) {
                edadDiagnostico = Integer.parseInt(this.fieldEdadDiagnostico.getText());
            }
            if (this.comboBoxDiabetes.getSelectedItem() != null & edadDiagnostico != 0) {
                this.controlador.insertOrUpdateDiabetes("Diabetes " + this.comboBoxDiabetes.getSelectedItem().toString(), edadDiagnostico);
            }
            if (this.comboBoxSexo.getSelectedItem() != null) {
                this.controlador.insertOrUpdateSexo(this.comboBoxSexo.getSelectedItem().toString());
            }
            if (!this.fieldDireccion.getText().isEmpty()) {
                this.controlador.insertOrUpdateDireccion(this.fieldDireccion.getText());
            }
            if (!this.fieldLocalidad.getText().isEmpty()) {
                this.controlador.insertOrUpdateLocalidad(this.fieldLocalidad.getText());
            }
            if (!this.fieldTelefono1.getText().isEmpty()) {
                this.controlador.insertOrUpdateTelefono1(this.fieldTelefono1.getText());
            }
            if (!this.fieldTelefono2.getText().isEmpty()) {
                this.controlador.insertOrUpdateTelefono2(this.fieldTelefono2.getText());
            }
            if (!this.fieldEmail.getText().isEmpty()) {
                this.controlador.insertOrUpdateEmail(this.fieldEmail.getText());
            }
            this.controlador.updateModelo();
            this.switchModoEditar(false);
        }
    }

    private boolean comprobarCamposValidos() {
        if (!this.comprobarFormatoTelefono(this.fieldTelefono1.getText())) {
            JOptionPane.showMessageDialog(this, "El formato del telefono introducido es incorrecto, debe tener 9 numeros", "Formato del telefono incorrecto", 0);
            this.fieldTelefono1.setBackground(Color.red);
            return false;
        }
        if (!this.comprobarFormatoTelefono(this.fieldTelefono2.getText())) {
            JOptionPane.showMessageDialog(this, "El formato del telefono introducido es incorrecto, debe tener 9 numeros", "Formato del telefono incorrecto", 0);
            this.fieldTelefono2.setBackground(Color.red);
            return false;
        }
        if (!this.comprobarFormatoEmail(this.fieldEmail.getText())) {
            JOptionPane.showMessageDialog(this, "El formato del email introducido es incorrecto", "Formato del email incorrecto", 0);
            this.fieldEmail.setBackground(Color.red);
            return false;
        }
        if (this.comboBoxSexo.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this, "El sexo esta en blanco", "Selecciona un sexo", 0);
            return false;
        }
        return true;
    }

    private void buttonCancelarActionPerformed(ActionEvent evt) {
        this.rellenarDatosPanel();
        this.switchModoEditar(false);
    }

    private void switchModoEditar(boolean modo) {
        this.buttonAplicar.setVisible(modo);
        this.buttonCancelar.setVisible(modo);
        this.buttonEditar.setVisible(!modo);
        this.dateChooserFechaNacimiento.getCalendarButton().setEnabled(modo);
        this.dateChooserFechaNacimiento.getDateEditor().setEnabled(modo);
        this.comboBoxSexo.setEnabled(modo);
        this.comboBoxDiabetes.setEnabled(modo);
        this.fieldEdadDiagnostico.setEditable(modo);
        this.fieldDireccion.setEditable(modo);
        this.fieldTelefono1.setEditable(modo);
        this.fieldTelefono2.setEditable(modo);
        this.fieldLocalidad.setEditable(modo);
        this.fieldEmail.setEditable(modo);
        if (!modo) {
            this.fieldNombrePaciente.setBackground(Color.WHITE);
            this.fieldApellidosPaciente.setBackground(Color.WHITE);
            this.comboBoxDiabetes.setBackground(Color.WHITE);
            this.comboBoxSexo.setBackground(Color.WHITE);
            this.fieldEdadDiagnostico.setBackground(Color.WHITE);
            this.fieldLocalidad.setBackground(Color.WHITE);
            this.fieldDireccion.setBackground(Color.WHITE);
            this.fieldTelefono1.setBackground(Color.WHITE);
            this.fieldTelefono2.setBackground(Color.WHITE);
            this.fieldEmail.setBackground(Color.WHITE);
        }
    }

    private boolean comprobarFormatoDNI(String DNI) {
        DNI.toUpperCase();
        Pattern patron = Pattern.compile("[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][A-Z|a-z]");
        Matcher encajador = patron.matcher(DNI);
        return encajador.matches();
    }

    private boolean comprobarFormatoTelefono(String telefono) {
        if (!telefono.isEmpty()) {
            Pattern patron = Pattern.compile("[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]");
            Matcher encajador = patron.matcher(telefono);
            return encajador.matches();
        }
        return true;
    }

    private boolean comprobarFormatoEmail(String email) {
        if (!email.isEmpty()) {
            Pattern patron = Pattern.compile("([0-9]|[a-z]|.|-|_)*@([0-9]|[a-z]|.)+\\.[a-z]+");
            Matcher encajador = patron.matcher(email);
            return encajador.matches();
        }
        return true;
    }

    private void buttonEditarActionPerformed(ActionEvent evt) {
        this.switchModoEditar(true);
    }
}

