/*
 * Decompiled with CFR 0.152.
 */
package Application.Vistas.Paneles;

import Application.Controladores.ControladorPacienteView;
import Application.Herramientas.CellRenderInsulinasGlucemias;
import Application.Herramientas.ColumnGroup;
import Application.Herramientas.CommonTools;
import Application.Herramientas.GroupableTableHeader;
import Application.Modelos.Analisis;
import Application.Modelos.ResultadoTest;
import Application.Vistas.Dialogos.DialogoGraficas;
import Application.Vistas.Dialogos.DialogoNuevaGlucemia;
import Application.Vistas.Dialogos.DialogoNuevaInsulina;
import Application.Vistas.Interfaces.PacienteView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelInsulinaGlucemias
extends JPanel
implements PacienteView {
    ControladorPacienteView controlador;
    Date fechaInicial;
    int idVista;
    String[][] comentarios;
    private JButton buttonGraficas;
    private ButtonGroup buttonGroup1;
    private JButton buttonNuevaGlucemia;
    private JButton buttonNuevaInsulina;
    private JComboBox comboBoxIntervalo;
    private JLabel jLabel1;
    private JScrollPane jScrollPane6;
    private JLabel labelVerUltimos;
    private JPanel panelDatos;
    private JPanel panelHerramientas;
    private JScrollPane scrollPaneTextAreaComentario;
    private JTable tablaMedidas;
    private JTextArea textAreaComentario;

    public PanelInsulinaGlucemias(ControladorPacienteView controlador, String rol) {
        this.initComponents();
        this.controlador = controlador;
        this.idVista = controlador.addViewToModel(this);
        this.fechaInicial = new Date();
        this.fechaInicial.setTime(this.fechaInicial.getTime() - 604800000L);
        this.fechaInicial.setHours(0);
        this.fechaInicial.setMinutes(0);
        this.fechaInicial.setSeconds(0);
        this.scrollPaneTextAreaComentario.setVisible(false);
        this.comentarios = new String[8][7];
        this.configurarTabla();
        this.rellenarDatos();
        if (rol.equalsIgnoreCase("Medico")) {
            this.buttonNuevaGlucemia.setVisible(false);
            this.buttonNuevaInsulina.setVisible(false);
        }
    }

    private void configurarTabla() {
        this.tablaMedidas.setRowHeight(30);
        TableColumnModel cm = this.tablaMedidas.getColumnModel();
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            cm.getColumn(i).setPreferredWidth(100);
            cm.getColumn(i).setWidth(100);
        }
        this.tablaMedidas.setTableHeader(new GroupableTableHeader(this.tablaMedidas.getColumnModel()));
        String[] tableHeaders = new String[]{"Antes Desayunar", "Desayuno", "MediaMa\u00f1ana", "Comida", "Merienda", "Cena", "Antes de dormir"};
        GroupableTableHeader header = (GroupableTableHeader)this.tablaMedidas.getTableHeader();
        int j = 1;
        for (int i = 0; i < tableHeaders.length; ++i) {
            ColumnGroup grupo = new ColumnGroup(tableHeaders[i]);
            grupo.add(cm.getColumn(j));
            grupo.add(cm.getColumn(++j));
            ++j;
            header.addColumnGroup(grupo);
        }
        header.revalidate();
    }

    private void rellenarDatos() {
        for (int i = this.tablaMedidas.getRowCount(); i > 0; --i) {
            ((DefaultTableModel)this.tablaMedidas.getModel()).removeRow(i - 1);
        }
        ArrayList<Analisis> glucemias = this.controlador.getModelo().getListaGlucemias();
        ArrayList<Analisis> insulinas = this.controlador.getModelo().getInsulinasInyectadas();
        Date fechaHoy = new Date();
        int posVectorGlucemias = this.posPrimerAnalisisIntervalo(glucemias, this.fechaInicial, fechaHoy);
        int posVectorInsulinas = this.posPrimerAnalisisIntervalo(insulinas, this.fechaInicial, fechaHoy);
        Date fechaAux = (Date)this.fechaInicial.clone();
        Date fechaGlucemia = null;
        Date fechaInsulina = null;
        Analisis glucemiaAux = null;
        Analisis insulinaAux = null;
        while (!fechaAux.after(fechaHoy)) {
            Date fechaMasAnterior;
            fechaGlucemia = null;
            fechaInsulina = null;
            glucemiaAux = null;
            insulinaAux = null;
            if (posVectorGlucemias != -1 && posVectorGlucemias < glucemias.size()) {
                fechaGlucemia = glucemias.get(posVectorGlucemias).getResultadosTest().get(0).getFecha();
            }
            if (posVectorInsulinas != -1 && posVectorInsulinas < insulinas.size()) {
                fechaInsulina = insulinas.get(posVectorInsulinas).getResultadosTest().get(0).getFecha();
            }
            if ((fechaMasAnterior = this.getFechaMasAnterior(fechaGlucemia, fechaInsulina)) == null) {
                fechaMasAnterior = new Date();
            }
            this.rellenarVaciaHasta(fechaAux, fechaMasAnterior);
            if (fechaGlucemia != null && fechaAux.getDate() == fechaGlucemia.getDate() && fechaAux.getMonth() == fechaGlucemia.getMonth() && fechaAux.getYear() == fechaGlucemia.getYear()) {
                glucemiaAux = glucemias.get(posVectorGlucemias);
                ++posVectorGlucemias;
            }
            if (fechaInsulina != null && fechaAux.getDate() == fechaInsulina.getDate() && fechaAux.getMonth() == fechaInsulina.getMonth() && fechaAux.getYear() == fechaInsulina.getYear()) {
                insulinaAux = insulinas.get(posVectorInsulinas);
                ++posVectorInsulinas;
            }
            this.insertarNuevoDatoTabla(glucemiaAux, insulinaAux);
            fechaAux.setTime(fechaAux.getTime() + 86400000L);
        }
    }

    private Date getFechaMasAnterior(Date fecha1, Date fecha2) {
        if (fecha1 == null) {
            return fecha2;
        }
        if (fecha2 == null) {
            return fecha1;
        }
        if (fecha1.before(fecha2)) {
            return fecha1;
        }
        return fecha2;
    }

    private void rellenarVaciaHasta(Date fechaInicial, Date fechaFinal) {
        while (fechaInicial.getDate() != fechaFinal.getDate() || fechaInicial.getMonth() != fechaFinal.getMonth() || fechaInicial.getYear() != fechaFinal.getYear()) {
            this.comentarios[this.tablaMedidas.getRowCount()] = null;
            ((DefaultTableModel)this.tablaMedidas.getModel()).addRow(new Object[]{CommonTools.getDateAsString(fechaInicial), null, null, null, null, null, null, null, null});
            fechaInicial.setTime(fechaInicial.getTime() + 86400000L);
        }
    }

    private int posPrimerAnalisisIntervalo(ArrayList<Analisis> fuente, Date fechaInicial, Date fechaFinal) {
        for (int i = 0; i < fuente.size(); ++i) {
            Date fechaAnalisis = fuente.get(i).getResultadosTest().get(0).getFecha();
            if (fechaInicial.before(fechaAnalisis) && fechaFinal.after(fechaAnalisis)) {
                return i;
            }
            if (fechaInicial.getDate() == fechaAnalisis.getDate() && fechaInicial.getMonth() == fechaAnalisis.getMonth() && fechaInicial.getYear() == fechaAnalisis.getYear()) {
                return i;
            }
            if (fechaFinal.getDate() != fechaAnalisis.getDate() || fechaFinal.getMonth() != fechaAnalisis.getMonth() || fechaFinal.getYear() != fechaAnalisis.getYear()) continue;
            return i;
        }
        return -1;
    }

    private void insertarNuevoDatoTabla(Analisis glucemia, Analisis insulina) {
        int hora;
        String valorAntesDesayuno = null;
        String comentarioAntesDesayuno = null;
        String insulinaAntesDesayuno = null;
        String valorDesayuno = null;
        String comentarioDesayuno = null;
        String insulinaDesayuno = null;
        String valorMediaManana = null;
        String comentarioMediaManana = null;
        String insulinaMediaManana = null;
        String valorComida = null;
        String comentarioComida = null;
        String insulinaComida = null;
        String valorMerienda = null;
        String comentarioMerienda = null;
        String insulinaMerienda = null;
        String valorCena = null;
        String comentarioCena = null;
        String insulinaCena = null;
        String valorAntesDormir = null;
        String comentarioAntesDormir = null;
        String insulinaAntesDormir = null;
        String fecha = null;
        if (glucemia != null) {
            fecha = CommonTools.getDateAsString(glucemia.getResultadosTest().get(0).getFecha());
            for (ResultadoTest res : glucemia.getResultadosTest()) {
                hora = res.getFecha().getHours();
                if (hora < 7) {
                    valorAntesDesayuno = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                    comentarioAntesDesayuno = res.getObservaciones();
                    continue;
                }
                if (hora >= 7 && hora < 10) {
                    valorDesayuno = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                    comentarioDesayuno = res.getObservaciones();
                    continue;
                }
                if (hora >= 10 && hora < 13) {
                    valorMediaManana = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                    comentarioMediaManana = res.getObservaciones();
                    continue;
                }
                if (hora >= 13 && hora < 16) {
                    valorComida = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                    comentarioComida = res.getObservaciones();
                    continue;
                }
                if (hora >= 16 && hora < 21) {
                    valorMerienda = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                    comentarioMerienda = res.getObservaciones();
                    continue;
                }
                if (hora >= 21 && hora < 23) {
                    valorCena = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                    comentarioCena = res.getObservaciones();
                    continue;
                }
                if (hora < 23) continue;
                valorAntesDormir = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                comentarioAntesDormir = res.getObservaciones();
            }
        }
        if (insulina != null) {
            fecha = CommonTools.getDateAsString(insulina.getResultadosTest().get(0).getFecha());
            for (ResultadoTest res : insulina.getResultadosTest()) {
                hora = res.getFecha().getHours();
                if (hora < 7) {
                    insulinaAntesDesayuno = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                    continue;
                }
                if (hora >= 7 && hora < 10) {
                    insulinaDesayuno = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                    continue;
                }
                if (hora >= 10 && hora < 13) {
                    insulinaMediaManana = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                    continue;
                }
                if (hora >= 13 && hora < 16) {
                    insulinaComida = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                    continue;
                }
                if (hora >= 16 && hora < 21) {
                    insulinaMerienda = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                    continue;
                }
                if (hora >= 21 && hora < 23) {
                    insulinaCena = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
                    continue;
                }
                if (hora < 23) continue;
                insulinaAntesDormir = "" + res.getValorObtenido() + " " + res.getUnidadesObtenido();
            }
        }
        this.comentarios[this.tablaMedidas.getRowCount()] = new String[]{comentarioAntesDesayuno, comentarioDesayuno, comentarioMediaManana, comentarioComida, comentarioMerienda, comentarioCena, comentarioAntesDormir};
        if (insulina != null || glucemia != null) {
            ((DefaultTableModel)this.tablaMedidas.getModel()).addRow(new Object[]{fecha, valorAntesDesayuno, insulinaAntesDesayuno, valorDesayuno, insulinaDesayuno, valorMediaManana, insulinaMediaManana, valorComida, insulinaComida, valorMerienda, insulinaMerienda, valorCena, insulinaCena, valorAntesDormir, insulinaAntesDormir});
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.panelHerramientas = new JPanel();
        this.buttonNuevaGlucemia = new JButton();
        this.buttonGraficas = new JButton();
        this.labelVerUltimos = new JLabel();
        this.comboBoxIntervalo = new JComboBox();
        this.buttonNuevaInsulina = new JButton();
        this.panelDatos = new JPanel();
        this.jScrollPane6 = new JScrollPane();
        this.tablaMedidas = new JTable();
        this.scrollPaneTextAreaComentario = new JScrollPane();
        this.textAreaComentario = new JTextArea();
        this.jLabel1 = new JLabel();
        this.setMinimumSize(new Dimension(938, 464));
        this.setPreferredSize(new Dimension(938, 464));
        this.setLayout(new GridBagLayout());
        this.panelHerramientas.setBackground(new Color(0, 153, 255));
        this.panelHerramientas.setMaximumSize(new Dimension(860, 36));
        this.panelHerramientas.setMinimumSize(new Dimension(860, 36));
        this.panelHerramientas.setPreferredSize(new Dimension(860, 36));
        this.panelHerramientas.setLayout(new GridBagLayout());
        this.buttonNuevaGlucemia.setBackground(new Color(255, 255, 255));
        this.buttonNuevaGlucemia.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonNuevaGlucemia.setForeground(new Color(0, 102, 255));
        this.buttonNuevaGlucemia.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/add 24x24.png")));
        this.buttonNuevaGlucemia.setText("Nueva medida de Glucosa");
        this.buttonNuevaGlucemia.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonNuevaGlucemia.setContentAreaFilled(false);
        this.buttonNuevaGlucemia.setCursor(new Cursor(12));
        this.buttonNuevaGlucemia.setOpaque(true);
        this.buttonNuevaGlucemia.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelInsulinaGlucemias.this.buttonNuevaGlucemiaActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panelHerramientas.add((Component)this.buttonNuevaGlucemia, gridBagConstraints);
        this.buttonGraficas.setBackground(new Color(255, 255, 255));
        this.buttonGraficas.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonGraficas.setForeground(new Color(0, 102, 255));
        this.buttonGraficas.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/chart 24x24.png")));
        this.buttonGraficas.setText("Ver como gr\u00e1fica");
        this.buttonGraficas.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonGraficas.setContentAreaFilled(false);
        this.buttonGraficas.setCursor(new Cursor(12));
        this.buttonGraficas.setOpaque(true);
        this.buttonGraficas.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelInsulinaGlucemias.this.buttonGraficasActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panelHerramientas.add((Component)this.buttonGraficas, gridBagConstraints);
        this.labelVerUltimos.setFont(new Font("Trebuchet MS", 1, 14));
        this.labelVerUltimos.setForeground(new Color(255, 255, 255));
        this.labelVerUltimos.setText("Ver los datos de los \u00faltimos");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.panelHerramientas.add((Component)this.labelVerUltimos, gridBagConstraints);
        this.comboBoxIntervalo.setModel(new DefaultComboBoxModel<String>(new String[]{"7 d\u00edas", "14 d\u00edas", "1 mes", "2 meses", "Ver todos"}));
        this.comboBoxIntervalo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelInsulinaGlucemias.this.comboBoxIntervaloActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 8.0;
        this.panelHerramientas.add((Component)this.comboBoxIntervalo, gridBagConstraints);
        this.buttonNuevaInsulina.setBackground(new Color(255, 255, 255));
        this.buttonNuevaInsulina.setFont(new Font("Trebuchet MS", 1, 14));
        this.buttonNuevaInsulina.setForeground(new Color(0, 102, 255));
        this.buttonNuevaInsulina.setIcon(new ImageIcon(this.getClass().getResource("/Application/Vistas/img/iconos/add 24x24.png")));
        this.buttonNuevaInsulina.setText("Nueva dosis de Insulina");
        this.buttonNuevaInsulina.setBorder(new LineBorder(new Color(204, 204, 204), 2, true));
        this.buttonNuevaInsulina.setContentAreaFilled(false);
        this.buttonNuevaInsulina.setOpaque(true);
        this.buttonNuevaInsulina.setCursor(new Cursor(12));
        this.buttonNuevaInsulina.setMaximumSize(new Dimension(145, 29));
        this.buttonNuevaInsulina.setMinimumSize(new Dimension(145, 29));
        this.buttonNuevaInsulina.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelInsulinaGlucemias.this.buttonNuevaInsulinaActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panelHerramientas.add((Component)this.buttonNuevaInsulina, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.panelHerramientas, gridBagConstraints);
        this.panelDatos.setBackground(new Color(255, 255, 255));
        this.panelDatos.setLayout(new GridBagLayout());
        this.jScrollPane6.setMaximumSize(new Dimension(860, Short.MAX_VALUE));
        this.jScrollPane6.setPreferredSize(new Dimension(860, 419));
        this.tablaMedidas.setBackground(new Color(236, 235, 235));
        this.tablaMedidas.setModel(new DefaultTableModel(new Object[0][], new String[]{"Fecha", "Glucemia", "Insulina", "Glucemia", "Insulina", "Glucemia", "Insulina", "Glucemia", "Insulina", "Glucemia", "Insulina", "Glucemia", "Insulina", "Glucemia", "Insulina"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tablaMedidas.setAutoResizeMode(0);
        this.tablaMedidas.setColumnSelectionAllowed(true);
        this.tablaMedidas.setFillsViewportHeight(true);
        this.tablaMedidas.setGridColor(new Color(255, 255, 255));
        this.tablaMedidas.setShowHorizontalLines(false);
        this.tablaMedidas.setShowVerticalLines(false);
        this.tablaMedidas.getTableHeader().setReorderingAllowed(false);
        this.tablaMedidas.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PanelInsulinaGlucemias.this.tablaMedidasMouseClicked(evt);
            }
        });
        this.jScrollPane6.setViewportView(this.tablaMedidas);
        this.tablaMedidas.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.tablaMedidas.getColumnModel().getColumn(0).setResizable(false);
        this.tablaMedidas.getColumnModel().getColumn(1).setResizable(false);
        this.tablaMedidas.getColumnModel().getColumn(2).setResizable(false);
        this.tablaMedidas.getColumnModel().getColumn(3).setResizable(false);
        this.tablaMedidas.getColumnModel().getColumn(4).setResizable(false);
        this.tablaMedidas.getColumnModel().getColumn(5).setResizable(false);
        this.tablaMedidas.getColumnModel().getColumn(6).setResizable(false);
        this.tablaMedidas.getColumnModel().getColumn(7).setResizable(false);
        this.tablaMedidas.getColumnModel().getColumn(8).setResizable(false);
        this.tablaMedidas.getColumnModel().getColumn(9).setResizable(false);
        this.tablaMedidas.getColumnModel().getColumn(10).setResizable(false);
        this.tablaMedidas.getColumnModel().getColumn(11).setResizable(false);
        this.tablaMedidas.getColumnModel().getColumn(12).setResizable(false);
        this.tablaMedidas.getColumnModel().getColumn(13).setResizable(false);
        this.tablaMedidas.getColumnModel().getColumn(14).setResizable(false);
        this.tablaMedidas.setDefaultRenderer(Object.class, new CellRenderInsulinasGlucemias());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelDatos.add((Component)this.jScrollPane6, gridBagConstraints);
        this.textAreaComentario.setColumns(20);
        this.textAreaComentario.setEditable(false);
        this.textAreaComentario.setFont(new Font("Trebuchet MS", 0, 12));
        this.textAreaComentario.setLineWrap(true);
        this.textAreaComentario.setRows(10);
        this.textAreaComentario.setTabSize(5);
        this.textAreaComentario.setWrapStyleWord(true);
        this.textAreaComentario.setBorder(BorderFactory.createTitledBorder("Observaciones"));
        this.textAreaComentario.setMinimumSize(new Dimension(20, 20));
        this.scrollPaneTextAreaComentario.setViewportView(this.textAreaComentario);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 69;
        this.panelDatos.add((Component)this.scrollPaneTextAreaComentario, gridBagConstraints);
        this.jLabel1.setText("Para ver las observaciones correspondientes a un valor, haga click sobre la celda correspondiente a dicho valor.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.panelDatos.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panelDatos, gridBagConstraints);
    }

    private void buttonNuevaGlucemiaActionPerformed(ActionEvent evt) {
        Analisis analisis = DialogoNuevaGlucemia.showDialogNuevaGlucemia(this.controlador.getModelo().getId());
        if (analisis != null) {
            for (ResultadoTest res : analisis.getResultadosTest()) {
                Analisis analisisAux = new Analisis();
                analisisAux.setTipoAnalisis("Glucemia");
                analisisAux.insertNewResultTest(res);
                this.controlador.insertNewAnalisis(analisisAux);
            }
            this.controlador.updateModelo();
        }
    }

    private void buttonGraficasActionPerformed(ActionEvent evt) {
        ArrayList<Analisis> listaGlucemias = this.controlador.getModelo().getListaGlucemias();
        ArrayList<Analisis> listaInsulinas = this.controlador.getModelo().getInsulinasInyectadas();
        new DialogoGraficas(null, true, listaGlucemias, listaInsulinas, "Gr\u00e1fica de glucemias e insulinas");
    }

    private void buttonNuevaInsulinaActionPerformed(ActionEvent evt) {
        Analisis insulinas = DialogoNuevaInsulina.showDialogNuevasInsulinas(this.controlador.getModelo().getId());
        if (insulinas != null) {
            for (ResultadoTest res : insulinas.getResultadosTest()) {
                Analisis analisisAux = new Analisis();
                analisisAux.setTipoAnalisis("Insulina");
                analisisAux.insertNewResultTest(res);
                this.controlador.insertNewAnalisis(analisisAux);
            }
            this.controlador.updateModelo();
        }
    }

    private void comboBoxIntervaloActionPerformed(ActionEvent evt) {
        long valor;
        this.fechaInicial = new Date();
        if (((String)this.comboBoxIntervalo.getModel().getSelectedItem()).equalsIgnoreCase("7 d\u00edas")) {
            this.fechaInicial.setTime(this.fechaInicial.getTime() - 604800000L);
            this.comentarios = new String[8][7];
        }
        if (((String)this.comboBoxIntervalo.getModel().getSelectedItem()).equalsIgnoreCase("14 d\u00edas")) {
            this.fechaInicial.setTime(this.fechaInicial.getTime() - 1209600000L);
            this.comentarios = new String[15][7];
        }
        if (((String)this.comboBoxIntervalo.getModel().getSelectedItem()).equalsIgnoreCase("1 mes")) {
            valor = Long.parseLong("2419200000");
            this.fechaInicial.setTime(this.fechaInicial.getTime() - valor);
            this.comentarios = new String[32][7];
        }
        if (((String)this.comboBoxIntervalo.getModel().getSelectedItem()).equalsIgnoreCase("2 meses")) {
            valor = Long.parseLong("4838400000");
            this.fechaInicial.setTime(this.fechaInicial.getTime() - valor);
            this.comentarios = new String[63][7];
        }
        if (((String)this.comboBoxIntervalo.getModel().getSelectedItem()).equalsIgnoreCase("Ver todos")) {
            // empty if block
        }
        this.fechaInicial.setHours(0);
        this.fechaInicial.setMinutes(0);
        this.fechaInicial.setSeconds(0);
        this.rellenarDatos();
    }

    private void tablaMedidasMouseClicked(MouseEvent evt) {
        int row;
        int column = this.tablaMedidas.getSelectedColumn();
        if (column > 0 && column % 2 == 1 && this.comentarios[row = this.tablaMedidas.getSelectedRow()] != null && this.comentarios[row][(column - 1) / 2] != null && !this.comentarios[row][(column - 1) / 2].isEmpty()) {
            this.textAreaComentario.setText(this.comentarios[row][(column - 1) / 2]);
            this.scrollPaneTextAreaComentario.setVisible(true);
            SwingUtilities.updateComponentTreeUI(this);
            return;
        }
        this.scrollPaneTextAreaComentario.setVisible(false);
        SwingUtilities.updateComponentTreeUI(this);
    }

    @Override
    public void updateView() {
        this.rellenarDatos();
    }

    @Override
    public int getIdVista() {
        return this.idVista;
    }
}

