/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.ClasesAuxiliares;

import DataManager.GoogleHealthManager.ClasesAuxiliares.CodeType;
import com.google.code.ccr4j.CodedDescriptionType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Description {
    private String text;
    private ArrayList<CodeType> codes;

    public Description() {
        CodeType c = new CodeType();
        this.codes = new ArrayList();
        this.codes.add(c);
    }

    public Description(String description) {
        this.text = description;
        this.codes = new ArrayList();
    }

    public Description(String text, ArrayList<CodeType> codes) {
        if (codes != null) {
            this.codes = new ArrayList();
            for (CodeType code : codes) {
                codes.add(code);
            }
        }
        this.text = text;
    }

    public static Description getDescription(CodedDescriptionType des) {
        if (des == null) {
            return null;
        }
        Description description = new Description();
        description.setText(des.getText());
        List attr1 = des.getCodeList();
        Iterator it = attr1.iterator();
        ArrayList<CodeType> aux = new ArrayList<CodeType>();
        while (it.hasNext()) {
            com.google.code.ccr4j.CodeType e = (com.google.code.ccr4j.CodeType)it.next();
            CodeType aux2 = new CodeType();
            aux2.setValue(e.getValue());
            aux2.setCodingSystem(e.getCodingSystem());
            aux.add(aux2);
        }
        description.setCode(aux);
        return description;
    }

    public Description(Description _description) {
        this.text = _description.getText();
        this.codes = _description.getCodes();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    private void add(CodeType e) {
        this.getCodes().add(e);
    }

    public ArrayList<CodeType> getCodes() {
        return this.codes;
    }

    public void setCode(ArrayList<CodeType> code) {
        this.codes = code;
    }

    public String toString() {
        String codigo = "";
        codigo = codigo + "\n text:" + this.text;
        for (int i = 1; i < this.codes.size(); ++i) {
            codigo = codigo + "\n Codigo del Sistema :" + this.codes.get(i).getCodingSystem() + "     ";
            codigo = codigo + "Valor:   " + this.codes.get(i).getValue() + "      ";
            codigo = codigo + "Versi\u00f3n:    " + this.codes.get(i).getCodingSystem() + "      ";
        }
        return codigo;
    }

    public boolean equals(Object otherDescription) {
        if (otherDescription == null) {
            return false;
        }
        if (!(otherDescription instanceof Description)) {
            return false;
        }
        return this.getText().equalsIgnoreCase(((Description)otherDescription).getText());
    }

    public void setCode(String value, String CodingSystem) {
        CodeType a = new CodeType();
        a.setValue(value);
        a.setCodingSystem(CodingSystem);
        this.codes.add(a);
    }
}

