/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.DAOs;

import DataManager.GoogleHealthManager.Conector;
import DataManager.GoogleHealthManager.DAOs.Interfaces.PersonaDAO;
import DataManager.GoogleHealthManager.DTOs.PersonaDTO;
import DataManager.GoogleHealthManager.Interpreters.PersonaInterpreter;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonaDAOGH
implements PersonaDAO {
    @Override
    public String insertaDatosPersona(PersonaDTO persona, String identificador) {
        String XMLCode = new PersonaInterpreter().translateDTOtoCCR(persona);
        try {
            String newId = Conector.getConector().insert(identificador, XMLCode);
            System.out.println("Person inserted successfully");
            return newId;
        }
        catch (IOException ex) {
            Logger.getLogger(PersonaDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ServiceException ex) {
            Logger.getLogger(PersonaDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    @Override
    public ArrayList<PersonaDTO> getDatosPersonas(String idPaciente) {
        try {
            String XMLData = Conector.getConector().getProfileData(idPaciente);
            ArrayList<PersonaDTO> lista = new PersonaInterpreter().translateCCRtoDTO(XMLData);
            return lista;
        }
        catch (XmlException ex) {
            Logger.getLogger(PersonaDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(PersonaDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ServiceException ex) {
            Logger.getLogger(PersonaDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    @Override
    public boolean actualizarPersona(PersonaDTO persona) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean borrarPersona(PersonaDTO persona) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

