/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.DAOs;

import DataManager.GoogleHealthManager.Conector;
import DataManager.GoogleHealthManager.DAOs.AnalisisDAOGH;
import DataManager.GoogleHealthManager.DAOs.Interfaces.SocialHistoryDAO;
import DataManager.GoogleHealthManager.DTOs.SocialHistoryDTO;
import DataManager.GoogleHealthManager.Interpreters.SocialHistoryInterpreter;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialHistoryDAOGH
implements SocialHistoryDAO {
    @Override
    public ArrayList<SocialHistoryDTO> getSocialHistories(String idPaciente) {
        try {
            String XMLData = null;
            XMLData = Conector.getConector().getProfileData(idPaciente);
            ArrayList<SocialHistoryDTO> lista = new SocialHistoryInterpreter().translateCCRtoDTO(XMLData);
            System.out.println("Social Histories retrieved successfully");
            return lista;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(SocialHistoryDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        catch (ServiceException ex) {
            Logger.getLogger(SocialHistoryDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR DE SERVICIO ESTAS BIEN ACREDITADO??");
        }
        catch (IOException ex) {
            Logger.getLogger(SocialHistoryDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        catch (XmlException ex) {
            Logger.getLogger(SocialHistoryDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR AL CONVERTIR EL CCR EN DTO");
        }
        System.err.println("Social Histories retrieval failed");
        return null;
    }

    @Override
    public String insertSocialHistory(SocialHistoryDTO newSocialHistory, String identificador) {
        String XMLCode = new SocialHistoryInterpreter().translateDTOtoCCR(newSocialHistory);
        try {
            return Conector.getConector().insert(identificador, XMLCode);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        catch (ServiceException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR DE SERVICIO ESTAS BIEN ACREDITADO??");
        }
        catch (IOException ex) {
            Logger.getLogger(AnalisisDAOGH.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("ERROR INTERNO CONECTOR");
        }
        return null;
    }

    @Override
    public boolean removeSocialHistory(String idInterno, String idPaciente) {
        try {
            Conector.getConector().remove(idPaciente, idInterno);
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(SocialHistoryDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ServiceException ex) {
            Logger.getLogger(SocialHistoryDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    @Override
    public boolean updateSocialHistory(SocialHistoryDTO socialHistory, String idPaciente) {
        String XMLCode = new SocialHistoryInterpreter().translateDTOtoCCR(socialHistory);
        try {
            Conector.getConector().update(idPaciente, XMLCode, socialHistory.getIdInterno());
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(SocialHistoryDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ServiceException ex) {
            Logger.getLogger(SocialHistoryDAOGH.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }
}

