/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.DTOs;

import Application.Herramientas.CommonTools;
import Application.Modelos.ResultadoTest;
import DataManager.GoogleHealthManager.ClasesAuxiliares.DateTime;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Description;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Source;
import DataManager.GoogleHealthManager.ClasesAuxiliares.TestResult;

public class ResultadoTestDTO {
    String idInterno = "";
    Description descripcion;
    DateTime testDate;
    TestResult normalResult;
    TestResult resultadoTest;
    Source datosMedico;

    public ResultadoTestDTO() {
    }

    public ResultadoTestDTO(ResultadoTest resultadoTest) {
        this.descripcion = new Description();
        this.descripcion.setText(resultadoTest.getTipoTest());
        if (!resultadoTest.getObservaciones().equals("")) {
            this.descripcion.setText(this.descripcion.getText() + "#" + resultadoTest.getObservaciones());
        }
        this.resultadoTest = new TestResult(resultadoTest.getValorObtenido(), resultadoTest.getUnidadesObtenido());
        this.normalResult = new TestResult(resultadoTest.getValorNormal(), resultadoTest.getUnidadesNormal());
        this.testDate = new DateTime();
        this.testDate.setExactDateTime(CommonTools.getDateAsStringZulu(resultadoTest.getFecha()));
        this.testDate.setType(resultadoTest.getTipoFecha());
    }

    public String getIdInterno() {
        return this.idInterno;
    }

    public void setIdInterno(String idInterno) {
        this.idInterno = idInterno;
    }

    public Source getDatosMedico() {
        return this.datosMedico;
    }

    public void setDatosMedico(Source datosMedico) {
        this.datosMedico = datosMedico;
    }

    public Description getDescripcion() {
        return this.descripcion;
    }

    public void setDescripcion(Description descripcion) {
        this.descripcion = descripcion;
    }

    public TestResult getNormalResult() {
        return this.normalResult;
    }

    public void setNormalResult(TestResult normalResult) {
        this.normalResult = normalResult;
    }

    public TestResult getResultadoTest() {
        return this.resultadoTest;
    }

    public void setResultadoTest(TestResult resultadoTest) {
        this.resultadoTest = resultadoTest;
    }

    public DateTime getTestDate() {
        return this.testDate;
    }

    public void setTestDate(DateTime testDate) {
        this.testDate = testDate;
    }
}

