/*
 * Decompiled with CFR 0.152.
 */
package DataManager.GoogleHealthManager.Interpreters;

import DataManager.GoogleHealthManager.ClasesAuxiliares.Description;
import DataManager.GoogleHealthManager.ClasesAuxiliares.Type;
import DataManager.GoogleHealthManager.DTOs.SocialHistoryDTO;
import com.google.code.ccr4j.CodeType;
import com.google.code.ccr4j.CodedDescriptionType;
import com.google.code.ccr4j.ContinuityOfCareRecordDocument;
import com.google.code.ccr4j.SocialHistoryType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialHistoryInterpreter {
    public ArrayList<SocialHistoryDTO> translateCCRtoDTO(String dataCCRAsString) throws XmlException {
        ContinuityOfCareRecordDocument xmlParseado = ContinuityOfCareRecordDocument.Factory.parse((String)(dataCCRAsString = this.formatearCodigoXML(dataCCRAsString)));
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord CCR = xmlParseado.getContinuityOfCareRecord();
        if (CCR.getBody().getSocialHistory() != null) {
            List SocialHistoryList = CCR.getBody().getSocialHistory().getSocialHistoryElementList();
            Iterator it = SocialHistoryList.iterator();
            ArrayList<SocialHistoryDTO> lista = new ArrayList<SocialHistoryDTO>();
            while (it.hasNext()) {
                SocialHistoryType _socialHistoryType = (SocialHistoryType)it.next();
                SocialHistoryDTO socialHistoryType = this.getSocialHistory(_socialHistoryType);
                socialHistoryType.setIdInterno(_socialHistoryType.getCCRDataObjectID().split("-")[0]);
                lista.add(socialHistoryType);
                System.out.println(socialHistoryType);
            }
            return lista;
        }
        return null;
    }

    public String translateDTOtoCCR(SocialHistoryDTO social) {
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord CCR = ContinuityOfCareRecordDocument.ContinuityOfCareRecord.Factory.newInstance();
        CCR.addNewBody();
        ContinuityOfCareRecordDocument.ContinuityOfCareRecord.Body.SocialHistory socialHistory = CCR.getBody().addNewSocialHistory();
        SocialHistoryType newSocialHistory = socialHistory.addNewSocialHistoryElement();
        this.translateSocialHistoryToCCR(newSocialHistory, social);
        return CCR.xmlText();
    }

    private void translateSocialHistoryToCCR(SocialHistoryType newSociaHistory, SocialHistoryDTO _socialHistory) {
        this._newSocialHistory_Type(_socialHistory.getType(), newSociaHistory);
        this._newSocialHistory_Description(_socialHistory.getDescription(), newSociaHistory);
    }

    private void _newSocialHistory_Type(Type type, SocialHistoryType newSociaHistory) {
        if (type != null) {
            CodedDescriptionType addNewType = newSociaHistory.addNewType();
            addNewType.setText(type.getType());
        }
    }

    private CodedDescriptionType _newSocialHistory_Description(Description _description, SocialHistoryType newSociaHistory) {
        CodedDescriptionType description = newSociaHistory.addNewDescription();
        description.setText(_description.getText());
        if (_description.getCodes() != null) {
            Iterator<DataManager.GoogleHealthManager.ClasesAuxiliares.CodeType> it = _description.getCodes().iterator();
            boolean i = false;
            while (it.hasNext()) {
                DataManager.GoogleHealthManager.ClasesAuxiliares.CodeType e = it.next();
                CodeType c = description.addNewCode();
                c.setValue(e.getValue());
                c.setCodingSystem(e.getCodingSystem());
            }
        }
        return description;
    }

    private SocialHistoryDTO getSocialHistory(SocialHistoryType _socialHistory) {
        SocialHistoryDTO social = new SocialHistoryDTO();
        social.setDescription(Description.getDescription(_socialHistory.getDescription()));
        CodedDescriptionType type = _socialHistory.getType();
        if (type != null) {
            Type _type = Type.getType(type);
            social.setType(_type);
        }
        return social;
    }

    public String formatearCodigoXML(String content) {
        return "<ContinuityOfCareRecord xmlns=\"urn:astm-org:CCR\">\n" + content + "\n" + "</ContinuityOfCareRecord>";
    }
}

