/*
 * Decompiled with CFR 0.152.
 */
package extra.views;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RefineryUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeSeriesView
extends JFrame {
    private static final long serialVersionUID = 1L;
    private String title;
    private String xTitle;
    private String yTitle;
    private ArrayList<XYSeries> series;
    private HashMap<String, XYSeries> seriesMap;
    private XYSeriesCollection dataSet;

    public TimeSeriesView(String topTitle, String title, String xTitle, String yTitle, Collection<String> seriesName) {
        super("");
        this.title = title;
        this.xTitle = xTitle;
        this.yTitle = yTitle;
        this.series = new ArrayList();
        this.seriesMap = new HashMap();
        for (String serieName : seriesName) {
            XYSeries serie = new XYSeries((Comparable)((Object)serieName));
            this.series.add(serie);
            this.seriesMap.put(serieName, serie);
        }
        ChartPanel chartPanel = this.createDemoPanel();
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane((Container)chartPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TimeSeriesView.this.dispose();
            }
        });
        super.pack();
        super.setTitle(topTitle);
        RefineryUtilities.centerFrameOnScreen((Window)this);
        this.setVisible(true);
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = null;
        chart = ChartFactory.createXYLineChart((String)this.title, (String)this.xTitle, (String)this.yTitle, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        return chart;
    }

    private XYDataset createDataset() {
        this.dataSet = new XYSeriesCollection();
        for (int i = 0; i < this.series.size(); ++i) {
            this.dataSet.addSeries(this.series.get(i));
        }
        return this.dataSet;
    }

    public ChartPanel createDemoPanel() {
        JFreeChart chart = this.createChart(this.createDataset());
        return new ChartPanel(chart);
    }

    public void add(double t, double[] y) {
        for (int i = 0; i < y.length; ++i) {
            this.series.get(i).add(t, y[i]);
        }
    }

    public void add(double t, double y, String serieName) {
        this.seriesMap.get(serieName).add(t, y);
    }
}

