/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.continuous;

import java.util.Iterator;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class IntegratorEuler
extends AtomicImpl {
    public static final String in = "in";
    public static final String out = "out";
    protected double dx;
    protected double x;

    public IntegratorEuler(String name, double sampleTime, double x0) {
        super(name);
        super.addInport(in);
        super.addOutport(out);
        super.setSigma(sampleTime);
        this.dx = 0.0;
        this.x = x0;
    }

    public void deltint() {
        this.EulerIntegrationStep(super.getSigma());
    }

    public void deltext(double e, Message x) {
        Iterator<Object> itr = x.getValuesOnPort(in).iterator();
        this.dx = (Double)itr.next();
        this.EulerIntegrationStep(e);
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        msg.add(out, this.x);
        return msg;
    }

    public void EulerIntegrationStep(double delta) {
        this.x += this.dx * delta;
    }
}

