/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.dynamic.discrete;

import lib.atomic.dynamic.IDynSys;
import lib.atomic.dynamic.Sizes;

public class SSdlsys
implements IDynSys {
    private Double[][] F;
    private Double[][] G;
    private Double[][] C;
    private Double[][] D;
    private int n;
    private int m;
    private int p;
    private Double[] x;
    private Double[] y;
    private static final int DEFAULT_H = 1;
    private double h = 1.0;
    private int k = 0;

    public SSdlsys() {
        this.F[0][0] = 0.0;
        this.G[0][0] = 1.0;
        this.C[0][0] = 1.0;
        this.D[0][0] = 0.0;
        this.n = this.F.length;
        this.m = this.G[0].length;
        this.p = this.C.length;
        this.x[0] = 0.0;
        this.y[0] = 0.0;
    }

    public SSdlsys(Double[][] F, Double[][] G, Double[][] C, Double[][] D) {
        this.F = F;
        this.G = G;
        this.C = C;
        this.D = D;
        this.n = F.length;
        this.m = G[0].length;
        this.p = C.length;
        this.x = new Double[this.n];
        this.y = new Double[this.p];
    }

    public SSdlsys(Double[][] F, Double[][] G, Double[][] C, Double[][] D, Double[] x0) {
        this(F, G, C, D);
        for (int i = 0; i < this.n; ++i) {
            this.x[i] = x0[i];
        }
    }

    public SSdlsys(Double[][] F, Double[][] G, Double[][] C, Double[][] D, Double[] x0, double h) {
        this(F, G, C, D, x0);
        this.h = Math.abs(h) > 0.0 ? Math.abs(h) : 1.0;
    }

    public Double[] getState() {
        return this.x;
    }

    public Double[] getOutput() {
        return this.y;
    }

    public int getNx() {
        return this.n;
    }

    public int getNu() {
        return this.m;
    }

    public int getNy() {
        return this.p;
    }

    public Sizes getSizes() {
        Sizes sizes = new Sizes();
        sizes.Nxd = this.n;
        sizes.Nu = this.m;
        sizes.Ny = this.p;
        return sizes;
    }

    public double getSampling() {
        return this.h;
    }

    public double getTime() {
        return (double)this.k * this.h;
    }

    public Double[] update(double dt, Double[] xt, Double[] ut) {
        Double[] xx = new Double[this.n];
        xx = this.fxut((double)this.k * this.h, xt, ut);
        this.x = (Double[])xx.clone();
        ++this.k;
        return xx;
    }

    public Double[] fxut(double dt, Double[] xt, Double[] ut) {
        Double[] xx = new Double[xt.length];
        for (int i = 0; i < this.n; ++i) {
            int j;
            xx[i] = 0.0;
            for (j = 0; j < this.n; ++j) {
                xx[i] = xx[i] + this.F[i][j] * xt[j];
            }
            for (j = 0; j < this.m; ++j) {
                xx[i] = xx[i] + this.G[i][j] * ut[j];
            }
        }
        return xx;
    }

    public Double[] gxut(double tk, Double[] xt, Double[] ut) {
        Double[] yy = new Double[this.p];
        for (int i = 0; i < this.p; ++i) {
            int j;
            yy[i] = 0.0;
            for (j = 0; j < this.n; ++j) {
                yy[i] = yy[i] + this.C[i][j] * this.x[j];
            }
            for (j = 0; j < this.m; ++j) {
                yy[i] = yy[i] + this.D[i][j] * ut[j];
            }
        }
        this.y = (Double[])yy.clone();
        return yy;
    }
}

