/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.general;

import java.util.Iterator;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class Level
extends AtomicImpl {
    public static final String in = "in";
    public static final String out = "out";
    protected double threshold;
    protected boolean level_crossing;

    public Level(String name, double threshold) {
        super(name);
        super.addInport(in);
        super.addOutport(out);
        this.threshold = threshold;
        this.level_crossing = false;
        this.passivate();
    }

    public void deltext(double e, Message x) {
        Iterator<Object> itr = x.getValuesOnPort(in).iterator();
        if ((Double)itr.next() > this.threshold) {
            this.setSigma(0.0);
        }
    }

    public void deltint() {
        this.level_crossing = true;
        this.passivate();
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        if (this.level_crossing) {
            msg.add(out, this.level_crossing);
        }
        return msg;
    }
}

