/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.general;

import lib.extra.types.Job;
import view.modeling.AtomicViewImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class ProcessorView
extends AtomicViewImpl {
    public static final String in = "in";
    public static final String out = "out";
    protected Job currentJob;
    protected double processingTime;

    public ProcessorView(String name, double processingTime) {
        super(name);
        this.addInport(in);
        this.addOutport(out);
        this.currentJob = null;
        this.processingTime = processingTime;
    }

    public void deltint() {
        this.setSigma(Double.POSITIVE_INFINITY);
        this.currentJob = null;
    }

    public void deltext(double e, Message x) {
        if (this.getSigma() == Double.POSITIVE_INFINITY) {
            for (Job this.currentJob : x.getValuesOnPort(in)) {
                this.setSigma(this.processingTime);
            }
        }
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        if (this.currentJob != null) {
            msg.add(out, this.currentJob);
        }
        return msg;
    }
}

