/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.math;

import java.util.Iterator;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class Multiplier
extends AtomicImpl {
    public static final String in = "in";
    public static final String out = "out";
    protected double[] _u;
    protected Double _y;

    public Multiplier(String name, double[] inputs) {
        super(name);
        this.addInport(in);
        this.addOutport(out);
        this._u = new double[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            this._u[i] = 0.0;
        }
        this._y = 0.0;
    }

    public double ta(double t) {
        return super.getSigma();
    }

    public void deltint() {
        super.setSigma(Double.POSITIVE_INFINITY);
    }

    public void deltext(double e, Message x) {
        for (int i = 0; i < this._u.length; ++i) {
            Iterator<Object> itr = x.getValuesOnPort(in + i).iterator();
            if (!itr.hasNext()) continue;
            this._u[i] = (Double)itr.next();
        }
        super.setSigma(0.0);
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        this._y = 1.0;
        for (int i = 0; i < this._u.length; ++i) {
            this._y = this._y * Double.valueOf(this._u[i]);
        }
        if (this._y != null) {
            msg.add(out, this._y);
        }
        return msg;
    }
}

