/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.sinks;

import extra.views.ScopeView;
import java.util.Iterator;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.api.Message;

public class ScopeLine
extends AtomicImpl {
    protected double time;
    protected ScopeView chart;
    protected String topTitle;

    public ScopeLine(String name, double initialTime) {
        super(name);
        this.chart = new ScopeView(name, "title", "xTitle", "yTitle");
        this.time = initialTime;
    }

    public ScopeLine(String name) {
        this(name, 0.0);
    }

    public void addInport(String portName) {
        super.addInport(portName);
        this.chart.addSerie(portName);
    }

    public void addInport(String arrayName, int sizeOfArray) {
        super.addInport(arrayName);
        for (int i = 0; i < sizeOfArray; ++i) {
            this.chart.addSerie(arrayName + "[" + i + "]");
        }
    }

    public void deltint() {
        this.time += super.getSigma();
        super.setSigma(Double.POSITIVE_INFINITY);
    }

    public void deltext(double e, Message x) {
        this.time += e;
        for (String portName : super.getInportNames()) {
            Iterator<Object> itr = x.getValuesOnPort(portName).iterator();
            if (!itr.hasNext()) continue;
            Object input = itr.next();
            if (input.getClass().isArray()) {
                Double[] inputAsArray = (Double[])input;
                this.chart.add((Double)this.time, inputAsArray, portName);
                continue;
            }
            double y = (Double)input;
            this.chart.add(this.time, y, portName);
        }
    }

    public Message lambda() {
        return null;
    }

    public void setTitle(String title) {
        this.chart.setTitle(title);
    }

    public void setXTitle(String title) {
        this.chart.setXTitle(title);
    }

    public void setYTitle(String title) {
        this.chart.setYTitle(title);
    }
}

