/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.sources;

import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class SineWave
extends AtomicImpl {
    public static final String in = "in";
    public static final String out = "out";
    protected Double _amplitude;
    protected Double _frecuency;
    protected Double _phase;
    protected Double _sampleTime;
    protected double tSW;

    public SineWave(String name, double t, Double aM, Double fR, Double pH, Double sT) {
        super(name);
        this.addInport(in);
        this.addOutport(out);
        super.setSigma(0.0);
        this._amplitude = aM;
        this._frecuency = fR;
        this._phase = pH;
        this._sampleTime = sT;
        this.tSW = t;
    }

    public double ta(double t) {
        return super.getSigma();
    }

    public void deltint() {
        super.setSigma(this._sampleTime);
    }

    public void deltext(double e, Message x) {
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        Double output = new Double(this._amplitude * Math.sin(this._frecuency * this.tSW + this._phase));
        if (output != null) {
            msg.add(out, output);
        }
        return msg;
    }
}

