/*
 * Decompiled with CFR 0.152.
 */
package lib.atomic.sources;

import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class SquareWave
extends AtomicImpl {
    public static final String out = "out";
    protected Double amplitude;
    protected Double period;
    protected Double pulseWidth;
    protected Double delay;

    public SquareWave(String name, Double amplitude, Double period, Double pulseWidth, Double delay) {
        super(name);
        this.addOutport(out);
        this.amplitude = amplitude;
        this.period = period;
        this.pulseWidth = pulseWidth;
        this.delay = delay;
        super.setPhase("initial");
        super.setSigma(0.0);
    }

    public void deltint() {
        if (super.getPhase().equals("initial")) {
            this.setSigma(this.delay);
            super.setPhase("high");
        } else if (super.getPhase().equals("high")) {
            this.setSigma(this.period * this.pulseWidth);
            super.setPhase("low");
        } else if (super.getPhase().equals("low")) {
            this.setSigma(this.period - this.period * this.pulseWidth);
            super.setPhase("high");
        }
    }

    public void deltext(double e, Message x) {
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        if (super.getPhase().equals("initial")) {
            msg.add(out, 0);
        } else if (super.getPhase().equals("high")) {
            msg.add(out, this.amplitude);
        } else if (super.getPhase().equals("low")) {
            msg.add(out, 0);
        }
        return msg;
    }
}

