/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.aviones;

import java.util.ArrayList;
import java.util.Vector;
import xdevs.kernel.modeling.AtomicStateImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaState
extends AtomicStateImpl {
    public static final String InRuta = "INRuta";
    public static final String OutWayPoint = "OUTWayPoint";
    public static final String InAvion = "INAvion";
    private Message _msg;
    private static final String puntoActual = "puntoActual";
    private static final String turnosAlejandose = "TurnosAlejandose";
    private static final String distanciaAnterior = "DistanciaAnterior";
    private static final String turnosMinimosRestantes = "TurnosMinimos";
    public static final int NRUTA = 0;
    private ArrayList _trayectoria;

    public RutaState(String nombre) {
        super(nombre);
        this.addInport(InRuta);
        this.addInport(InAvion);
        this.addOutport(OutWayPoint);
        this.addState(puntoActual);
        this.setStateValue(puntoActual, -1);
        this.addState(turnosAlejandose);
        this.setStateValue(turnosAlejandose, 0);
        this.addState(distanciaAnterior);
        this.addState(turnosMinimosRestantes);
        this.setStateValue(turnosMinimosRestantes, -1);
        this._trayectoria = new ArrayList();
        this._msg = new MessageImpl();
        this.setSigma(Double.POSITIVE_INFINITY);
    }

    @Override
    public void deltext(double arg0, Message arg1) {
        for (Vector vector : arg1.getValuesOnPort(InRuta)) {
            switch ((Integer)vector.get(0)) {
                case 0: {
                    this._trayectoria = (ArrayList)vector.get(1);
                    this.pedirPunto();
                }
            }
        }
        for (Vector vector : arg1.getValuesOnPort(InAvion)) {
            if (this._trayectoria.size() <= 0) continue;
            this.controlRuta((Double)((Vector)vector.get(2)).get(2), (Vector)vector.get(0), (Vector)vector.get(1), (Double)vector.get(5));
        }
        this.setSigma(0.0);
    }

    private void controlRuta(Double xi, Vector<Double> p, Vector<Double> v, Double dt) {
        if (this._trayectoria.size() > this.getStateValue(puntoActual).intValue()) {
            double x_obj = new Double(Double.valueOf((String)((ArrayList)this._trayectoria.get(this.getStateValue(puntoActual).intValue())).get(0)));
            double y_obj = new Double(Double.valueOf((String)((ArrayList)this._trayectoria.get(this.getStateValue(puntoActual).intValue())).get(1)));
            double distancia = Math.sqrt((p.get(0) - x_obj) * (p.get(0) - x_obj) + (p.get(1) - y_obj) * (p.get(1) - y_obj));
            System.out.println("turnos restantes" + this.getStateValue(turnosMinimosRestantes));
            System.out.println("turnos alejandose" + this.getStateValue(turnosAlejandose));
            if (this.getStateValue(turnosMinimosRestantes).intValue() == -1) {
                double velocidad = Math.sqrt(v.get(0) * v.get(0) + v.get(1) * v.get(1));
                this.setStateValue(turnosMinimosRestantes, (int)(distancia / velocidad / dt));
            }
            if (this.getStateValue(turnosAlejandose).intValue() >= 3) {
                this.pedirPunto();
                this.setStateValue(turnosAlejandose, 0);
                this.setStateValue(turnosMinimosRestantes, -1);
                this.setStateValue(distanciaAnterior, Double.POSITIVE_INFINITY);
            }
            if (this.getStateValue(turnosMinimosRestantes).intValue() > 0) {
                this.setStateValue(turnosMinimosRestantes, this.getStateValue(turnosMinimosRestantes).intValue() - 1);
            } else if (this.getStateValue(distanciaAnterior).doubleValue() < distancia) {
                this.setStateValue(turnosAlejandose, this.getStateValue(turnosAlejandose).intValue() + 1);
            }
            this.setStateValue(distanciaAnterior, distancia);
        }
    }

    @Override
    public void deltint() {
        this._msg = new MessageImpl();
        this.setSigma(Double.POSITIVE_INFINITY);
    }

    @Override
    public Message lambda() {
        return this._msg;
    }

    public void pedirPunto() {
        if (this._trayectoria.size() > this.getStateValue(puntoActual).intValue()) {
            this.setStateValue(puntoActual, this.getStateValue(puntoActual).intValue() + 1);
        }
        System.out.println("pedir punto");
        Vector<Number> solicitud = new Vector<Number>();
        if (this._trayectoria.size() > this.getStateValue(puntoActual).intValue()) {
            solicitud.add(new Integer(2100));
            solicitud.add(new Double(Double.valueOf((String)((ArrayList)this._trayectoria.get(this.getStateValue(puntoActual).intValue())).get(0))));
            solicitud.add(new Double(Double.valueOf((String)((ArrayList)this._trayectoria.get(this.getStateValue(puntoActual).intValue())).get(1))));
            solicitud.add(new Double(Double.valueOf((String)((ArrayList)this._trayectoria.get(this.getStateValue(puntoActual).intValue())).get(2))));
            this._msg.add(OutWayPoint, solicitud);
        }
    }
}

