/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.aviones;

import proyectoSI.aviones.AvionState;
import proyectoSI.aviones.ControladorRumboState;
import proyectoSI.aviones.PeticionesState;
import proyectoSI.aviones.ReceptorState;
import proyectoSI.aviones.RutaState;
import proyectoSI.grafico.estructura.terreno.Terreno;
import xdevs.kernel.modeling.CoupledImpl;
import xdevs.kernel.simulation.CoordinatorImpl;

public class UAV
extends CoupledImpl {
    private int _id;
    private AvionState _avion;
    private PeticionesState _peticion;
    private ReceptorState _receptor;
    private ControladorRumboState _controlador;
    private RutaState _ruta;
    public static final String IN = "In";
    public static final String INcontrolador = "Incontrolador";
    public static final String OUT = "Out";
    public static final String OUTcontrolador = "Outcontrolador";

    public UAV(int id, Terreno terreno) {
        super("probador");
        this._avion = new AvionState(Integer.valueOf(id).toString(), 1.0, terreno);
        this._peticion = new PeticionesState("Peticiones");
        this._receptor = new ReceptorState(Integer.valueOf(id).toString());
        this._controlador = new ControladorRumboState(Integer.valueOf(id).toString());
        this._ruta = new RutaState("Ruta");
        this.addInport(IN);
        this.addInport(INcontrolador);
        this.addOutport(OUT);
        this.addOutport(OUTcontrolador);
        this.addComponent(this._avion);
        this.addComponent(this._peticion);
        this.addComponent(this._receptor);
        this.addComponent(this._controlador);
        this.addComponent(this._ruta);
        this.addCoupling(this, IN, this._avion, "INsolicitud1");
        this.addCoupling(this, INcontrolador, this._controlador, "INPosRef");
        this.addCoupling(this._avion, "OUTTodo", this, OUT);
        this.addCoupling(this._controlador, "PeticionPunto", this, OUTcontrolador);
        this.addCoupling(this._peticion, "OutPeticionRuta", this._ruta, "INRuta");
        this.addCoupling(this._ruta, "OUTWayPoint", this._controlador, "INPosRefCon");
        this.addCoupling(this._avion, "OUTTodo", this._ruta, "INAvion");
        this.addCoupling(this._peticion, "OutPeticionAvion", this._avion, "INsolicitud1");
        this.addCoupling(this._avion, "OUTposicion", this._receptor, "INPosicion");
        this.addCoupling(this._avion, "OUTVelocidad", this._receptor, "INVelocidad");
        this.addCoupling(this._avion, "OUTAngulos", this._receptor, "INAngulos");
        this.addCoupling(this._avion, "OUTFuel", this._receptor, "INFuel");
        this.addCoupling(this._avion, "OUTEstado", this._receptor, "INEstado");
        this.addCoupling(this._avion, "OUTTodo", this._receptor, "INTodo");
        this.addCoupling(this._peticion, "OutPeticionRumbo", this._controlador, "INPosRef");
        this.addCoupling(this._controlador, "OUTPeticion", this._avion, "INsolicitud2");
        this.addCoupling(this._avion, "controlador", this._controlador, "Inicializar");
        this.addCoupling(this._avion, "OUTTodo", this._controlador, "INAvion");
        this._id = id;
    }

    public int getId() {
        return this._id;
    }

    public PeticionesState getPeticion() {
        return this._peticion;
    }

    public AvionState getAvion() {
        return this._avion;
    }

    public static void main(String[] args) {
        UAV con = new UAV(1, null);
        CoordinatorImpl coordinator = new CoordinatorImpl(con);
        coordinator.simulate(10L);
    }
}

