/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico;

import java.awt.Component;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.swing.JFrame;
import proyectoSI.grafico.Dibujante;
import proyectoSI.grafico.estructura.ManejadorRaton2D;

public class ManagerGL2D
implements GLEventListener {
    private float _xLeft;
    private float _xRight;
    private float _yBot;
    private float _yTop;
    private GLCanvas _lienzo;
    private Dibujante _dibujante;
    private boolean _actualizar;

    public ManagerGL2D(JFrame contenedor, int xLeft, int xRight, int yBot, int yTop, Dibujante dibujante) {
        this._xLeft = xLeft;
        this._xRight = xRight;
        this._yBot = yBot;
        this._yTop = yTop;
        this._lienzo = new GLCanvas();
        this._lienzo.addGLEventListener((GLEventListener)this);
        ManejadorRaton2D manejadorRaton = new ManejadorRaton2D(this);
        this._lienzo.addMouseListener((MouseListener)manejadorRaton);
        this._lienzo.addMouseMotionListener((MouseMotionListener)manejadorRaton);
        contenedor.getContentPane().add((Component)this._lienzo, "Center");
        this._dibujante = dibujante;
        this._actualizar = false;
    }

    public void display(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        drawable.swapBuffers();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        GLU glu = new GLU();
        glu.gluOrtho2D((double)this._xLeft, (double)this._xRight, (double)this._yBot, (double)this._yTop);
        gl.glClear(16384);
        this._dibujante.repintarTerreno(drawable, this._lienzo.getWidth(), this._lienzo.getHeight(), this._xLeft, this._xRight, this._yBot, this._yTop);
        this._actualizar = false;
        this._dibujante.dibujar2D(drawable, this._lienzo.getWidth(), this._lienzo.getHeight(), this._xLeft, this._xRight, this._yBot, this._yTop);
    }

    public void displayChanged(GLAutoDrawable arg0, boolean arg1, boolean arg2) {
    }

    public void init(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        this._dibujante.inicializar(gl);
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        GLU glu = new GLU();
        glu.gluOrtho2D((double)this._xLeft, (double)this._xRight, (double)this._yBot, (double)this._yTop);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glClear(16384);
        this._actualizar = true;
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int ancho, int alto) {
        GL gl = drawable.getGL();
        float radioVolVista = (this._xRight - this._xLeft) / (this._yTop - this._yBot);
        float radioViewPort = (float)ancho / (float)alto;
        gl.glViewport(0, 0, ancho, alto);
        if (radioVolVista >= radioViewPort) {
            float altura_anterior = this._yTop - this._yBot;
            this._yTop -= (altura_anterior - (this._xRight - this._xLeft) / radioViewPort) / 2.0f;
            this._yBot += (altura_anterior - (this._xRight - this._xLeft) / radioViewPort) / 2.0f;
        } else {
            float anchura_anterior = this._xRight - this._xLeft;
            this._xRight -= (anchura_anterior - (this._yTop - this._yBot) * radioViewPort) / 2.0f;
            this._xLeft += (anchura_anterior - (this._yTop - this._yBot) * radioViewPort) / 2.0f;
        }
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        GLU glu = new GLU();
        glu.gluOrtho2D((double)this._xLeft, (double)this._xRight, (double)this._yBot, (double)this._yTop);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        this.actualizar();
    }

    public void actualizar() {
        this._lienzo.repaint();
    }

    public void zoom(float factor) {
        float xRightAnt = this._xRight;
        float xLeftAnt = this._xLeft;
        float yTopAnt = this._yTop;
        float yBotAnt = this._yBot;
        float ancho = (xRightAnt - xLeftAnt) * factor;
        float alto = (yTopAnt - yBotAnt) * factor;
        this._xRight = (xRightAnt + xLeftAnt) / 2.0f + ancho / 2.0f;
        this._xLeft = (xRightAnt + xLeftAnt) / 2.0f - ancho / 2.0f;
        this._yTop = (yTopAnt + yBotAnt) / 2.0f + alto / 2.0f;
        this._yBot = (yTopAnt + yBotAnt) / 2.0f - alto / 2.0f;
        this._actualizar = true;
        this.actualizar();
    }

    public void desplazar(float x, float y) {
        this._xRight += x;
        this._xLeft += x;
        this._yTop += y;
        this._yBot += y;
        this._actualizar = true;
        this.actualizar();
    }

    public void desplazarProporcionadoDerecha() {
        float desplazamiento = (this._xRight - this._xLeft) / 10.0f;
        this._xRight += desplazamiento;
        this._xLeft += desplazamiento;
        this._actualizar = true;
        this.actualizar();
    }

    public void desplazarProporcionadoIzquierda() {
        float desplazamiento = (this._xRight - this._xLeft) / 10.0f;
        this._xRight -= desplazamiento;
        this._xLeft -= desplazamiento;
        this._actualizar = true;
        this.actualizar();
    }

    public void desplazarProporcionadoArriba() {
        float desplazamiento = (this._yTop - this._yBot) / 10.0f;
        this._yTop += desplazamiento;
        this._yBot += desplazamiento;
        this._actualizar = true;
        this.actualizar();
    }

    public void desplazarProporcionadoAbajo() {
        float desplazamiento = (this._yTop - this._yBot) / 10.0f;
        this._yTop -= desplazamiento;
        this._yBot -= desplazamiento;
        this._actualizar = true;
        this.actualizar();
    }

    public void setXLeft(float xLeft) {
        this._xLeft = xLeft;
    }

    public float getXLeft() {
        return this._xLeft;
    }

    public void setXRight(float xRight) {
        this._xRight = xRight;
    }

    public float getXRight() {
        return this._xRight;
    }

    public void setYBot(float yBot) {
        this._yBot = yBot;
    }

    public float getYBot() {
        return this._yBot;
    }

    public void setYTop(float yTop) {
        this._yTop = yTop;
    }

    public float getYTop() {
        return this._yTop;
    }

    public void movimientoRaton(float x, float y) {
        int alto = this._lienzo.getSize().height;
        int ancho = this._lienzo.getSize().width;
        float desX = (this._xRight - this._xLeft) / ((float)ancho / x);
        float desY = (this._yTop - this._yBot) / ((float)alto / y);
        this.desplazar(desX, desY);
    }

    public void dibujarTerreno() {
        this._actualizar = true;
        this._lienzo.repaint();
    }
}

