/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico;

import javax.media.opengl.GL;
import proyectoSI.grafico.Ala;
import proyectoSI.grafico.estructura.Cilindro;
import proyectoSI.grafico.estructura.Color;
import proyectoSI.grafico.estructura.Objeto3D;
import proyectoSI.grafico.estructura.ObjetoCompuesto3D;
import proyectoSI.grafico.estructura.PV3D;
import proyectoSI.grafico.estructura.terreno.Terreno;

public class ModeloAvion
extends ObjetoCompuesto3D {
    private PV3D _pAnterior;
    private Terreno _terreno;

    public ModeloAvion(GL gl, Terreno terreno) {
        int nObjetos = 16;
        int nLados = 8;
        Objeto3D[] objetos = new Objeto3D[nObjetos];
        objetos[0] = new Cilindro(nLados, 2, 1.0f, 1.0f);
        objetos[0].setColor(new Color(1.0f, 1.0f, 1.0f));
        float l1 = 11.0f;
        objetos[0].getTafin().escalar(1.0f, 1.0f, l1, gl);
        objetos[1] = new Cilindro(nLados, 2, 0.3f, 1.0f);
        objetos[1].setColor(new Color(1.0f, 1.0f, 1.0f));
        objetos[1].getTafin().transladar(0.0f, 0.0f, l1, gl);
        float l2 = 1.75f;
        objetos[1].getTafin().escalar(1.0f, 1.0f, l2, gl);
        objetos[2] = new Cilindro(nLados, 2, 0.0f, 0.3f);
        objetos[2].setColor(new Color(1.0f, 1.0f, 1.0f));
        objetos[2].getTafin().transladar(0.0f, 0.0f, l1 + l2, gl);
        float l3 = 0.2f;
        objetos[2].getTafin().escalar(1.0f, 1.0f, l3, gl);
        objetos[3] = new Cilindro(nLados, 2, 1.0f, 0.3f);
        objetos[3].setColor(new Color(0.0f, 0.0f, 0.0f));
        float l4 = 1.5f;
        objetos[3].getTafin().transladar(0.0f, 0.0f, -l4, gl);
        objetos[3].getTafin().escalar(1.0f, 1.0f, l4, gl);
        objetos[4] = new Cilindro(nLados, 2, 0.3f, 0.0f);
        objetos[4].setColor(new Color(0.75f, 0.75f, 0.75f));
        float l5 = 7.0f;
        objetos[4].getTafin().transladar(0.0f, 0.0f, -l4 - l5, gl);
        objetos[4].getTafin().escalar(1.0f, 1.0f, l5, gl);
        objetos[5] = new Ala(1.0f, 6.0f, 4.0f, 0.1f);
        objetos[5].setColor(new Color(0.9f, 0.9f, 0.97f));
        objetos[5].getTafin().transladar(-5.0f, 0.0f, 0.0f, gl);
        objetos[6] = new Ala(6.0f, 1.0f, 4.0f, 0.1f);
        objetos[6].setColor(new Color(0.9f, 0.9f, 0.97f));
        objetos[6].getTafin().transladar(1.0f, 0.0f, 0.0f, gl);
        objetos[7] = new Ala(2.0f, 0.4f, 2.0f, 0.1f);
        objetos[7].getTafin().transladar(0.0f, 1.0f, 0.0f, gl);
        objetos[7].getTafin().rotar(90.0f, 0.0f, 0.0f, 1.0f, gl);
        objetos[7].setColor(new Color(0.75f, 0.75f, 0.75f));
        objetos[8] = new Cilindro(nLados, 2, 0.5f, 0.5f);
        objetos[8].setColor(new Color(0.0f, 0.0f, 0.0f));
        objetos[8].getTafin().escalar(1.0f, 1.0f, 1.5f, gl);
        objetos[8].getTafin().transladar(-3.0f, -0.5f, 0.5f, gl);
        objetos[9] = new Cilindro(nLados, 2, 0.0f, 0.5f);
        objetos[9].getTafin().transladar(-3.0f, -0.5f, 2.0f, gl);
        objetos[9].setColor(new Color(1.0f, 0.0f, 0.0f));
        objetos[10] = new Cilindro(nLados, 2, 0.5f, 0.3f);
        objetos[10].setColor(new Color(0.0f, 0.0f, 0.0f));
        objetos[10].getTafin().escalar(1.0f, 1.0f, 0.3f, gl);
        objetos[10].getTafin().transladar(-3.0f, -0.5f, 1.5f, gl);
        objetos[11] = new Cilindro(nLados, 2, 0.3f, 0.0f);
        objetos[11].setColor(new Color(1.0f, 0.26f, 0.0f));
        objetos[11].getTafin().transladar(-3.0f, -0.5f, -6.5f, gl);
        objetos[11].getTafin().escalar(1.0f, 1.0f, 7.0f, gl);
        objetos[12] = new Cilindro(nLados, 2, 0.5f, 0.5f);
        objetos[12].setColor(new Color(0.0f, 0.0f, 0.0f));
        objetos[12].getTafin().escalar(1.0f, 1.0f, 1.5f, gl);
        objetos[12].getTafin().transladar(3.0f, -0.5f, 0.5f, gl);
        objetos[13] = new Cilindro(nLados, 2, 0.0f, 0.5f);
        objetos[13].getTafin().transladar(3.0f, -0.5f, 2.0f, gl);
        objetos[13].setColor(new Color(1.0f, 0.0f, 0.0f));
        objetos[14] = new Cilindro(nLados, 2, 0.5f, 0.3f);
        objetos[14].setColor(new Color(0.0f, 0.0f, 0.0f));
        objetos[14].getTafin().escalar(1.0f, 1.0f, 0.3f, gl);
        objetos[14].getTafin().transladar(3.0f, -0.5f, 1.5f, gl);
        objetos[15] = new Cilindro(nLados, 2, 0.3f, 0.0f);
        objetos[15].setColor(new Color(1.0f, 0.26f, 0.0f));
        objetos[15].getTafin().transladar(3.0f, -0.5f, -6.5f, gl);
        objetos[15].getTafin().escalar(1.0f, 1.0f, 7.0f, gl);
        this.setNObjetos(nObjetos);
        this.setObjetos(objetos);
        this._terreno = terreno;
    }

    public void roll(float ang, GL gl) {
        this.getTafin().giroAbsolutoZ(ang, gl);
    }

    public void yaw(float ang, GL gl) {
        this.getTafin().giroAbsolutoY(ang, gl);
    }

    public void pitch(float ang, GL gl) {
        this.getTafin().giroAbsolutoX(ang, gl);
    }

    public void posicionar(float x, float y, float z, GL gl) {
        this.getTafin().translacionAbsolutaXYZ(x, y, z, gl);
    }

    public void dibujar2D(float x, float y, GL gl) {
        gl.glPointSize(4.0f);
        gl.glBegin(0);
        if (this._pAnterior != null) {
            if (x >= 0.0f && x / 1000.0f < (float)this._terreno.getLongitud() && y / 1000.0f < (float)this._terreno.getAnchura() && y >= 0.0f) {
                int auxX = (int)x / 1000;
                int auxY = (int)y / 1000;
                float p00 = (float)((1 - (auxX - auxX)) * (1 - (auxY - auxY))) * this._terreno.getAltura(auxX, auxY);
                float p10 = (float)((auxX - auxX) * (1 - (auxY - auxY))) * this._terreno.getAltura(auxX + 1, auxY);
                float p01 = (float)((1 - (auxX - auxX)) * (auxY - auxY)) * this._terreno.getAltura(auxX, auxY + 1);
                float p11 = (float)((auxX - auxX) * (auxY - auxY)) * this._terreno.getAltura(auxX + 1, auxY + 1);
                float altura = p00 + p10 + p01 + p11;
                Color c = Terreno.colorDeMapa(altura);
                gl.glColor3f(c.getRed(), c.getGreen(), c.getBlue());
                gl.glVertex2f(this._pAnterior.getX() / 1000.0f, this._pAnterior.getY() / 1000.0f);
            } else {
                gl.glColor3f(0.0f, 0.0f, 0.0f);
                gl.glVertex2f(this._pAnterior.getX() / 1000.0f, this._pAnterior.getY() / 1000.0f);
            }
        }
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glVertex2f(x / 1000.0f, y / 1000.0f);
        gl.glEnd();
        this._pAnterior = new PV3D(x, y, 0.0f);
    }
}

