/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico.estructura;

import javax.media.opengl.GL;

public class TAfin {
    private float[] _matriz;
    private float _angX;
    private float _angY;
    private float _angZ;
    private float _posX;
    private float _posY;
    private float _posZ;

    public TAfin() {
        this._matriz = new float[16];
        for (int i = 0; i < 16; ++i) {
            this._matriz[i] = 0.0f;
        }
        this._matriz[0] = 1.0f;
        this._matriz[5] = 1.0f;
        this._matriz[10] = 1.0f;
        this._matriz[15] = 1.0f;
        this._angX = 0.0f;
        this._angY = 0.0f;
        this._angZ = 0.0f;
        this._posX = 0.0f;
        this._posY = 0.0f;
        this._posZ = 0.0f;
    }

    public TAfin(float[] matriz) {
        this._matriz = matriz;
    }

    public float[] getMatriz() {
        return this._matriz;
    }

    public void transladar(float x, float y, float z, GL gl) {
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadMatrixf(this._matriz, 0);
        gl.glTranslatef(x, y, z);
        gl.glGetFloatv(2982, this._matriz, 0);
        gl.glPopMatrix();
    }

    public void rotar(float ang, float x, float y, float z, GL gl) {
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadMatrixf(this._matriz, 0);
        gl.glRotatef(ang, x, y, z);
        gl.glGetFloatv(2982, this._matriz, 0);
        gl.glPopMatrix();
    }

    public void escalar(float x, float y, float z, GL gl) {
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadMatrixf(this._matriz, 0);
        gl.glScalef(x, y, z);
        gl.glGetFloatv(2982, this._matriz, 0);
        gl.glPopMatrix();
    }

    public void giroAbsolutoX(float ang, GL gl) {
        float dif = ang - this._angX;
        this._angX = ang;
        this.rotar(dif, 1.0f, 0.0f, 0.0f, gl);
    }

    public void giroAbsolutoY(float ang, GL gl) {
        float dif = ang - this._angY;
        this._angY = ang;
        this.rotar(dif, 0.0f, 1.0f, 0.0f, gl);
    }

    public void giroAbsolutoZ(float ang, GL gl) {
        float dif = ang - this._angZ;
        this._angZ = ang;
        this.rotar(dif, 0.0f, 0.0f, 1.0f, gl);
    }

    public void translacionAbsolutaX(float x, GL gl) {
        float dif = x - this._posX;
        this._posX = x;
        this.transladar(dif, 0.0f, 0.0f, gl);
    }

    public void translacionAbsolutaY(float y, GL gl) {
        float dif = y - this._posY;
        this._posY = y;
        this.transladar(0.0f, dif, 0.0f, gl);
    }

    public void translacionAbsolutaZ(float z, GL gl) {
        float dif = z - this._posZ;
        this._posZ = z;
        this.transladar(0.0f, 0.0f, dif, gl);
    }

    public void translacionAbsolutaXYZ(float x, float y, float z, GL gl) {
        this.translacionAbsolutaX(x, gl);
        this.translacionAbsolutaY(y, gl);
        this.translacionAbsolutaZ(z, gl);
    }
}

