/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.grafico.estructura.terreno;

import javax.media.opengl.GL;
import proyectoSI.grafico.estructura.Color;
import proyectoSI.grafico.estructura.Objeto3D;
import proyectoSI.grafico.estructura.PV3D;

public abstract class Terreno
extends Objeto3D {
    protected boolean m_bTextureMapping;
    private int _longitud;
    private int _anchura;
    private float[][] _alturas;

    public void normalizar(float alturaMax, float alturaMin) {
        int j;
        int i;
        float min = this._alturas[0][0];
        float max = this._alturas[0][0];
        for (i = 0; i < this._longitud; ++i) {
            for (j = 0; j < this._anchura; ++j) {
                if (this._alturas[i][j] > max) {
                    max = this._alturas[i][j];
                    continue;
                }
                if (!(this._alturas[i][j] < min)) continue;
                min = this._alturas[i][j];
            }
        }
        for (i = 0; i < this._longitud; ++i) {
            for (j = 0; j < this._anchura; ++j) {
                this._alturas[i][j] = (this._alturas[i][j] - min) / (max - min) * (alturaMax - alturaMin) + alturaMin;
            }
        }
    }

    private void FilterHeightBand(int indiceX, int indiceZ, int iStride, int iCount, float fFilter) {
        float v = this._alturas[indiceX][indiceZ];
        int j = indiceZ + indiceX * this._anchura;
        for (int i = 0; i < iCount - 1; ++i) {
            int z = j % this._anchura;
            int x = j / this._anchura;
            this._alturas[x][z] = fFilter * v + (1.0f - fFilter) * this._alturas[x][z];
            v = this._alturas[x][z];
            j += iStride;
        }
    }

    public void filtrar(float fFilter) {
        int j;
        int i;
        for (i = 0; i < this._longitud; ++i) {
            this.FilterHeightBand(i, 0, 1, this._anchura, fFilter);
        }
        for (i = 0; i < this._longitud; ++i) {
            this.FilterHeightBand(i, this._anchura - 1, -1, this._anchura, fFilter);
        }
        for (j = 0; j < this._anchura; ++j) {
            this.FilterHeightBand(0, j, this._anchura, this._longitud, fFilter);
        }
        for (j = 0; j < this._anchura; ++j) {
            this.FilterHeightBand(this._longitud - 1, j, -this._anchura, this._longitud, fFilter);
        }
    }

    public float getAltura(int x, int z) {
        return this._alturas[x][z];
    }

    public void setLongitud(int longitud) {
        this._longitud = longitud;
    }

    public int getLongitud() {
        return this._longitud;
    }

    public void setAnchura(int anchura) {
        this._anchura = anchura;
    }

    public int getAnchura() {
        return this._anchura;
    }

    public void setAlturas(float[][] alturas) {
        this._alturas = alturas;
    }

    public float[][] getAlturas() {
        return this._alturas;
    }

    public static Color colorDeMapa(float altura) {
        if (altura > 3500.0f) {
            return new Color(1.0f, 1.0f, 1.0f);
        }
        if (altura > 3400.0f) {
            return new Color(0.984375f, 0.984375f, 0.984375f);
        }
        if (altura > 3300.0f) {
            return new Color(0.96875f, 0.96875f, 0.96875f);
        }
        if (altura > 3200.0f) {
            return new Color(0.953125f, 0.953125f, 0.953125f);
        }
        if (altura > 3100.0f) {
            return new Color(0.9375f, 0.9375f, 0.9375f);
        }
        if (altura > 3000.0f) {
            return new Color(0.921875f, 0.921875f, 0.921875f);
        }
        if (altura > 2900.0f) {
            return new Color(0.8695313f, 0.8695313f, 0.8695313f);
        }
        if (altura > 2800.0f) {
            return new Color(0.8171875f, 0.8171875f, 0.8171875f);
        }
        if (altura > 2700.0f) {
            return new Color(0.76484376f, 0.76484376f, 0.76484376f);
        }
        if (altura > 2600.0f) {
            return new Color(0.7125f, 0.7125f, 0.7125f);
        }
        if (altura > 2500.0f) {
            return new Color(0.66015625f, 0.66015625f, 0.66015625f);
        }
        if (altura > 2400.0f) {
            return new Color(0.63671875f, 0.58203125f, 0.5234375f);
        }
        if (altura > 2300.0f) {
            return new Color(0.61328125f, 0.50390625f, 0.40625f);
        }
        if (altura > 2200.0f) {
            return new Color(0.58984375f, 0.42578125f, 0.2890625f);
        }
        if (altura > 2100.0f) {
            return new Color(0.56640625f, 0.34765625f, 0.171875f);
        }
        if (altura > 2000.0f) {
            return new Color(0.54296875f, 0.26953125f, 0.07421875f);
        }
        if (altura > 1900.0f) {
            return new Color(0.578125f, 0.3203125f, 0.06796875f);
        }
        if (altura > 1800.0f) {
            return new Color(0.61328125f, 0.37109375f, 0.06171875f);
        }
        if (altura > 1700.0f) {
            return new Color(0.6484375f, 0.421875f, 0.05546875f);
        }
        if (altura > 1600.0f) {
            return new Color(0.68359375f, 0.47265625f, 0.04921875f);
        }
        if (altura > 1500.0f) {
            return new Color(0.71875f, 0.5234375f, 0.04296875f);
        }
        if (altura > 1400.0f) {
            return new Color(0.675f, 0.51875f, 0.04296875f);
        }
        if (altura > 1300.0f) {
            return new Color(0.63125f, 0.5140625f, 0.04296875f);
        }
        if (altura > 1200.0f) {
            return new Color(0.5875f, 0.509375f, 0.04296875f);
        }
        if (altura > 1100.0f) {
            return new Color(0.54375f, 0.5046875f, 0.04296875f);
        }
        if (altura > 1000.0f) {
            return new Color(0.5f, 0.5f, 0.04296875f);
        }
        if (altura > 900.0f) {
            return new Color(0.5f, 0.478125f, 0.034375f);
        }
        if (altura > 800.0f) {
            return new Color(0.5f, 0.45625f, 0.02578125f);
        }
        if (altura > 700.0f) {
            return new Color(0.5f, 0.434375f, 0.0171875f);
        }
        if (altura > 600.0f) {
            return new Color(0.5f, 0.4125f, 0.00859375f);
        }
        if (altura > 500.0f) {
            return new Color(0.5f, 0.390625f, 0.0f);
        }
        if (altura > 400.0f) {
            return new Color(0.4f, 0.4125f, 0.0f);
        }
        if (altura > 300.0f) {
            return new Color(0.3f, 0.434375f, 0.0f);
        }
        if (altura > 200.0f) {
            return new Color(0.2f, 0.45625f, 0.0f);
        }
        if (altura > 100.0f) {
            return new Color(0.1f, 0.478125f, 0.0f);
        }
        if (altura > 0.0f) {
            return new Color(0.0f, 0.5f, 0.0f);
        }
        if (altura > -100.0f) {
            return new Color(0.05625f, 0.5953125f, 0.1203125f);
        }
        if (altura > -200.0f) {
            return new Color(0.1125f, 0.690625f, 0.240625f);
        }
        if (altura > -300.0f) {
            return new Color(0.16875f, 0.7859375f, 0.3609375f);
        }
        if (altura > -400.0f) {
            return new Color(0.225f, 0.88125f, 0.48125f);
        }
        if (altura > -500.0f) {
            return new Color(0.28125f, 0.9765625f, 0.6015625f);
        }
        if (altura > -600.0f) {
            return new Color(0.28125f, 0.94453126f, 0.796875f);
        }
        if (altura > -700.0f) {
            return new Color(0.28125f, 0.9125f, 0.796875f);
        }
        if (altura > -800.0f) {
            return new Color(0.28125f, 0.8804687f, 0.796875f);
        }
        if (altura > -900.0f) {
            return new Color(0.28125f, 0.8484375f, 0.796875f);
        }
        if (altura > -1000.0f) {
            return new Color(0.28125f, 0.81640625f, 0.796875f);
        }
        if (altura > -1100.0f) {
            return new Color(0.28125f, 0.81640625f, 0.74609375f);
        }
        if (altura > -1200.0f) {
            return new Color(0.28125f, 0.81640625f, 0.6953125f);
        }
        if (altura > -1300.0f) {
            return new Color(0.28125f, 0.81640625f, 0.64453125f);
        }
        if (altura > -1400.0f) {
            return new Color(0.28125f, 0.81640625f, 0.59375f);
        }
        if (altura > -1500.0f) {
            return new Color(0.28125f, 0.81640625f, 0.54296875f);
        }
        if (altura > -1600.0f) {
            return new Color(0.225f, 0.653125f, 0.54296875f);
        }
        if (altura > -1700.0f) {
            return new Color(0.16875f, 0.48984376f, 0.54296875f);
        }
        if (altura > -1800.0f) {
            return new Color(0.1125f, 0.3265625f, 0.54296875f);
        }
        if (altura > -1900.0f) {
            return new Color(0.05625f, 0.16328125f, 0.54296875f);
        }
        if (altura > -2000.0f) {
            return new Color(0.0f, 0.0f, 0.54296875f);
        }
        if (altura > -2100.0f) {
            return new Color(0.0f, 0.0f, 0.496875f);
        }
        if (altura > -2200.0f) {
            return new Color(0.0f, 0.0f, 0.45078126f);
        }
        if (altura > -2300.0f) {
            return new Color(0.0f, 0.0f, 0.4046875f);
        }
        if (altura > -2400.0f) {
            return new Color(0.0f, 0.0f, 0.35859376f);
        }
        return new Color(0.0f, 0.0f, 0.3125f);
    }

    public static Color colorDeAltura(float altura) {
        if (altura > 3500.0f) {
            return new Color(1.0f, 1.0f, 1.0f);
        }
        if (altura > 3000.0f) {
            return new Color((236.0f + 20.0f * (altura - 3000.0f) / 500.0f) / 256.0f, (236.0f + 20.0f * (altura - 3000.0f) / 500.0f) / 256.0f, (236.0f + 20.0f * (altura - 3000.0f) / 500.0f) / 256.0f);
        }
        if (altura > 2500.0f) {
            return new Color((169.0f + 67.0f * (altura - 2500.0f) / 500.0f) / 256.0f, (169.0f + 67.0f * (altura - 2500.0f) / 500.0f) / 256.0f, (169.0f + 67.0f * (altura - 2500.0f) / 500.0f) / 256.0f);
        }
        if (altura > 2000.0f) {
            return new Color((139.0f + 30.0f * (altura - 2000.0f) / 500.0f) / 256.0f, (69.0f + 100.0f * (altura - 2000.0f) / 500.0f) / 256.0f, (19.0f + 156.0f * (altura - 2000.0f) / 500.0f) / 256.0f);
        }
        if (altura > 1500.0f) {
            return new Color((184.0f - 45.0f * (altura - 1500.0f) / 500.0f) / 256.0f, (134.0f - 65.0f * (altura - 1500.0f) / 500.0f) / 256.0f, (11.0f + 8.0f * (altura - 1500.0f) / 500.0f) / 256.0f);
        }
        if (altura > 1000.0f) {
            return new Color((128.0f + 56.0f * (altura - 1000.0f) / 500.0f) / 256.0f, (128.0f + 6.0f * (altura - 1000.0f) / 500.0f) / 256.0f, 11.0f * (altura - 1000.0f) / 500.0f / 256.0f);
        }
        if (altura > 500.0f) {
            return new Color(128.0f * (altura - 500.0f) / 500.0f / 256.0f, (100.0f + 28.0f * (altura - 500.0f) / 500.0f) / 256.0f, 0.0f);
        }
        if (altura > 30.0f) {
            return new Color(0.0f, (128.0f - 28.0f * (altura - 30.0f) / 470.0f) / 256.0f, 0.0f);
        }
        if (altura > 20.0f) {
            return new Color((256.0f - 256.0f * (altura - 20.0f) / 10.0f) / 256.0f, (231.0f - 103.0f * (altura - 20.0f) / 10.0f) / 256.0f, 0.0f);
        }
        if (altura > 0.0f) {
            return new Color(1.0f, 0.90234375f, 0.0f);
        }
        if (altura > -500.0f) {
            return new Color(72.0f * -altura / 500.0f / 256.0f, (250.0f - 41.0f * -altura / 500.0f) / 256.0f, (154.0f + 50.0f * -altura / 500.0f) / 256.0f);
        }
        if (altura > -1000.0f) {
            return new Color((72.0f - 72.0f * -(altura + 500.0f) / 500.0f) / 256.0f, (209.0f - 70.0f * -(altura + 500.0f) / 500.0f) / 256.0f, (204.0f - 65.0f * -(altura + 500.0f) / 500.0f) / 256.0f);
        }
        if (altura > -1500.0f) {
            return new Color(0.0f, (139.0f - 139.0f * -(altura + 1000.0f) / 500.0f) / 256.0f, 0.54296875f);
        }
        if (altura > -2000.0f) {
            return new Color(0.0f, 0.0f, (139.0f - 59.0f * -(altura + 1500.0f) / 500.0f) / 256.0f);
        }
        return new Color(0.0f, 0.0f, 0.3125f);
    }

    public void dibujar3D(GL gl) {
        gl.glPushMatrix();
        gl.glMultMatrixf(this.getTafin().getMatriz(), 0);
        for (int fila = 0; fila < this._longitud - 1; ++fila) {
            for (int columna = 0; columna < this._anchura - 1; ++columna) {
                PV3D[] normales = this.calcularNormal(fila, columna);
                boolean sumergido = true;
                gl.glBegin(9);
                Color color = Terreno.colorDeAltura(this._alturas[fila][columna]);
                gl.glColor3f(color.getRed(), color.getGreen(), color.getBlue());
                gl.glNormal3f(normales[0].getX(), normales[0].getY(), normales[0].getZ());
                gl.glVertex3f((float)fila, this._alturas[fila][columna], (float)columna);
                if (this._alturas[fila][columna] > 0.0f) {
                    sumergido = false;
                }
                color = Terreno.colorDeAltura(this._alturas[fila][columna + 1]);
                gl.glColor3f(color.getRed(), color.getGreen(), color.getBlue());
                gl.glNormal3f(normales[0].getX(), normales[0].getY(), normales[0].getZ());
                gl.glVertex3f((float)fila, this._alturas[fila][columna + 1], (float)(columna + 1));
                if (this._alturas[fila][columna + 1] > 0.0f) {
                    sumergido = false;
                }
                color = Terreno.colorDeAltura(this._alturas[fila + 1][columna]);
                gl.glColor3f(color.getRed(), color.getGreen(), color.getBlue());
                gl.glNormal3f(normales[0].getX(), normales[0].getY(), normales[0].getZ());
                gl.glVertex3f((float)(fila + 1), this._alturas[fila + 1][columna], (float)columna);
                if (this._alturas[fila + 1][columna] > 0.0f) {
                    sumergido = false;
                }
                gl.glEnd();
                if (sumergido) {
                    gl.glBegin(9);
                    color = Terreno.colorDeAltura(this._alturas[fila][columna]);
                    gl.glColor3f(color.getRed(), color.getGreen(), color.getBlue());
                    gl.glNormal3f(0.0f, 1.0f, 0.0f);
                    gl.glVertex3f((float)fila, 0.0f, (float)columna);
                    color = Terreno.colorDeAltura(this._alturas[fila][columna + 1]);
                    gl.glColor3f(color.getRed(), color.getGreen(), color.getBlue());
                    gl.glNormal3f(0.0f, 1.0f, 0.0f);
                    gl.glVertex3f((float)fila, 0.0f, (float)(columna + 1));
                    color = Terreno.colorDeAltura(this._alturas[fila + 1][columna]);
                    gl.glColor3f(color.getRed(), color.getGreen(), color.getBlue());
                    gl.glNormal3f(0.0f, 1.0f, 0.0f);
                    gl.glVertex3f((float)(fila + 1), 0.0f, (float)columna);
                    gl.glEnd();
                }
                sumergido = true;
                gl.glBegin(9);
                color = Terreno.colorDeAltura(this._alturas[fila][columna + 1]);
                gl.glColor3f(color.getRed(), color.getGreen(), color.getBlue());
                gl.glNormal3f(normales[1].getX(), normales[1].getY(), normales[1].getZ());
                gl.glVertex3f((float)fila, this._alturas[fila][columna + 1], (float)(columna + 1));
                if (this._alturas[fila][columna] > 0.0f) {
                    sumergido = false;
                }
                color = Terreno.colorDeAltura(this._alturas[fila + 1][columna + 1]);
                gl.glColor3f(color.getRed(), color.getGreen(), color.getBlue());
                gl.glNormal3f(normales[1].getX(), normales[1].getY(), normales[1].getZ());
                gl.glVertex3f((float)(fila + 1), this._alturas[fila + 1][columna + 1], (float)(columna + 1));
                if (this._alturas[fila][columna + 1] > 0.0f) {
                    sumergido = false;
                }
                color = Terreno.colorDeAltura(this._alturas[fila + 1][columna]);
                gl.glColor3f(color.getRed(), color.getGreen(), color.getBlue());
                gl.glNormal3f(normales[1].getX(), normales[1].getY(), normales[1].getZ());
                gl.glVertex3f((float)(fila + 1), this._alturas[fila + 1][columna], (float)columna);
                if (this._alturas[fila + 1][columna] > 0.0f) {
                    sumergido = false;
                }
                gl.glEnd();
                if (!sumergido) continue;
                gl.glBegin(9);
                color = Terreno.colorDeAltura(this._alturas[fila][columna + 1]);
                gl.glColor3f(color.getRed(), color.getGreen(), color.getBlue());
                gl.glNormal3f(0.0f, 1.0f, 0.0f);
                gl.glVertex3f((float)fila, 0.0f, (float)(columna + 1));
                color = Terreno.colorDeAltura(this._alturas[fila + 1][columna + 1]);
                gl.glColor3f(color.getRed(), color.getGreen(), color.getBlue());
                gl.glNormal3f(0.0f, 1.0f, 0.0f);
                gl.glVertex3f((float)(fila + 1), 0.0f, (float)(columna + 1));
                color = Terreno.colorDeAltura(this._alturas[fila + 1][columna]);
                gl.glColor3f(color.getRed(), color.getGreen(), color.getBlue());
                gl.glNormal3f(0.0f, 1.0f, 0.0f);
                gl.glVertex3f((float)(fila + 1), 0.0f, (float)columna);
                gl.glEnd();
            }
        }
        gl.glPopMatrix();
    }

    private PV3D[] calcularNormal(int fila, int columna) {
        PV3D[] normales = new PV3D[2];
        float nx = 0.0f;
        float ny = 0.0f;
        float nz = 0.0f;
        nx += (this._alturas[fila][columna] - this._alturas[fila][columna + 1]) * (float)(columna + (columna + 1));
        ny += (float)((columna - (columna + 1)) * (fila + fila));
        nz += (float)(fila - fila) * (this._alturas[fila][columna] + this._alturas[fila][columna + 1]);
        nx += (this._alturas[fila][columna + 1] - this._alturas[fila + 1][columna]) * (float)(columna + 1 + columna);
        ny += (float)((columna + 1 - columna) * (fila + (fila + 1)));
        nz += (float)(fila - (fila + 1)) * (this._alturas[fila][columna + 1] + this._alturas[fila + 1][columna]);
        normales[0] = new PV3D(nx += (this._alturas[fila + 1][columna] - this._alturas[fila][columna]) * (float)(columna + columna), ny += (float)((columna - columna) * (fila + 1 + fila)), nz += (float)(fila + 1 - fila) * (this._alturas[fila + 1][columna] + this._alturas[fila][columna]));
        nx = 0.0f;
        ny = 0.0f;
        nz = 0.0f;
        nx += (this._alturas[fila][columna + 1] - this._alturas[fila + 1][columna + 1]) * (float)(columna + 1 + (columna + 1));
        ny += (float)((columna + 1 - (columna + 1)) * (fila + (fila + 1)));
        nz += (float)(fila - (fila + 1)) * (this._alturas[fila][columna + 1] + this._alturas[fila + 1][columna + 1]);
        nx += (this._alturas[fila + 1][columna + 1] - this._alturas[fila + 1][columna]) * (float)(columna + 1 + columna);
        ny += (float)((columna + 1 - columna) * (fila + 1 + (fila + 1)));
        nz += (float)(fila + 1 - (fila + 1)) * (this._alturas[fila + 1][columna + 1] + this._alturas[fila + 1][columna]);
        normales[1] = new PV3D(nx += (this._alturas[fila + 1][columna] - this._alturas[fila][columna + 1]) * (float)(columna + (columna + 1)), ny += (float)((columna - (columna + 1)) * (fila + 1 + fila)), nz += (float)(fila + 1 - fila) * (this._alturas[fila + 1][columna] + this._alturas[fila][columna + 1]));
        return normales;
    }

    public void dibujar2D(GL gl, float ancho, float alto, float xLeft, float xRight, float yBot, float yTop) {
        float margenError = 0.05f;
        float incremento = (xRight - xLeft) / ancho;
        incremento -= incremento * margenError;
        gl.glBegin(0);
        float y = yBot;
        for (float x = xLeft; x < xRight; x += incremento) {
            for (y = yBot; y < yTop; y += incremento) {
                float altura;
                if (!(x >= 0.0f) || !(x < (float)this._longitud) || !(y >= 0.0f) || !(y < (float)this._anchura)) continue;
                if (x < (float)(this._longitud - 1) && y < (float)(this._anchura - 1)) {
                    float p00 = (1.0f - (x - (float)((int)x))) * (1.0f - (y - (float)((int)y))) * this._alturas[(int)x][(int)y];
                    float p10 = (x - (float)((int)x)) * (1.0f - (y - (float)((int)y))) * this._alturas[(int)(x + 1.0f)][(int)y];
                    float p01 = (1.0f - (x - (float)((int)x))) * (y - (float)((int)y)) * this._alturas[(int)x][(int)(y + 1.0f)];
                    float p11 = (x - (float)((int)x)) * (y - (float)((int)y)) * this._alturas[(int)(x + 1.0f)][(int)(y + 1.0f)];
                    altura = p00 + p10 + p01 + p11;
                } else {
                    altura = this._alturas[(int)x][(int)y];
                }
                Color color = Terreno.colorDeMapa(altura);
                gl.glColor3f(color.getRed(), color.getGreen(), color.getBlue());
                gl.glVertex2f(x, y);
            }
        }
        gl.glEnd();
    }
}

