/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.incidencias;

import java.util.Vector;
import javax.media.opengl.GL;
import proyectoSI.grafico.Dibujable;
import proyectoSI.grafico.ModeloNaufrago;
import proyectoSI.grafico.estructura.terreno.Terreno;
import proyectoSI.matematico.IFuncion;
import proyectoSI.matematico.IIntegrador;
import proyectoSI.matematico.RungeKutta;
import proyectoSI.otrosModelos.Corrientes;
import proyectoSI.otrosModelos.Mar;
import xdevs.kernel.modeling.AtomicStateImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class Naufrago
extends AtomicStateImpl
implements IFuncion,
Dibujable {
    public static final int ON = 1;
    public static final int OFF = 2;
    public static final String InSolicitud = "INsolicitud";
    public static final String Out = "OUT";
    public static final String tactual = "tactual";
    public static final String n = "n";
    public static final String e = "e";
    public static final String tiempo = "tiempo";
    public static final String tinicial = "tinicial";
    public static final String Phase = "phase";
    public static final int Crea = 1;
    public static final int Encontrar = 2;
    private IIntegrador integrador;
    private Corrientes corriente;
    private Mar mar;
    private Terreno _terreno;
    private ModeloNaufrago _modeloNaufrago;

    public Naufrago(String name, int tiempoInicial, Terreno terreno) {
        super(name);
        this.addInport(InSolicitud);
        this.addOutport(Out);
        this.addState(n);
        this.addState(e);
        this.addState(tactual);
        this.addState(tiempo);
        this.addState(tinicial);
        this.addState(Phase);
        this.setStateValue(tinicial, tiempoInicial);
        this.setStateValue(tiempo, 0);
        this.setStateValue(Phase, 1);
        this.corriente = new Corrientes(0.0, 1.0);
        this.mar = new Mar();
        this.integrador = new RungeKutta();
        this._terreno = terreno;
    }

    public void deltext(double arg0, Message arg1) {
        if (this.getStateValue(Phase).intValue() == 1) {
            for (Vector vector : arg1.getValuesOnPort(InSolicitud)) {
                if ((Integer)vector.get(0) == 1) {
                    this.setStateValue(n, (Double)vector.get(1));
                    this.setStateValue(e, (Double)vector.get(2));
                    continue;
                }
                if ((Integer)vector.get(0) != 2 || (Integer)vector.get(1) != Integer.parseInt(this.getName())) continue;
                System.out.println("naufrago rescatado");
                this.setStateValue(e, -10000000);
                this.setStateValue(n, -10000000);
                this.setStateValue(Phase, 2);
                this.setStateValue(tiempo, Double.POSITIVE_INFINITY);
            }
        }
        this.setSigma(this.getStateValue(tiempo).doubleValue());
    }

    public void deltint() {
        if (this.getStateValue(Phase).intValue() == 1) {
            this.mar.avanzaTiempo();
            this.corriente.ponOleaje(this.mar.dameSalidaActual());
            this.avanzaTiempo();
            int tiempoIni = this.getStateValue(tinicial).intValue();
            if (!(this.getStateValue(tactual).doubleValue() <= (double)tiempoIni) && this.getStateValue(tactual).doubleValue() > (double)tiempoIni) {
                this.setStateValue(tiempo, 30);
            }
            this.setSigma(this.getStateValue(tiempo).doubleValue());
        }
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        if (this.getStateValue(Phase).intValue() == 1) {
            Vector<Number> todo = new Vector<Number>();
            todo.add(this.getStateValue(n).doubleValue());
            todo.add(this.getStateValue(e).doubleValue());
            todo.add(this.getStateValue(tactual).doubleValue());
            todo.add(Integer.parseInt(this.getName()));
            msg.add(Out, todo);
        }
        return msg;
    }

    public void actualizaEstados(double[] estadosActuales) {
        this.setStateValue(e, estadosActuales[0]);
        this.setStateValue(n, estadosActuales[1]);
    }

    public void avanzaTiempo() {
        double dtiempo = 30.0;
        this.corriente.avanzaTiempo(dtiempo);
        this.actualizaEstados(this.integrador.integra(this, dtiempo, this.getStateValue(tactual).doubleValue()));
        this.setStateValue(tactual, this.getStateValue(tactual).doubleValue() + dtiempo);
    }

    public double[] dameControlActual() {
        return null;
    }

    public double[] dameDerivadas(double tiempo, double[] estados, double[] control) {
        int num_estados = 2;
        double[] derivadas = new double[num_estados];
        derivadas[0] = this.corriente.dameUc();
        derivadas[1] = this.corriente.dameVc();
        return derivadas;
    }

    public double[] dameEstadoActual() {
        int num_estados = 2;
        double[] estado = new double[num_estados];
        estado[0] = this.getStateValue(e).doubleValue();
        estado[1] = this.getStateValue(n).doubleValue();
        return estado;
    }

    public void dibujar3D(GL gl) {
        this._modeloNaufrago = new ModeloNaufrago(gl, this._terreno);
        this._modeloNaufrago.getTafin().escalar(10.0f, 10.0f, 10.0f, gl);
        this._modeloNaufrago.posicionar(this.getStateValue(n).floatValue() / 10000.0f * 100.0f, 0.0f, this.getStateValue(e).floatValue() / 10000.0f * 100.0f, gl);
        this._modeloNaufrago.dibujar3D(gl);
    }

    public void inicializar(GL gl) {
        this._modeloNaufrago = new ModeloNaufrago(gl, this._terreno);
    }

    public void dibujar2D(GL gl) {
        this._modeloNaufrago.dibujar2D(this.getStateValue(n).floatValue(), this.getStateValue(e).floatValue(), gl);
    }
}

