/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.otrosModelos;

import java.util.Random;
import proyectoSI.matematico.IFuncion;
import proyectoSI.matematico.IIntegrador;
import proyectoSI.matematico.RungeKutta;
import proyectoSI.otrosModelos.FuncionCorriente;

public class Corrientes
implements IFuncion {
    private double velocidad_actual;
    private FuncionCorriente funcion;
    private IIntegrador integrador = new RungeKutta();
    private double tiempo_actual = 0.0;
    private double tiempo_integracion;
    private double mu;
    private double x;
    private double y;
    private double oleaje;

    public Corrientes(double mu, double tiempo_integracion) {
        this.funcion = new FuncionCorriente();
        this.mu = mu;
        this.tiempo_integracion = tiempo_integracion;
    }

    public void actualizaEstados(double[] estadosActuales) {
        this.velocidad_actual = estadosActuales[0] < 0.5 ? 0.5 : (estadosActuales[0] > 3.0 ? 3.0 : estadosActuales[0]);
    }

    public void ponOleaje(double[] ds) {
        this.oleaje = ds[0];
    }

    public void avanzaTiempo(double tiempo) {
        this.tiempo_integracion = tiempo;
        this.avanzaTiempo();
    }

    public void avanzaTiempo() {
        this.actualizaEstados(this.integrador.integra(this, this.tiempo_integracion, this.tiempo_actual));
        this.tiempo_actual += this.tiempo_integracion;
    }

    public double[] dameControlActual() {
        return null;
    }

    public double dameUc() {
        return this.velocidad_actual * Math.cos(FuncionCorriente.dameCorriente(FuncionCorriente.variable, this.x, this.y) + this.oleaje);
    }

    public double dameVc() {
        return this.velocidad_actual * Math.sin(FuncionCorriente.dameCorriente(FuncionCorriente.variable, this.x, this.y) + this.oleaje);
    }

    public double[] dameDerivadas(double tiempo, double[] estados, double[] control) {
        double[] derivadas = new double[1];
        Random randomizador = new Random();
        derivadas[0] = randomizador.nextGaussian() - this.mu * this.velocidad_actual;
        return derivadas;
    }

    public double[] dameEstadoActual() {
        double[] estados = new double[]{this.velocidad_actual};
        return estados;
    }
}

