/*
 * Decompiled with CFR 0.152.
 */
package proyectoSI.tfxml;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import xdevs.kernel.modeling.AtomicStateImpl;
import xdevs.kernel.modeling.CoupledImpl;
import xdevs.kernel.modeling.api.Coupling;

public class Utils {
    private String carpeta;

    public Document readFile(String filename) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().parse(new File(filename));
            return doc;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void writeFile(Document doc, String filename) {
        try {
            OutputFormat format = new OutputFormat("xml", "UTF-8", true);
            XMLSerializer serializer = new XMLSerializer(format);
            FileWriter xmlFile = new FileWriter(new File(filename));
            serializer.setOutputCharStream(xmlFile);
            serializer.serialize(doc);
            xmlFile.flush();
            xmlFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void leer(String filename) {
        Document doc = this.readFile(filename);
        Element elem = doc.getDocumentElement();
        ArrayList<Node> cola = new ArrayList<Node>();
        cola.add(elem);
        File f1 = new File("C:" + File.separator + "Temporal");
        if (!f1.exists()) {
            f1.mkdir();
        }
        this.carpeta = f1.getPath();
        while (cola.size() != 0) {
            Element elemento = (Element)cola.get(0);
            this.escribir(elemento);
            cola.remove(0);
            if (!elemento.getNodeName().equals("Coupled")) continue;
            NodeList lista = elemento.getElementsByTagName("Coupled");
            for (int i = 0; i < lista.getLength(); ++i) {
                cola.add(lista.item(i));
            }
            NodeList lista1 = elemento.getElementsByTagName("Atomic");
            for (int i = 0; i < lista1.getLength(); ++i) {
                cola.add(lista1.item(i));
            }
        }
    }

    public void escribir(Element elemento) {
        try {
            File file = new File(this.carpeta + File.separator + elemento.getAttribute("File"));
            file.createNewFile();
        }
        catch (Exception e) {
            System.out.println("Fallos creacion del archivo");
        }
        try {
            BufferedWriter outfile = new BufferedWriter(new FileWriter(this.carpeta + File.separator + elemento.getAttribute("File")));
            if (elemento.getNodeName() == "Coupled") {
                NodeList aux1;
                outfile.write("import kernel.modeling.CoupledImpl;\nimport kernel.simulation.CoordinatorImpl;\nimport kernel.simulation.api.Coordinator;\n\n");
                outfile.write("public class " + elemento.getAttribute("Name") + " extends CoupledImpl {\n\n");
                outfile.write("  public " + elemento.getAttribute("Name") + "(String name) {\n");
                outfile.write("    super(name);\n");
                NodeList aux = elemento.getElementsByTagName("Ports");
                if (aux.getLength() != 0) {
                    int i;
                    aux1 = ((Element)aux.item(0)).getElementsByTagName("InPort");
                    for (i = 0; i < aux1.getLength(); ++i) {
                        outfile.write("    addInport(\"" + ((Element)aux1.item(i)).getAttribute("Name") + "\");\n");
                    }
                    aux1 = ((Element)aux.item(0)).getElementsByTagName("OutPort");
                    for (i = 0; i < aux1.getLength(); ++i) {
                        outfile.write("    addOutport(\"" + ((Element)aux1.item(i)).getAttribute("Name") + "\");\n");
                    }
                }
                if ((aux = elemento.getElementsByTagName("Connections")).getLength() != 0) {
                    int i;
                    aux1 = ((Element)aux.item(0)).getElementsByTagName("Connection");
                    ArrayList<String> listacomp = new ArrayList<String>();
                    for (i = 0; i < aux1.getLength(); ++i) {
                        if (!listacomp.contains(((Element)aux1.item(i)).getAttribute("ComponentFrom"))) {
                            listacomp.add(((Element)aux1.item(i)).getAttribute("ComponentFrom"));
                            outfile.write("    addComponent(" + ((Element)aux1.item(i)).getAttribute("ComponentFrom") + ");\n");
                        }
                        if (listacomp.contains(((Element)aux1.item(i)).getAttribute("ComponentTo"))) continue;
                        listacomp.add(((Element)aux1.item(i)).getAttribute("ComponentTo"));
                        outfile.write("    addComponent(" + ((Element)aux1.item(i)).getAttribute("ComponentTo") + ");\n");
                    }
                    for (i = 0; i < aux1.getLength(); ++i) {
                        outfile.write("    addCoupling(" + ((Element)aux1.item(i)).getAttribute("ComponentFrom") + ", " + ((Element)aux1.item(i)).getAttribute("ComponentFrom") + "." + ((Element)aux1.item(i)).getAttribute("PortFrom") + ", " + ((Element)aux1.item(i)).getAttribute("ComponentTo") + ", " + ((Element)aux1.item(i)).getAttribute("ComponentTo") + "." + ((Element)aux1.item(i)).getAttribute("PortTo") + ");\n");
                    }
                }
                outfile.write("  }\n\n");
                outfile.write("}");
            } else {
                int i;
                NodeList aux1;
                outfile.write("import kernel.modeling.AtomicStateImpl;\nimport kernel.modeling.MessageImpl;\nimport kernel.modeling.api.Message;\n\n");
                outfile.write("public class " + elemento.getAttribute("Name") + " extends AtomicStateImpl {\n\n");
                outfile.write("  public " + elemento.getAttribute("Name") + "(String name) {\n");
                outfile.write("    super(name);\n");
                NodeList aux = elemento.getElementsByTagName("Ports");
                if (aux.getLength() != 0) {
                    aux1 = ((Element)aux.item(0)).getElementsByTagName("InPort");
                    for (i = 0; i < aux1.getLength(); ++i) {
                        outfile.write("    addInport(\"" + ((Element)aux1.item(i)).getAttribute("Name") + "\");\n");
                    }
                    aux1 = ((Element)aux.item(0)).getElementsByTagName("OutPort");
                    for (i = 0; i < aux1.getLength(); ++i) {
                        outfile.write("    addOutport(\"" + ((Element)aux1.item(i)).getAttribute("Name") + "\");\n");
                    }
                }
                if ((aux = elemento.getElementsByTagName("GlobalState")).getLength() != 0) {
                    aux1 = ((Element)aux.item(0)).getElementsByTagName("Sigma");
                    if (aux1.getLength() != 0) {
                        outfile.write("    setSigma(" + ((Element)aux1.item(0)).getAttribute("Value") + ");\n");
                    }
                    if ((aux1 = ((Element)aux.item(0)).getElementsByTagName("Phase")).getLength() != 0) {
                        outfile.write("    setPhase(\"" + ((Element)aux1.item(0)).getAttribute("Value") + "\");\n");
                    }
                }
                if ((aux = elemento.getElementsByTagName("States")).getLength() != 0) {
                    aux1 = ((Element)aux.item(0)).getElementsByTagName("State");
                    for (i = 0; i < aux1.getLength(); ++i) {
                        outfile.write("    addState(\"" + ((Element)aux1.item(0)).getAttribute("Name") + "\");\n");
                        outfile.write("    setStateValue(\"" + ((Element)aux1.item(i)).getAttribute("Name") + "\", " + ((Element)aux1.item(i)).getAttribute("Value") + ");\n");
                    }
                }
                outfile.write("  }\n\n");
                outfile.write("  public void deltext() {\n");
                outfile.write("  }\n\n");
                outfile.write("  public void deltint() {\n");
                outfile.write("  }\n\n");
                outfile.write("  public Message lambda() {\n");
                outfile.write("  }\n\n");
                outfile.write("}");
            }
            outfile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (elemento.getNodeName() == "Coupled") {
            // empty if block
        }
    }

    public void leerJava(Object ob, String archivo) {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element root = document.createElement("xDevs");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            root.setAttribute("xsi:noNamespaceSchemaLocation", "Esquema.xsd");
            document.appendChild(root);
            this.xmlrec(root, ob, document);
            this.writeFile(document, archivo);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void xmlrec(Element a, Object ob, Document document) {
        if (ob instanceof CoupledImpl) {
            Element coupled = document.createElement("Coupled");
            coupled.setAttribute("Name", ((CoupledImpl)ob).getName());
            coupled.setAttribute("File", ((CoupledImpl)ob).getName() + ".java");
            coupled.setAttribute("Host", "");
            a.appendChild(coupled);
            Object[] components = ((CoupledImpl)ob).getComponents().toArray();
            for (int i = 0; i < components.length; ++i) {
                this.xmlrec(coupled, components[i], document);
            }
            Element connec = document.createElement("Connections");
            coupled.appendChild(connec);
            Object[] eic = ((CoupledImpl)ob).getEICs().toArray();
            for (int i = 0; i < eic.length; ++i) {
                Element eicport = document.createElement("Connection");
                eicport.setAttribute("ComponentFrom", ((Coupling)eic[i]).getComponentFrom().getName());
                eicport.setAttribute("PortFrom", ((Coupling)eic[i]).getNamePortFrom());
                eicport.setAttribute("ComponentTo", ((Coupling)eic[i]).getComponentTo().getName());
                eicport.setAttribute("PortTo", ((Coupling)eic[i]).getNamePortTo());
                connec.appendChild(eicport);
            }
            Object[] ic = ((CoupledImpl)ob).getICs().toArray();
            for (int i = 0; i < ic.length; ++i) {
                Element icport = document.createElement("Connection");
                icport.setAttribute("ComponentFrom", ((Coupling)ic[i]).getComponentFrom().getName());
                icport.setAttribute("PortFrom", ((Coupling)ic[i]).getNamePortFrom());
                icport.setAttribute("ComponentTo", ((Coupling)ic[i]).getComponentTo().getName());
                icport.setAttribute("PortTo", ((Coupling)ic[i]).getNamePortTo());
                connec.appendChild(icport);
            }
            Object[] eoc = ((CoupledImpl)ob).getEOCs().toArray();
            for (int i = 0; i < eoc.length; ++i) {
                Element eocport = document.createElement("Connection");
                eocport.setAttribute("ComponentFrom", ((Coupling)eoc[i]).getComponentFrom().getName());
                eocport.setAttribute("PortFrom", ((Coupling)eoc[i]).getNamePortFrom());
                eocport.setAttribute("ComponentTo", ((Coupling)eoc[i]).getComponentTo().getName());
                eocport.setAttribute("PortTo", ((Coupling)eoc[i]).getNamePortTo());
                connec.appendChild(eocport);
            }
        } else {
            System.out.println("Atomic");
            Element atomic = document.createElement("Atomic");
            atomic.setAttribute("Name", ((AtomicStateImpl)ob).getName());
            atomic.setAttribute("File", ((AtomicStateImpl)ob).getName() + ".java");
            atomic.setAttribute("Host", "");
            a.appendChild(atomic);
            Element ports = document.createElement("Ports");
            atomic.appendChild(ports);
            Set<String> inports = ((AtomicStateImpl)ob).getInportNames();
            Object[] arrinports = inports.toArray();
            for (int i = 0; i < arrinports.length; ++i) {
                Element ip = document.createElement("InPort");
                ip.setAttribute("Name", (String)arrinports[i]);
                ports.appendChild(ip);
            }
            Set<String> outports = ((AtomicStateImpl)ob).getOutportNames();
            Object[] arroutports = outports.toArray();
            for (int i = 0; i < arroutports.length; ++i) {
                Element ip = document.createElement("OutPort");
                ip.setAttribute("Name", (String)arroutports[i]);
                ports.appendChild(ip);
            }
            Element gs = document.createElement("GlobalState");
            atomic.appendChild(gs);
            Element sigma = document.createElement("Sigma");
            sigma.setAttribute("value", Double.valueOf(((AtomicStateImpl)ob).getSigma()).toString());
            Element phase = document.createElement("Phase");
            phase.setAttribute("value", ((AtomicStateImpl)ob).getPhase());
            gs.appendChild(sigma);
            gs.appendChild(phase);
            Element st = document.createElement("States");
            atomic.appendChild(st);
            Set<String> states = ((AtomicStateImpl)ob).getStates();
            Object[] arrstates = states.toArray();
            for (int i = 0; i < arrstates.length; ++i) {
                Element ip = document.createElement("State");
                ip.setAttribute("Name", (String)arrstates[i]);
                Number num = ((AtomicStateImpl)ob).getStateValue((String)arrstates[i]);
                if (num instanceof Integer) {
                    ip.setAttribute("Type", "Integer");
                }
                if (num instanceof Float) {
                    ip.setAttribute("Type", "Float");
                }
                if (num instanceof Double) {
                    ip.setAttribute("Type", "Double");
                }
                if (num instanceof Long) {
                    ip.setAttribute("Type", "Long");
                }
                if (num instanceof Short) {
                    ip.setAttribute("Type", "Short");
                }
                if (num instanceof Byte) {
                    ip.setAttribute("Type", "Byte");
                }
                ip.setAttribute("Value", num.toString());
                st.appendChild(ip);
            }
        }
    }
}

