/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.Iterator;
import xdevs.kernel.modeling.AtomicDDImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.DevsDess;
import xdevs.kernel.modeling.api.Message;

public class BarrelFiller
extends AtomicDDImpl {
    public static final String on_off = "on_off";
    public static final String cout = "cout";
    public static final String inflow = "inflow";
    public static final String barrel = "barrel";
    private position valve;
    private double contents;

    public BarrelFiller(String name, position valve, double contents) {
        super(name);
        this.valve = valve;
        this.contents = contents;
        super.addInport(on_off, DevsDess.VALUE_TYPE.DISCR);
        super.addOutport(barrel, DevsDess.VALUE_TYPE.DISCR);
        super.addOutport(cout, DevsDess.VALUE_TYPE.CONT);
        super.addInport(inflow, DevsDess.VALUE_TYPE.CONT);
    }

    public boolean cint(double e) {
        System.out.println("cint: " + this.contents);
        return this.contents >= 10.0;
    }

    public void deltint() {
        this.contents = 0.0;
    }

    public void deltext(double e, Message xDiscr) {
        this.valve = this.valve == position.ON ? position.OFF : position.ON;
    }

    public void f(Message xCont, double h) {
        if (this.valve == position.ON) {
            Iterator<Object> itr = xCont.getValuesOnPort(inflow).iterator();
            this.contents += h * (Double)itr.next();
        }
    }

    public Message lambdaCont() {
        System.out.println("lambdaCont: " + this.contents);
        MessageImpl msg = new MessageImpl();
        msg.add(cout, this.contents);
        return msg;
    }

    public Message lambdaDiscr() {
        System.out.println("barrel: 10-liter-barrel");
        MessageImpl msg = new MessageImpl();
        msg.add(barrel, "10-liter-barrel");
        return msg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum position {
        ON,
        OFF;

    }
}

