/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import lib.atomic.general.GeneratorView;
import lib.atomic.general.ProcessorView;
import lib.atomic.general.TransducerView;
import org.jgraph.JGraph;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;

public class GraphicExample {
    public static void main(String[] args) {
        DefaultGraphModel model = new DefaultGraphModel();
        GraphLayoutCache view = new GraphLayoutCache((GraphModel)model, (CellViewFactory)new DefaultCellViewFactory());
        JGraph graph = new JGraph((GraphModel)model, view);
        graph.setPortsVisible(true);
        GeneratorView generator = new GeneratorView("Generator", 3.0);
        generator.setBounds(40, 40, 60, 80);
        ProcessorView processor = new ProcessorView("Processor", 3.0);
        processor.setBounds(180, 40, 70, 80);
        TransducerView transducer = new TransducerView("Transducer", 100.0);
        transducer.setBounds(60, 150, 80, 120);
        graph.getGraphLayoutCache().insert((Object)generator.getNodeView());
        graph.getGraphLayoutCache().insert((Object)processor.getNodeView());
        graph.getGraphLayoutCache().insert((Object)transducer.getNodeView());
        DefaultEdge edge = new DefaultEdge();
        DefaultPort port = (DefaultPort)generator.getNodeView().getChildAt(1);
        for (Object key : port.getAttributes().keySet()) {
            System.out.println(key.toString());
        }
        edge.setSource((Object)generator.getNodeView().getChildAt(1));
        edge.setTarget((Object)processor.getNodeView().getChildAt(0));
        GraphConstants.setLineEnd((Map)edge.getAttributes(), (int)1);
        GraphConstants.setEndFill((Map)edge.getAttributes(), (boolean)true);
        graph.getGraphLayoutCache().insert((Object)edge);
        JFrame frame = new JFrame();
        frame.getContentPane().add(new JScrollPane((Component)graph));
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                e.getWindow().dispose();
            }
        });
        frame.pack();
        frame.setVisible(true);
    }
}

