/*
 * Decompiled with CFR 0.152.
 */
package xdevs.kernel.simulation;

import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.AtomicDD;
import xdevs.kernel.modeling.api.DevsDess;
import xdevs.kernel.modeling.api.Message;
import xdevs.kernel.simulation.api.DDCoordinator;
import xdevs.kernel.simulation.api.DDSimulator;

public class DDSimulatorImpl
implements DDSimulator {
    protected DDCoordinator parent = null;
    protected AtomicDD model;
    protected Message inputDiscr;
    protected Message inputCont;
    protected Message outputDiscr;
    protected Message outputCont;
    protected Message outputStateEvent;
    protected double tL;
    protected double tN;
    protected double e;

    public DDSimulatorImpl(AtomicDD model) {
        this.model = model;
        this.inputDiscr = new MessageImpl();
        this.inputCont = new MessageImpl();
        this.outputDiscr = new MessageImpl();
        this.outputCont = new MessageImpl();
        this.outputStateEvent = new MessageImpl();
    }

    public void initialize(double t) {
        this.tL = t;
        this.tN = Double.POSITIVE_INFINITY;
        this.e = Double.POSITIVE_INFINITY;
    }

    public void deltfcnDiscr(double t) {
        if (this.inputDiscr.isEmpty() && t != this.tN) {
            return;
        }
        if (this.inputDiscr.isEmpty() && t == this.tN) {
            this.model.deltint();
        } else if (!this.inputDiscr.isEmpty() && t != this.tN) {
            this.e = t - this.tL;
            this.model.deltext(this.e, this.inputDiscr);
        }
        this.tL = t;
        this.tN = Double.POSITIVE_INFINITY;
        this.inputDiscr = new MessageImpl();
    }

    public void deltfcnCont(double t, double h) {
        if (!this.inputCont.isEmpty() && !this.inputCont.isEmpty()) {
            this.model.f(this.inputCont, h);
        }
        this.tN = this.model.cint(this.e) ? t + h : Double.POSITIVE_INFINITY;
        this.tL = t;
        this.inputCont = new MessageImpl();
    }

    public void lambdaDiscr(double t) {
        if (t != this.tN) {
            this.outputDiscr = new MessageImpl();
        } else {
            this.outputDiscr = this.model.lambdaDiscr();
            if (this.outputDiscr == null) {
                this.outputDiscr = new MessageImpl();
            }
        }
    }

    public void lambdaCont(double t) {
        this.outputCont = this.model.lambdaCont();
        if (this.outputCont == null) {
            this.outputCont = new MessageImpl();
        }
    }

    public void lambdaStateEvent(double t, double h) {
        this.outputStateEvent = new MessageImpl();
        if (t + h == this.tN) {
            this.outputStateEvent.add("se", this.tN);
        }
    }

    public void setTL(double tL) {
        this.tL = tL;
    }

    public void setTN(double tN) {
        this.tN = tN;
    }

    public double getTL() {
        return this.tL;
    }

    public double getTN() {
        return this.tN;
    }

    public AtomicDD getModel() {
        return this.model;
    }

    public void setParent(DDCoordinator parent) {
        this.parent = parent;
    }

    public DDCoordinator getParent() {
        return this.parent;
    }

    public Message getInput(DevsDess.VALUE_TYPE value_type) {
        if (value_type == DevsDess.VALUE_TYPE.DISCR) {
            return this.inputDiscr;
        }
        return this.inputCont;
    }

    public Message getOutput(DevsDess.VALUE_TYPE value_type) {
        if (value_type == DevsDess.VALUE_TYPE.DISCR) {
            return this.outputDiscr;
        }
        return this.outputCont;
    }

    public Message getOutputStateEvent() {
        return this.outputStateEvent;
    }
}

