/*
 * Decompiled with CFR 0.152.
 */
package editor.ext.jgraph;

import editor.ext.jgraph.MyComplexNode;
import editor.ext.jgraph.MyPort;
import editor.ext.model.EntrySimModTable;
import editor.ext.model.MySimpleModel;
import java.awt.geom.Point2D;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;

public class AtomicNode
extends DefaultGraphCell {
    private static final long serialVersionUID = 1L;
    int inPortsCount = 0;
    int outPortsCount = 0;
    MyComplexNode complex = null;
    MySimpleModel myAttributes;

    public AtomicNode(String label) {
        super((Object)label);
    }

    public void setInPortsCount(int inPortsCount) {
        this.inPortsCount = inPortsCount;
    }

    public void setOutPortsCount(int outPortsCount) {
        this.outPortsCount = outPortsCount;
    }

    public void addAtribute(String name, String type, String value, String doc) throws Exception {
        this.myAttributes.addAtribute(name, type, value, doc);
    }

    public void addGenericInPort() {
        MyPort port0 = new MyPort(true);
        ++this.inPortsCount;
        this.add((MutableTreeNode)((Object)port0));
        this.updatePortsPosition();
    }

    public void addGenericOutPort() {
        MyPort port0 = new MyPort(false);
        ++this.outPortsCount;
        this.add((MutableTreeNode)((Object)port0));
        this.updatePortsPosition();
    }

    private void updatePortsPosition() {
        List ports = this.getPorts();
        Iterator it = ports.iterator();
        int nDivIn = this.inPortsCount + 1;
        int nDivOut = this.outPortsCount + 1;
        int inY = 1;
        int outY = 1;
        while (it.hasNext()) {
            MyPort port = (MyPort)((Object)it.next());
            if (port.isInput()) {
                GraphConstants.setOffset((Map)port.getAttributes(), (Point2D)new Point2D.Double(0.0, 1000 / nDivIn * inY));
                ++inY;
                continue;
            }
            GraphConstants.setOffset((Map)port.getAttributes(), (Point2D)new Point2D.Double(1000.0, 1000 / nDivOut * outY));
            ++outY;
        }
    }

    private List getPorts() {
        ArrayList ports = new ArrayList();
        for (Object current : this.getChildren()) {
            if (this.complex == null || !this.complex.getModel().isPort(current)) continue;
            ports.add(current);
        }
        return ports;
    }

    public MyComplexNode getComplex() {
        return this.complex;
    }

    public void setComplex(MyComplexNode complex) {
        this.complex = complex;
    }

    public MySimpleModel getMyAttributes() {
        return this.myAttributes;
    }

    public void setMyAttributes(MySimpleModel myAttributes) {
        this.myAttributes = myAttributes;
    }

    public Object clone() {
        AtomicNode node = (AtomicNode)((Object)super.clone());
        Enumeration children = this.children();
        while (children.hasMoreElements()) {
            MyPort childClone;
            Object obj = children.nextElement();
            if (obj instanceof MyPort) {
                childClone = (MyPort)((Object)((MyPort)((Object)obj)).clone());
                node.add((MutableTreeNode)((Object)childClone));
                continue;
            }
            if (obj instanceof DefaultPort) {
                childClone = (DefaultPort)((DefaultPort)obj).clone();
                node.add((MutableTreeNode)((Object)childClone));
                continue;
            }
            if (obj instanceof DefaultEdge) {
                childClone = (DefaultEdge)((DefaultEdge)obj).clone();
                node.add((MutableTreeNode)((Object)childClone));
                continue;
            }
            AtomicNode child = (AtomicNode)((Object)obj);
            AtomicNode childClone2 = (AtomicNode)((Object)child.clone());
            node.add((MutableTreeNode)((Object)childClone2));
        }
        node.setInPortsCount(this.getInPortsCount());
        node.setOutPortsCount(this.getOutPortsCount());
        MySimpleModel simple = node.getMyAttributes();
        if (simple != null) {
            node.setMyAttributes((MySimpleModel)simple.clone());
        }
        node.setComplex(new MyComplexNode((GraphModel)new DefaultGraphModel()));
        return node;
    }

    public Map cloneCells(Object[] cells) {
        Hashtable<Object, Object> map = new Hashtable<Object, Object>();
        for (int i = 0; i < cells.length; ++i) {
            map.put(cells[i], this.cloneCell(cells[i]));
        }
        for (Map.Entry entry : map.entrySet()) {
            Port anchor;
            Object obj = entry.getValue();
            Object cell = entry.getKey();
            Object parent = this.getParent(cell);
            if (parent != null) {
                parent = map.get(parent);
            }
            if (parent != null) {
                ((DefaultMutableTreeNode)parent).add((DefaultMutableTreeNode)obj);
            }
            if (!(obj instanceof Port) || (anchor = ((Port)obj).getAnchor()) == null) continue;
            ((Port)obj).setAnchor((Port)map.get(anchor));
        }
        return map;
    }

    public Object getParent(Object child) {
        if (child != null && child instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)child).getParent();
        }
        return null;
    }

    protected Object cloneCell(Object cellObj) {
        if (cellObj instanceof AtomicNode) {
            System.out.println("**********************");
            System.out.println("**********************");
            System.out.println("*********MyNode*************");
            System.out.println("**********************");
            System.out.println("**********************");
            System.out.println("**********************");
            DefaultGraphCell cell = (DefaultGraphCell)cellObj;
            DefaultGraphCell clone = (DefaultGraphCell)cell.clone();
            String oldStr = (String)cell.getUserObject();
            clone.setUserObject((Object)new String(oldStr));
            return clone;
        }
        if (cellObj instanceof MyPort) {
            System.out.println("**********************");
            System.out.println("**********************");
            System.out.println("*********MyPort*************");
            System.out.println("**********************");
            System.out.println("**********************");
            System.out.println("**********************");
            MyPort childClone = (MyPort)((Object)((MyPort)((Object)cellObj)).clone());
            return childClone;
        }
        if (cellObj instanceof DefaultPort) {
            System.out.println("**********************");
            System.out.println("**********************");
            System.out.println("*********DefaultPort*************");
            System.out.println("**********************");
            System.out.println("**********************");
            System.out.println("**********************");
            DefaultPort childClone = (DefaultPort)((DefaultPort)cellObj).clone();
            return childClone;
        }
        if (cellObj instanceof DefaultEdge) {
            System.out.println("**********************");
            System.out.println("**********************");
            System.out.println("*********DefaultEdge*************");
            System.out.println("**********************");
            System.out.println("**********************");
            System.out.println("**********************");
            DefaultEdge childClone = (DefaultEdge)((DefaultEdge)cellObj).clone();
            return childClone;
        }
        return cellObj;
    }

    public boolean isAtomic() {
        return this.complex == null;
    }

    public int getInPortsCount() {
        return this.inPortsCount;
    }

    public int getOutPortsCount() {
        return this.outPortsCount;
    }

    public void saveXML(PrintWriter modelFile) {
        modelFile.println("<AtomicModel Id=\"" + this.getUserObject() + "\">");
        modelFile.println("<Description>");
        modelFile.println("</Description>");
        modelFile.println("<List>");
        Hashtable<String, EntrySimModTable> atomicAtributes = this.getMyAttributes().getAttributes();
        Set<String> keys = atomicAtributes.keySet();
        for (String name : keys) {
            modelFile.println("<Item Name=\"" + name + "\" ");
            EntrySimModTable next = atomicAtributes.get(name);
            String type = next.getType();
            modelFile.println("Class=\"" + type + "\" ");
            String defaultValue = next.getDefaultValue();
            modelFile.println("Constructor=\"" + defaultValue + "\" ");
            String doc = next.getDoc();
            modelFile.println("Doc=\"" + doc + "\"/>");
        }
        modelFile.println("</List>");
        modelFile.println("</AtomicModel>");
    }
}

