/*
 * Decompiled with CFR 0.152.
 */
package editor.ext.jgraph;

import editor.ext.jgraph.AtomicNode;
import editor.ext.jgraph.MyPort;
import editor.ext.model.EntrySimModTable;
import editor.ext.model.MySimpleModel;
import editor.util.Util;
import editor.view.ModelWindow;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jgraph.JGraph;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyComplexNode
extends JGraph {
    public MyComplexNode(GraphModel model) {
        super(model);
    }

    public MyComplexNode(GraphModel model, GraphLayoutCache lay) {
        super(model, lay);
    }

    public MyComplexNode(GraphModel model, GraphLayoutCache lay, ModelWindow parentCanvas) {
        super(model, lay);
    }

    public void insertDefaultSubModel(String label, String imgPath, int numInPorts, int numOutPorts) {
        int i;
        System.out.println("insertDefaultSubModel");
        AtomicNode atomic = new AtomicNode(new String(label));
        MyComplexNode complex = new MyComplexNode((GraphModel)new DefaultGraphModel());
        atomic.setComplex(complex);
        GraphConstants.setBounds((Map)atomic.getAttributes(), (Rectangle2D)new Rectangle2D.Double(30.0, 30.0, 70.0, 20.0));
        GraphConstants.setBackground((Map)atomic.getAttributes(), (Color)Color.GREEN);
        GraphConstants.setBorderColor((Map)atomic.getAttributes(), (Color)Color.BLACK);
        GraphConstants.setOpaque((Map)atomic.getAttributes(), (boolean)true);
        this.setImage(atomic, imgPath);
        GraphConstants.setInset((Map)atomic.getAttributes(), (int)5);
        GraphConstants.setResize((Map)atomic.getAttributes(), (boolean)true);
        for (i = 0; i < numInPorts; ++i) {
            atomic.addGenericInPort();
        }
        for (i = 0; i < numOutPorts; ++i) {
            atomic.addGenericOutPort();
        }
        this.getGraphLayoutCache().insert((Object)atomic);
        this.setAntiAliased(true);
        Object[] allCells = DefaultGraphModel.getRoots((GraphModel)this.getModel());
        System.out.println("----->>>>>>" + allCells.length);
    }

    public void insertAtomicDefaultSubModel(String label) throws Exception {
        AtomicNode atomic = new AtomicNode(new String(label));
        MySimpleModel defaultAtributes = new MySimpleModel();
        Hashtable<String, EntrySimModTable> att = new Hashtable<String, EntrySimModTable>();
        EntrySimModTable entry1 = new EntrySimModTable("int", "10", "blabla");
        EntrySimModTable entry2 = new EntrySimModTable("real", "0", "blabla");
        EntrySimModTable entry3 = new EntrySimModTable("list", "?", "blabla");
        EntrySimModTable entry4 = new EntrySimModTable("int", "10", "blabla");
        att.put("ent1", entry1);
        att.put("ent2", entry2);
        att.put("ent3", entry3);
        att.put("ent4", entry4);
        defaultAtributes.setAttributes(att);
        atomic.setMyAttributes(defaultAtributes);
        GraphConstants.setBounds((Map)atomic.getAttributes(), (Rectangle2D)new Rectangle2D.Double(30.0, 30.0, 70.0, 20.0));
        GraphConstants.setBackground((Map)atomic.getAttributes(), (Color)Color.GREEN);
        GraphConstants.setBorderColor((Map)atomic.getAttributes(), (Color)Color.BLACK);
        GraphConstants.setOpaque((Map)atomic.getAttributes(), (boolean)true);
        atomic.addGenericInPort();
        this.getGraphLayoutCache().insert((Object)atomic);
        this.setAntiAliased(true);
        Object[] allCells = DefaultGraphModel.getRoots((GraphModel)this.getModel());
        System.out.println("----->>>>>>" + allCells.length);
    }

    public void insertAtomicDefaultSubModel(String label, Hashtable<String, EntrySimModTable> att) throws Exception {
        AtomicNode atomic = new AtomicNode(new String(label));
        MySimpleModel defaultAtributes = new MySimpleModel();
        defaultAtributes.setAttributes(att);
        atomic.setMyAttributes(defaultAtributes);
        GraphConstants.setBounds((Map)atomic.getAttributes(), (Rectangle2D)new Rectangle2D.Double(30.0, 30.0, 70.0, 20.0));
        GraphConstants.setBackground((Map)atomic.getAttributes(), (Color)Color.GREEN);
        GraphConstants.setBorderColor((Map)atomic.getAttributes(), (Color)Color.BLACK);
        GraphConstants.setOpaque((Map)atomic.getAttributes(), (boolean)true);
        atomic.addGenericInPort();
        this.getGraphLayoutCache().insert((Object)atomic);
        this.setAntiAliased(true);
        Object[] allCells = DefaultGraphModel.getRoots((GraphModel)this.getModel());
        System.out.println("----->>>>>>" + allCells.length);
    }

    public void insertSubModel(AtomicNode node) {
        System.out.println("insertSubModel");
        this.getGraphLayoutCache().insert((Object)node);
        this.setAntiAliased(true);
        Object[] allCells = DefaultGraphModel.getRoots((GraphModel)this.getModel());
        System.out.println("----->>>>>>" + allCells.length);
    }

    public AtomicNode findSubModel(String name) {
        System.out.println("findSubModel");
        GraphModel gm = this.getModel();
        Object[] allCells = DefaultGraphModel.getRoots((GraphModel)gm);
        return this.findCell(allCells, name);
    }

    private AtomicNode findCell(Object[] allCells, String name) {
        System.out.println("findCell");
        System.out.println(allCells);
        System.out.println(allCells.length);
        for (int i = 0; i < allCells.length; ++i) {
            System.out.println(i);
            if (!allCells[i].toString().equals(name)) continue;
            return (AtomicNode)((Object)allCells[i]);
        }
        return null;
    }

    private void setImage(AtomicNode atomic, String imgPath) {
        if (imgPath != null) {
            GraphConstants.setIcon((Map)atomic.getAttributes(), (Icon)new ImageIcon(Util.loadBufferedImage(imgPath), imgPath));
        }
    }

    public void insertConnection(AtomicNode source, AtomicNode end, int sourcePort, int endPort) {
        boolean endIn;
        MyPort pSource = (MyPort)((Object)source.getChildAt(sourcePort));
        MyPort pTarget = (MyPort)((Object)end.getChildAt(endPort));
        boolean sourceIn = !pSource.isInput();
        boolean bl = endIn = !pTarget.isInput();
        if (sourceIn && !endIn) {
            DefaultEdge edge = this.createEdge();
            if (this.getModel().acceptsSource((Object)edge, (Object)pSource) && this.getModel().acceptsTarget((Object)edge, (Object)pTarget)) {
                this.getGraphLayoutCache().insertEdge((Object)edge, (Object)pSource, (Object)pTarget);
            }
            this.setAntiAliased(true);
        } else {
            System.out.println("******************************No puede realizarse la conexi\ufffdn");
        }
    }

    public void insertConnection(MyPort pSource, MyPort pTarget) {
        boolean endIn;
        boolean sourceIn = !pSource.isInput();
        boolean bl = endIn = !pTarget.isInput();
        if (sourceIn && !endIn || !sourceIn && endIn) {
            System.out.println("********************insertConnection");
            DefaultEdge edge = this.createEdge();
            if (this.getModel().acceptsSource((Object)edge, (Object)pSource) && this.getModel().acceptsTarget((Object)edge, (Object)pTarget)) {
                TreeSet<DefaultEdge> setOfEdges = new TreeSet<DefaultEdge>();
                setOfEdges.add(edge);
                pSource.setEdges(setOfEdges);
                pTarget.setEdges(setOfEdges);
                this.getGraphLayoutCache().insertEdge((Object)edge, (Object)pSource, (Object)pTarget);
            }
            this.setAntiAliased(true);
        } else {
            System.out.println("******************************No puede realizarse la conexi\ufffdn");
        }
    }

    protected DefaultEdge createEdge() {
        DefaultEdge edge = new DefaultEdge();
        edge.getAttributes().applyMap(this.createEdgeAttributes());
        return edge;
    }

    private Map createEdgeAttributes() {
        Hashtable map = new Hashtable();
        GraphConstants.setLabelAlongEdge(map, (boolean)true);
        GraphConstants.setLineStyle(map, (int)11);
        GraphConstants.setRouting(map, (Edge.Routing)GraphConstants.ROUTING_SIMPLE);
        GraphConstants.setLineEnd(map, (int)1);
        GraphConstants.setEndFill(map, (boolean)true);
        return map;
    }
}

